/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.security.JaasConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JaasUtils.class);
    public static final String JAVA_LOGIN_CONFIG_PARAM = "java.security.auth.login.config";
    public static final String LOGIN_CONTEXT_SERVER = "KafkaServer";
    public static final String LOGIN_CONTEXT_CLIENT = "KafkaClient";
    public static final String SERVICE_NAME = "serviceName";
    public static final String ZK_SASL_CLIENT = "zookeeper.sasl.client";
    public static final String ZK_LOGIN_CONTEXT_NAME_KEY = "zookeeper.sasl.clientconfig";

    public static Configuration jaasConfig(LoginType loginType, Map<String, ?> configs) {
        Password jaasConfigArgs = (Password)configs.get("sasl.jaas.config");
        if (jaasConfigArgs != null) {
            int numModules;
            if (loginType == LoginType.SERVER) {
                throw new IllegalArgumentException("JAAS config property not supported for server");
            }
            JaasConfig jaasConfig = new JaasConfig(loginType, jaasConfigArgs.value());
            AppConfigurationEntry[] clientModules = jaasConfig.getAppConfigurationEntry(LoginType.CLIENT.contextName());
            int n = numModules = clientModules == null ? 0 : clientModules.length;
            if (numModules != 1) {
                throw new IllegalArgumentException("JAAS config property contains " + numModules + " login modules, should be one module");
            }
            return jaasConfig;
        }
        return JaasUtils.defaultJaasConfig(loginType);
    }

    private static Configuration defaultJaasConfig(LoginType loginType) {
        String loginContextName;
        Configuration jaasConfig;
        AppConfigurationEntry[] configEntries;
        String jaasConfigFile = System.getProperty(JAVA_LOGIN_CONFIG_PARAM);
        if (jaasConfigFile == null) {
            LOG.debug("System property 'java.security.auth.login.config' and Kafka SASL property 'sasl.jaas.config' are not set, using default JAAS configuration.");
        }
        if ((configEntries = (jaasConfig = Configuration.getConfiguration()).getAppConfigurationEntry(loginContextName = loginType.contextName())) == null) {
            String errorMessage = "Could not find a '" + loginContextName + "' entry in the JAAS configuration. System property '" + JAVA_LOGIN_CONFIG_PARAM + "' is " + (jaasConfigFile == null ? "not set" : jaasConfigFile);
            throw new IllegalArgumentException(errorMessage);
        }
        return jaasConfig;
    }

    public static String defaultServerJaasConfigOption(String key, String loginModuleName) throws IOException {
        return JaasUtils.jaasConfigOption(Configuration.getConfiguration(), LoginType.SERVER.contextName(), key, loginModuleName);
    }

    public static String jaasConfigOption(Configuration jaasConfig, String loginContextName, String key, String loginModuleName) throws IOException {
        AppConfigurationEntry[] configurationEntries = jaasConfig.getAppConfigurationEntry(loginContextName);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + loginContextName + "' entry in this JAAS configuration.";
            throw new IOException(errorMessage);
        }
        for (AppConfigurationEntry entry2 : configurationEntries) {
            Object val;
            if (loginModuleName != null && !loginModuleName.equals(entry2.getLoginModuleName()) || (val = entry2.getOptions().get(key)) == null) continue;
            return (String)val;
        }
        return null;
    }

    public static String defaultKerberosRealm() throws ClassNotFoundException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> classRef = System.getProperty("java.vendor").contains("IBM") ? Class.forName("com.ibm.security.krb5.internal.Config") : Class.forName("sun.security.krb5.Config");
        Method getInstanceMethod = classRef.getMethod("getInstance", new Class[0]);
        Object kerbConf = getInstanceMethod.invoke(classRef, new Object[0]);
        Method getDefaultRealmMethod = classRef.getDeclaredMethod("getDefaultRealm", new Class[0]);
        return (String)getDefaultRealmMethod.invoke(kerbConf, new Object[0]);
    }

    public static boolean isZkSecurityEnabled() {
        boolean isSecurityEnabled;
        boolean zkSaslEnabled = Boolean.parseBoolean(System.getProperty(ZK_SASL_CLIENT, "true"));
        String zkLoginContextName = System.getProperty(ZK_LOGIN_CONTEXT_NAME_KEY, "Client");
        try {
            Configuration loginConf = Configuration.getConfiguration();
            isSecurityEnabled = loginConf.getAppConfigurationEntry(zkLoginContextName) != null;
        }
        catch (Exception e) {
            throw new KafkaException("Exception while loading Zookeeper JAAS login context '" + zkLoginContextName + "'", e);
        }
        if (isSecurityEnabled && !zkSaslEnabled) {
            LOG.error("JAAS configuration is present, but system property zookeeper.sasl.client is set to false, which disables SASL in the ZooKeeper client");
            throw new KafkaException("Exception while determining if ZooKeeper is secure");
        }
        return isSecurityEnabled;
    }
}

