/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ProtoUtils;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.apache.kafka.common.utils.Utils;

public class CreateTopicsRequest
extends AbstractRequest {
    private static final String REQUESTS_KEY_NAME = "create_topic_requests";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String VALIDATE_ONLY_KEY_NAME = "validate_only";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String NUM_PARTITIONS_KEY_NAME = "num_partitions";
    private static final String REPLICATION_FACTOR_KEY_NAME = "replication_factor";
    private static final String REPLICA_ASSIGNMENT_KEY_NAME = "replica_assignment";
    private static final String REPLICA_ASSIGNMENT_PARTITION_ID_KEY_NAME = "partition_id";
    private static final String REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME = "replicas";
    private static final String CONFIG_KEY_KEY_NAME = "config_key";
    private static final String CONFIG_VALUE_KEY_NAME = "config_value";
    private static final String CONFIGS_KEY_NAME = "configs";
    private final Map<String, TopicDetails> topics;
    private final Integer timeout;
    private final boolean validateOnly;
    private final Set<String> duplicateTopics;
    public static final int NO_NUM_PARTITIONS = -1;
    public static final short NO_REPLICATION_FACTOR = -1;

    private CreateTopicsRequest(Map<String, TopicDetails> topics, Integer timeout, boolean validateOnly, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.CREATE_TOPICS.id, version)), version);
        ArrayList<Struct> createTopicRequestStructs = new ArrayList<Struct>(topics.size());
        for (Map.Entry<String, TopicDetails> entry2 : topics.entrySet()) {
            Struct singleRequestStruct = this.struct.instance(REQUESTS_KEY_NAME);
            String topic = entry2.getKey();
            TopicDetails args = entry2.getValue();
            singleRequestStruct.set(TOPIC_KEY_NAME, (Object)topic);
            singleRequestStruct.set(NUM_PARTITIONS_KEY_NAME, (Object)args.numPartitions);
            singleRequestStruct.set(REPLICATION_FACTOR_KEY_NAME, (Object)args.replicationFactor);
            ArrayList<Struct> replicaAssignmentsStructs = new ArrayList<Struct>(args.replicasAssignments.size());
            for (Map.Entry<Integer, List<Integer>> partitionReplicaAssignment : args.replicasAssignments.entrySet()) {
                Struct replicaAssignmentStruct = singleRequestStruct.instance(REPLICA_ASSIGNMENT_KEY_NAME);
                replicaAssignmentStruct.set(REPLICA_ASSIGNMENT_PARTITION_ID_KEY_NAME, (Object)partitionReplicaAssignment.getKey());
                replicaAssignmentStruct.set(REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME, (Object)partitionReplicaAssignment.getValue().toArray());
                replicaAssignmentsStructs.add(replicaAssignmentStruct);
            }
            singleRequestStruct.set(REPLICA_ASSIGNMENT_KEY_NAME, (Object)replicaAssignmentsStructs.toArray());
            ArrayList<Struct> configsStructs = new ArrayList<Struct>(args.configs.size());
            for (Map.Entry<String, String> configEntry : args.configs.entrySet()) {
                Struct configStruct = singleRequestStruct.instance(CONFIGS_KEY_NAME);
                configStruct.set(CONFIG_KEY_KEY_NAME, (Object)configEntry.getKey());
                configStruct.set(CONFIG_VALUE_KEY_NAME, (Object)configEntry.getValue());
                configsStructs.add(configStruct);
            }
            singleRequestStruct.set(CONFIGS_KEY_NAME, (Object)configsStructs.toArray());
            createTopicRequestStructs.add(singleRequestStruct);
        }
        this.struct.set(REQUESTS_KEY_NAME, (Object)createTopicRequestStructs.toArray());
        this.struct.set(TIMEOUT_KEY_NAME, (Object)timeout);
        if (version >= 1) {
            this.struct.set(VALIDATE_ONLY_KEY_NAME, (Object)validateOnly);
        }
        this.topics = topics;
        this.timeout = timeout;
        this.validateOnly = validateOnly;
        this.duplicateTopics = Collections.emptySet();
    }

    public CreateTopicsRequest(Struct struct, short versionId) {
        super(struct, versionId);
        Object[] requestStructs = struct.getArray(REQUESTS_KEY_NAME);
        HashMap<String, TopicDetails> topics = new HashMap<String, TopicDetails>();
        HashSet<String> duplicateTopics = new HashSet<String>();
        for (Object requestStructObj : requestStructs) {
            Struct singleRequestStruct = (Struct)requestStructObj;
            String topic = singleRequestStruct.getString(TOPIC_KEY_NAME);
            if (topics.containsKey(topic)) {
                duplicateTopics.add(topic);
            }
            int numPartitions = singleRequestStruct.getInt(NUM_PARTITIONS_KEY_NAME);
            short replicationFactor = singleRequestStruct.getShort(REPLICATION_FACTOR_KEY_NAME);
            Object[] assignmentsArray = singleRequestStruct.getArray(REPLICA_ASSIGNMENT_KEY_NAME);
            HashMap partitionReplicaAssignments = new HashMap(assignmentsArray.length);
            for (Object assignmentStructObj : assignmentsArray) {
                Struct assignmentStruct = (Struct)assignmentStructObj;
                Integer partitionId = assignmentStruct.getInt(REPLICA_ASSIGNMENT_PARTITION_ID_KEY_NAME);
                Object[] replicasArray = assignmentStruct.getArray(REPLICA_ASSIGNMENT_REPLICAS_KEY_NAME);
                ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
                for (Object replica : replicasArray) {
                    replicas.add((Integer)replica);
                }
                partitionReplicaAssignments.put(partitionId, replicas);
            }
            Object[] configArray = singleRequestStruct.getArray(CONFIGS_KEY_NAME);
            HashMap<String, String> configs = new HashMap<String, String>(configArray.length);
            for (Object configStructObj : configArray) {
                Struct configStruct = (Struct)configStructObj;
                String key = configStruct.getString(CONFIG_KEY_KEY_NAME);
                String value2 = configStruct.getString(CONFIG_VALUE_KEY_NAME);
                configs.put(key, value2);
            }
            TopicDetails args = new TopicDetails(numPartitions, replicationFactor, partitionReplicaAssignments, configs);
            topics.put(topic, args);
        }
        this.topics = topics;
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
        this.validateOnly = struct.hasField(VALIDATE_ONLY_KEY_NAME) ? struct.getBoolean(VALIDATE_ONLY_KEY_NAME) : false;
        this.duplicateTopics = duplicateTopics;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        HashMap<String, CreateTopicsResponse.Error> topicErrors = new HashMap<String, CreateTopicsResponse.Error>();
        for (String topic : this.topics.keySet()) {
            Errors error = Errors.forException(e);
            String message = error.message().equals(e.getMessage()) ? null : e.getMessage();
            topicErrors.put(topic, new CreateTopicsResponse.Error(error, message));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new CreateTopicsResponse(topicErrors, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.CREATE_TOPICS.id)));
    }

    public Map<String, TopicDetails> topics() {
        return this.topics;
    }

    public int timeout() {
        return this.timeout;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    public Set<String> duplicateTopics() {
        return this.duplicateTopics;
    }

    public static CreateTopicsRequest parse(ByteBuffer buffer, int versionId) {
        return new CreateTopicsRequest(ProtoUtils.parseRequest(ApiKeys.CREATE_TOPICS.id, versionId, buffer), (short)versionId);
    }

    public static CreateTopicsRequest parse(ByteBuffer buffer) {
        return CreateTopicsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.CREATE_TOPICS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<CreateTopicsRequest> {
        private final Map<String, TopicDetails> topics;
        private final int timeout;
        private final boolean validateOnly;

        public Builder(Map<String, TopicDetails> topics, int timeout) {
            this(topics, timeout, false);
        }

        public Builder(Map<String, TopicDetails> topics, int timeout, boolean validateOnly) {
            super(ApiKeys.CREATE_TOPICS);
            this.topics = topics;
            this.timeout = timeout;
            this.validateOnly = validateOnly;
        }

        @Override
        public CreateTopicsRequest build() {
            if (this.validateOnly && this.version() == 0) {
                throw new UnsupportedVersionException("validateOnly is not supported in version 0 of CreateTopicsRequest");
            }
            return new CreateTopicsRequest(this.topics, this.timeout, this.validateOnly, this.version());
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=CreateTopicsRequest").append(", topics=").append(Utils.mkString(this.topics)).append(", timeout=").append(this.timeout).append(", validateOnly=").append(this.validateOnly).append(")");
            return bld.toString();
        }
    }

    public static final class TopicDetails {
        public final int numPartitions;
        public final short replicationFactor;
        public final Map<Integer, List<Integer>> replicasAssignments;
        public final Map<String, String> configs;

        private TopicDetails(int numPartitions, short replicationFactor, Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this.numPartitions = numPartitions;
            this.replicationFactor = replicationFactor;
            this.replicasAssignments = replicasAssignments;
            this.configs = configs;
        }

        public TopicDetails(int partitions, short replicationFactor, Map<String, String> configs) {
            this(partitions, replicationFactor, Collections.emptyMap(), configs);
        }

        public TopicDetails(int partitions, short replicationFactor) {
            this(partitions, replicationFactor, Collections.emptyMap());
        }

        public TopicDetails(Map<Integer, List<Integer>> replicasAssignments, Map<String, String> configs) {
            this(-1, -1, replicasAssignments, configs);
        }

        public TopicDetails(Map<Integer, List<Integer>> replicasAssignments) {
            this(replicasAssignments, Collections.emptyMap());
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(numPartitions=").append(this.numPartitions).append(", replicationFactor=").append(this.replicationFactor).append(", replicasAssignments=").append(Utils.mkString(this.replicasAssignments)).append(", configs=").append(Utils.mkString(this.configs)).append(")");
            return bld.toString();
        }
    }
}

