/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.ByteBufferLogInputStream;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordsIterator;
import org.apache.kafka.common.record.TimestampType;

public class MemoryRecords
extends AbstractRecords {
    public static final MemoryRecords EMPTY = MemoryRecords.readableRecords(ByteBuffer.allocate(0));
    private final ByteBuffer buffer;
    private final Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> shallowEntries = new Iterable<ByteBufferLogInputStream.ByteBufferLogEntry>(){

        @Override
        public Iterator<ByteBufferLogInputStream.ByteBufferLogEntry> iterator() {
            return MemoryRecords.this.shallowIterator();
        }
    };
    private final Iterable<LogEntry> deepEntries = this.deepEntries(false);
    private int validBytes = -1;

    private MemoryRecords(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public int sizeInBytes() {
        return this.buffer.limit();
    }

    @Override
    public long writeTo(GatheringByteChannel channel, long position, int length) throws IOException {
        if (position > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("position should not be greater than Integer.MAX_VALUE: " + position);
        }
        if (position + (long)length > (long)this.buffer.limit()) {
            throw new IllegalArgumentException("position+length should not be greater than buffer.limit(), position: " + position + ", length: " + length + ", buffer.limit(): " + this.buffer.limit());
        }
        int pos = (int)position;
        ByteBuffer dup = this.buffer.duplicate();
        dup.position(pos);
        dup.limit(pos + length);
        return channel.write(dup);
    }

    public int writeFullyTo(GatheringByteChannel channel) throws IOException {
        int written;
        this.buffer.mark();
        for (written = 0; written < this.sizeInBytes(); written += channel.write(this.buffer)) {
        }
        this.buffer.reset();
        return written;
    }

    public int validBytes() {
        if (this.validBytes >= 0) {
            return this.validBytes;
        }
        int bytes = 0;
        for (LogEntry logEntry : this.shallowEntries()) {
            bytes += logEntry.sizeInBytes();
        }
        this.validBytes = bytes;
        return bytes;
    }

    public FilterResult filterTo(LogEntryFilter filter2, ByteBuffer destinationBuffer) {
        return MemoryRecords.filterTo(this.shallowEntries(), filter2, destinationBuffer);
    }

    private static FilterResult filterTo(Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> fromShallowEntries, LogEntryFilter filter2, ByteBuffer destinationBuffer) {
        long maxTimestamp = -1L;
        long maxOffset = -1L;
        long shallowOffsetOfMaxTimestamp = -1L;
        int messagesRead = 0;
        int bytesRead = 0;
        int messagesRetained = 0;
        int bytesRetained = 0;
        for (ByteBufferLogInputStream.ByteBufferLogEntry shallowEntry : fromShallowEntries) {
            bytesRead += shallowEntry.sizeInBytes();
            Record shallowRecord = shallowEntry.record();
            byte shallowMagic = shallowRecord.magic();
            boolean writeOriginalEntry = true;
            ArrayList<LogEntry> retainedEntries = new ArrayList<LogEntry>();
            for (LogEntry deepEntry : shallowEntry) {
                Record deepRecord = deepEntry.record();
                ++messagesRead;
                if (filter2.shouldRetain(deepEntry)) {
                    if (shallowMagic != deepRecord.magic()) {
                        writeOriginalEntry = false;
                    }
                    if (deepEntry.offset() > maxOffset) {
                        maxOffset = deepEntry.offset();
                    }
                    retainedEntries.add(deepEntry);
                    continue;
                }
                writeOriginalEntry = false;
            }
            if (writeOriginalEntry) {
                shallowEntry.writeTo(destinationBuffer);
                messagesRetained += retainedEntries.size();
                bytesRetained += shallowEntry.sizeInBytes();
                if (shallowRecord.timestamp() <= maxTimestamp) continue;
                maxTimestamp = shallowRecord.timestamp();
                shallowOffsetOfMaxTimestamp = shallowEntry.offset();
                continue;
            }
            if (retainedEntries.isEmpty()) continue;
            ByteBuffer slice2 = destinationBuffer.slice();
            MemoryRecordsBuilder builder = MemoryRecords.builderWithEntries(slice2, shallowRecord.timestampType(), shallowRecord.compressionType(), shallowRecord.timestamp(), retainedEntries);
            MemoryRecords records = builder.build();
            destinationBuffer.position(destinationBuffer.position() + slice2.position());
            messagesRetained += retainedEntries.size();
            bytesRetained += records.sizeInBytes();
            MemoryRecordsBuilder.RecordsInfo info = builder.info();
            if (info.maxTimestamp <= maxTimestamp) continue;
            maxTimestamp = info.maxTimestamp;
            shallowOffsetOfMaxTimestamp = info.shallowOffsetOfMaxTimestamp;
        }
        return new FilterResult(messagesRead, bytesRead, messagesRetained, bytesRetained, maxOffset, maxTimestamp, shallowOffsetOfMaxTimestamp);
    }

    public ByteBuffer buffer() {
        return this.buffer.duplicate();
    }

    public Iterable<ByteBufferLogInputStream.ByteBufferLogEntry> shallowEntries() {
        return this.shallowEntries;
    }

    private Iterator<ByteBufferLogInputStream.ByteBufferLogEntry> shallowIterator() {
        return RecordsIterator.shallowIterator(new ByteBufferLogInputStream(this.buffer.duplicate(), Integer.MAX_VALUE));
    }

    @Override
    public Iterable<LogEntry> deepEntries() {
        return this.deepEntries;
    }

    public Iterable<LogEntry> deepEntries(final boolean ensureMatchingMagic) {
        return new Iterable<LogEntry>(){

            @Override
            public Iterator<LogEntry> iterator() {
                return MemoryRecords.this.deepIterator(ensureMatchingMagic, Integer.MAX_VALUE);
            }
        };
    }

    private Iterator<LogEntry> deepIterator(boolean ensureMatchingMagic, int maxMessageSize) {
        return new RecordsIterator(new ByteBufferLogInputStream(this.buffer.duplicate(), maxMessageSize), false, ensureMatchingMagic, maxMessageSize);
    }

    public String toString() {
        Iterator<LogEntry> iter2 = this.deepEntries().iterator();
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        while (iter2.hasNext()) {
            LogEntry entry2 = iter2.next();
            builder.append('(');
            builder.append("offset=");
            builder.append(entry2.offset());
            builder.append(",");
            builder.append("record=");
            builder.append(entry2.record());
            builder.append(")");
            if (!iter2.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(']');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MemoryRecords that = (MemoryRecords)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType2, int writeLimit) {
        return new MemoryRecordsBuilder(buffer, 1, compressionType, timestampType2, 0L, System.currentTimeMillis(), writeLimit);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType2, long baseOffset, long logAppendTime) {
        return new MemoryRecordsBuilder(buffer, magic, compressionType, timestampType2, baseOffset, logAppendTime, buffer.capacity());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType2) {
        return MemoryRecords.builder(buffer, compressionType, timestampType2, buffer.capacity());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType2) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType2, 0L);
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, CompressionType compressionType, TimestampType timestampType2, long baseOffset) {
        return MemoryRecords.builder(buffer, (byte)1, compressionType, timestampType2, baseOffset, System.currentTimeMillis());
    }

    public static MemoryRecordsBuilder builder(ByteBuffer buffer, byte magic, CompressionType compressionType, TimestampType timestampType2, long baseOffset) {
        return MemoryRecords.builder(buffer, magic, compressionType, timestampType2, baseOffset, System.currentTimeMillis());
    }

    public static MemoryRecords readableRecords(ByteBuffer buffer) {
        return new MemoryRecords(buffer);
    }

    public static MemoryRecords withLogEntries(CompressionType compressionType, List<LogEntry> entries) {
        return MemoryRecords.withLogEntries(TimestampType.CREATE_TIME, compressionType, System.currentTimeMillis(), entries);
    }

    public static MemoryRecords withLogEntries(LogEntry ... entries) {
        return MemoryRecords.withLogEntries(CompressionType.NONE, Arrays.asList(entries));
    }

    public static MemoryRecords withRecords(CompressionType compressionType, long initialOffset, List<Record> records) {
        return MemoryRecords.withRecords(initialOffset, TimestampType.CREATE_TIME, compressionType, System.currentTimeMillis(), records);
    }

    public static MemoryRecords withRecords(Record ... records) {
        return MemoryRecords.withRecords(CompressionType.NONE, 0L, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(long initialOffset, Record ... records) {
        return MemoryRecords.withRecords(CompressionType.NONE, initialOffset, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(CompressionType compressionType, Record ... records) {
        return MemoryRecords.withRecords(compressionType, 0L, Arrays.asList(records));
    }

    public static MemoryRecords withRecords(TimestampType timestampType2, CompressionType compressionType, Record ... records) {
        return MemoryRecords.withRecords(0L, timestampType2, compressionType, System.currentTimeMillis(), Arrays.asList(records));
    }

    public static MemoryRecords withRecords(long initialOffset, TimestampType timestampType2, CompressionType compressionType, long logAppendTime, List<Record> records) {
        return MemoryRecords.withLogEntries(timestampType2, compressionType, logAppendTime, MemoryRecords.buildLogEntries(initialOffset, records));
    }

    private static MemoryRecords withLogEntries(TimestampType timestampType2, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        if (entries.isEmpty()) {
            return EMPTY;
        }
        return MemoryRecords.builderWithEntries(timestampType2, compressionType, logAppendTime, entries).build();
    }

    private static List<LogEntry> buildLogEntries(long initialOffset, List<Record> records) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (Record record2 : records) {
            entries.add(LogEntry.create(initialOffset++, record2));
        }
        return entries;
    }

    public static MemoryRecordsBuilder builderWithEntries(TimestampType timestampType2, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        ByteBuffer buffer = ByteBuffer.allocate(MemoryRecords.estimatedSize(compressionType, entries));
        return MemoryRecords.builderWithEntries(buffer, timestampType2, compressionType, logAppendTime, entries);
    }

    private static MemoryRecordsBuilder builderWithEntries(ByteBuffer buffer, TimestampType timestampType2, CompressionType compressionType, long logAppendTime, List<LogEntry> entries) {
        if (entries.isEmpty()) {
            throw new IllegalArgumentException("entries must not be empty");
        }
        LogEntry firstEntry = entries.iterator().next();
        long firstOffset = firstEntry.offset();
        byte magic = firstEntry.record().magic();
        MemoryRecordsBuilder builder = MemoryRecords.builder(buffer, magic, compressionType, timestampType2, firstOffset, logAppendTime);
        for (LogEntry entry2 : entries) {
            builder.appendWithOffset(entry2.offset(), entry2.record());
        }
        return builder;
    }

    public static class FilterResult {
        public final int messagesRead;
        public final int bytesRead;
        public final int messagesRetained;
        public final int bytesRetained;
        public final long maxOffset;
        public final long maxTimestamp;
        public final long shallowOffsetOfMaxTimestamp;

        public FilterResult(int messagesRead, int bytesRead, int messagesRetained, int bytesRetained, long maxOffset, long maxTimestamp, long shallowOffsetOfMaxTimestamp) {
            this.messagesRead = messagesRead;
            this.bytesRead = bytesRead;
            this.messagesRetained = messagesRetained;
            this.bytesRetained = bytesRetained;
            this.maxOffset = maxOffset;
            this.maxTimestamp = maxTimestamp;
            this.shallowOffsetOfMaxTimestamp = shallowOffsetOfMaxTimestamp;
        }
    }

    public static interface LogEntryFilter {
        public boolean shouldRetain(LogEntry var1);
    }
}

