/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.nio.channels.ClosedByInterruptException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.message.MessageAndMetadata;
import kafka.tools.ConsumerPerformance$;
import kafka.tools.PerfConfig;
import kafka.utils.CommandLineUtils$;
import kafka.utils.IteratorTemplate;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u001dt!B\u0001\u0003\u0011\u00039\u0011aE\"p]N,X.\u001a:QKJ4wN]7b]\u000e,'BA\u0002\u0005\u0003\u0015!xn\u001c7t\u0015\u0005)\u0011!B6bM.\f7\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u0014\u0007>t7/^7feB+'OZ8s[\u0006t7-Z\n\u0003\u00131\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\"B\n\n\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u001d1\u0012B1A\u0005\n]\ta\u0001\\8hO\u0016\u0014X#\u0001\r\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00027pORR'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\u000e\u0003\r1{wmZ3s\u0011\u0019\u0019\u0013\u0002)A\u00051\u00059An\\4hKJ\u0004\u0003\"B\u0013\n\t\u00031\u0013\u0001B7bS:$\"a\n\u0016\u0011\u00055A\u0013BA\u0015\u000f\u0005\u0011)f.\u001b;\t\u000b-\"\u0003\u0019\u0001\u0017\u0002\t\u0005\u0014xm\u001d\t\u0004\u001b5z\u0013B\u0001\u0018\u000f\u0005\u0015\t%O]1z!\t\u00014G\u0004\u0002\u000ec%\u0011!GD\u0001\u0007!J,G-\u001a4\n\u0005Q*$AB*ue&twM\u0003\u00023\u001d!)q'\u0003C\u0001q\u000591m\u001c8tk6,GCC\u0014:\u000fVSF,a8\u0002t\")!H\u000ea\u0001w\u0005A1m\u001c8tk6,'\u000f\u0005\u0003=\u0003\u000e\u001bU\"A\u001f\u000b\u0005ir$BA A\u0003\u001d\u0019G.[3oiNT!!\u0002\u000f\n\u0005\tk$!D&bM.\f7i\u001c8tk6,'\u000fE\u0002\u000e[\u0011\u0003\"!D#\n\u0005\u0019s!\u0001\u0002\"zi\u0016DQ\u0001\u0013\u001cA\u0002%\u000ba\u0001^8qS\u000e\u001c\bc\u0001&S_9\u00111\n\u0015\b\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u001a\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005Es\u0011a\u00029bG.\fw-Z\u0005\u0003'R\u0013A\u0001T5ti*\u0011\u0011K\u0004\u0005\u0006-Z\u0002\raV\u0001\u0006G>,h\u000e\u001e\t\u0003\u001baK!!\u0017\b\u0003\t1{gn\u001a\u0005\u00067Z\u0002\raV\u0001\bi&lWm\\;u\u0011\u0015if\u00071\u0001_\u0003\u0019\u0019wN\u001c4jOB\u0011q\fY\u0007\u0002\u0013\u0019!\u0011-\u0003\u0001c\u0005I\u0019uN\\:v[\u0016\u0014\b+\u001a:g\u0007>tg-[4\u0014\u0005\u0001\u001c\u0007C\u0001\u0005e\u0013\t)'A\u0001\u0006QKJ47i\u001c8gS\u001eD\u0001b\u000b1\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006'\u0001$\t\u0001\u001b\u000b\u0003=&DQaK4A\u00021Bqa\u001b1C\u0002\u0013\u0005A.\u0001\u0007{W\u000e{gN\\3di>\u0003H/F\u0001n!\rq\u0017oL\u0007\u0002_*\t\u0001/\u0001\u0006k_B$8/[7qY\u0016L!A]8\u00037\u0005\u0013x-^7f]R\f5mY3qi&twm\u00149uS>t7\u000b]3d\u0011\u0019!\b\r)A\u0005[\u0006i!p[\"p]:,7\r^(qi\u0002BqA\u001e1C\u0002\u0013\u0005A.A\nc_>$8\u000f\u001e:baN+'O^3sg>\u0003H\u000f\u0003\u0004yA\u0002\u0006I!\\\u0001\u0015E>|Go\u001d;sCB\u001cVM\u001d<feN|\u0005\u000f\u001e\u0011\t\u000fi\u0004'\u0019!C\u0001Y\u0006AAo\u001c9jG>\u0003H\u000f\u0003\u0004}A\u0002\u0006I!\\\u0001\ni>\u0004\u0018nY(qi\u0002BqA 1C\u0002\u0013\u0005A.\u0001\u0006he>,\b/\u00133PaRDq!!\u0001aA\u0003%Q.A\u0006he>,\b/\u00133PaR\u0004\u0003\"CA\u0003A\n\u0007I\u0011AA\u0004\u000311W\r^2i'&TXm\u00149u+\t\tI\u0001\u0005\u0003oc\u0006-\u0001\u0003BA\u0007\u0003/i!!a\u0004\u000b\t\u0005E\u00111C\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\u000f%sG/Z4fe\"A\u0011Q\u00041!\u0002\u0013\tI!A\u0007gKR\u001c\u0007nU5{K>\u0003H\u000f\t\u0005\n\u0003C\u0001'\u0019!C\u0001\u0003G\tqC]3tKR\u0014UmZ5o]&twm\u00144gg\u0016$x\n\u001d;\u0016\u0005\u0005\u0015\u0002c\u00018\u0002(%\u0019\u0011\u0011F8\u0003#=\u0003H/[8o'B,7MQ;jY\u0012,'\u000f\u0003\u0005\u0002.\u0001\u0004\u000b\u0011BA\u0013\u0003a\u0011Xm]3u\u0005\u0016<\u0017N\u001c8j]\u001e|eMZ:fi>\u0003H\u000f\t\u0005\n\u0003c\u0001'\u0019!C\u0001\u0003\u000f\t1c]8dW\u0016$()\u001e4gKJ\u001c\u0016N_3PaRD\u0001\"!\u000eaA\u0003%\u0011\u0011B\u0001\u0015g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016|\u0005\u000f\u001e\u0011\t\u0013\u0005e\u0002M1A\u0005\u0002\u0005\u001d\u0011!\u00048v[RC'/Z1eg>\u0003H\u000f\u0003\u0005\u0002>\u0001\u0004\u000b\u0011BA\u0005\u00039qW/\u001c+ie\u0016\fGm](qi\u0002B\u0011\"!\u0011a\u0005\u0004%\t!a\u0002\u0002\u001d9,XNR3uG\",'o](qi\"A\u0011Q\t1!\u0002\u0013\tI!A\bok64U\r^2iKJ\u001cx\n\u001d;!\u0011%\tI\u0005\u0019b\u0001\n\u0003\t\u0019#\u0001\boK^\u001cuN\\:v[\u0016\u0014x\n\u001d;\t\u0011\u00055\u0003\r)A\u0005\u0003K\tqB\\3x\u0007>t7/^7fe>\u0003H\u000f\t\u0005\t\u0003#\u0002'\u0019!C\u0001Y\u0006\t2m\u001c8tk6,'oQ8oM&<w\n\u001d;\t\u000f\u0005U\u0003\r)A\u0005[\u0006\u00112m\u001c8tk6,'oQ8oM&<w\n\u001d;!\u0011%\tI\u0006\u0019b\u0001\n\u0003\tY&A\u0004paRLwN\\:\u0016\u0005\u0005u\u0003c\u00018\u0002`%\u0019\u0011\u0011M8\u0003\u0013=\u0003H/[8o'\u0016$\b\u0002CA3A\u0002\u0006I!!\u0018\u0002\u0011=\u0004H/[8og\u0002B\u0011\"!\u001ba\u0005\u0004%\t!a\u001b\u0002\u001dU\u001cXm\u00147e\u0007>t7/^7feV\u0011\u0011Q\u000e\t\u0004\u001b\u0005=\u0014bAA9\u001d\t9!i\\8mK\u0006t\u0007\u0002CA;A\u0002\u0006I!!\u001c\u0002\u001fU\u001cXm\u00147e\u0007>t7/^7fe\u0002B\u0011\"!\u001fa\u0005\u0004%\t!a\u001f\u0002\u000bA\u0014x\u000e]:\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u000bk!!!!\u000b\t\u0005\r\u00151C\u0001\u0005kRLG.\u0003\u0003\u0002\b\u0006\u0005%A\u0003)s_B,'\u000f^5fg\"A\u00111\u00121!\u0002\u0013\ti(\u0001\u0004qe>\u00048\u000f\t\u0005\n\u0003\u001f\u0003'\u0019!C\u0001\u0003#\u000b!B\\;n)\"\u0014X-\u00193t+\t\t\u0019\nE\u0002\u000e\u0003+K1!a&\u000f\u0005\rIe\u000e\u001e\u0005\t\u00037\u0003\u0007\u0015!\u0003\u0002\u0014\u0006Ya.^7UQJ,\u0017\rZ:!\u0011%\ty\n\u0019b\u0001\n\u0003\t\t+A\u0003u_BL7-F\u00010\u0011\u001d\t)\u000b\u0019Q\u0001\n=\na\u0001^8qS\u000e\u0004\u0003\"CAUA\n\u0007I\u0011AAV\u0003-qW/\\'fgN\fw-Z:\u0016\u0003]Cq!a,aA\u0003%q+\u0001\u0007ok6lUm]:bO\u0016\u001c\b\u0005C\u0005\u00024\u0002\u0014\r\u0011\"\u0001\u0002\u0012\u0006\t\"/\u001a9peRLgnZ%oi\u0016\u0014h/\u00197\t\u0011\u0005]\u0006\r)A\u0005\u0003'\u000b!C]3q_J$\u0018N\\4J]R,'O^1mA!I\u00111\u00181C\u0002\u0013\u0005\u00111N\u0001\u0012g\"|w\u000fR3uC&dW\rZ*uCR\u001c\b\u0002CA`A\u0002\u0006I!!\u001c\u0002%MDwn\u001e#fi\u0006LG.\u001a3Ti\u0006$8\u000f\t\u0005\n\u0003\u0007\u0004'\u0019!C\u0001\u0003\u000b\f!\u0002Z1uK\u001a{'/\\1u+\t\t9\r\u0005\u0003\u0002J\u0006=WBAAf\u0015\u0011\ti-a\u0005\u0002\tQ,\u0007\u0010^\u0005\u0005\u0003#\fYM\u0001\tTS6\u0004H.\u001a#bi\u00164uN]7bi\"A\u0011Q\u001b1!\u0002\u0013\t9-A\u0006eCR,gi\u001c:nCR\u0004\u0003\"CAmA\n\u0007I\u0011AA6\u0003)A\u0017\u000eZ3IK\u0006$WM\u001d\u0005\t\u0003;\u0004\u0007\u0015!\u0003\u0002n\u0005Y\u0001.\u001b3f\u0011\u0016\fG-\u001a:!\u0011\u001d\t\tO\u000ea\u0001\u0003G\f\u0011\u0003^8uC2lUm]:bO\u0016\u001c(+Z1e!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\fa!\u0019;p[&\u001c'\u0002BAw\u0003\u0003\u000b!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\t0a:\u0003\u0015\u0005#x.\\5d\u0019>tw\rC\u0004\u0002vZ\u0002\r!a9\u0002\u001dQ|G/\u00197CsR,7OU3bI\"9\u0011\u0011`\u0005\u0005\u0002\u0005m\u0018\u0001\u00069sS:$\bK]8he\u0016\u001c8/T3tg\u0006<W\rF\t(\u0003{\u0014\tA!\u0002\u0003\n\t5!\u0011\u0003B\u000b\u00053A\u0001\"a@\u0002x\u0002\u0007\u00111S\u0001\u0003S\u0012DqAa\u0001\u0002x\u0002\u0007q+A\u0005csR,7OU3bI\"9!qAA|\u0001\u00049\u0016!\u00047bgR\u0014\u0015\u0010^3t%\u0016\fG\rC\u0004\u0003\f\u0005]\b\u0019A,\u0002\u00195,7o]1hKN\u0014V-\u00193\t\u000f\t=\u0011q\u001fa\u0001/\u0006\u0001B.Y:u\u001b\u0016\u001c8/Y4fgJ+\u0017\r\u001a\u0005\b\u0005'\t9\u00101\u0001X\u0003\u001d\u0019H/\u0019:u\u001bNDqAa\u0006\u0002x\u0002\u0007q+A\u0003f]\u0012l5\u000f\u0003\u0005\u0002D\u0006]\b\u0019AAd\r\u0019\u0011i\"\u0003\u0001\u0003 \t\u00112i\u001c8tk6,'\u000fU3sMRC'/Z1e'\u0011\u0011YB!\t\u0011\t\u00055!1E\u0005\u0005\u0005K\tyA\u0001\u0004UQJ,\u0017\r\u001a\u0005\f\u0005S\u0011YB!A!\u0002\u0013\t\u0019*\u0001\u0005uQJ,\u0017\rZ%e\u0011)\u0011iCa\u0007\u0003\u0002\u0003\u0006IaL\u0001\u0005]\u0006lW\rC\u0006\u00032\tm!\u0011!Q\u0001\n\tM\u0012AB:ue\u0016\fW\u000e\u0005\u0004\u00036\te2iQ\u0007\u0003\u0005oQ!A\u000f\u0003\n\t\tm\"q\u0007\u0002\f\u0017\u000647.Y*ue\u0016\fW\u000eC\u0005^\u00057\u0011\t\u0011)A\u0005=\"Y\u0011\u0011\u001dB\u000e\u0005\u0003\u0005\u000b\u0011BAr\u0011-\t)Pa\u0007\u0003\u0002\u0003\u0006I!a9\t\u0017\t\u0015#1\u0004B\u0001B\u0003%!qI\u0001\u0010G>t7/^7feRKW.Z8viB!\u0011Q\u001dB%\u0013\u0011\u0011Y%a:\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0011\u001d\u0019\"1\u0004C\u0001\u0005\u001f\"\u0002C!\u0015\u0003T\tU#q\u000bB-\u00057\u0012iFa\u0018\u0011\u0007}\u0013Y\u0002\u0003\u0005\u0003*\t5\u0003\u0019AAJ\u0011\u001d\u0011iC!\u0014A\u0002=B\u0001B!\r\u0003N\u0001\u0007!1\u0007\u0005\u0007;\n5\u0003\u0019\u00010\t\u0011\u0005\u0005(Q\na\u0001\u0003GD\u0001\"!>\u0003N\u0001\u0007\u00111\u001d\u0005\t\u0005\u000b\u0012i\u00051\u0001\u0003H!A!1\rB\u000e\t\u0003\u0012)'A\u0002sk:$\u0012a\n")
public final class ConsumerPerformance {
    public static void printProgressMessage(int n, long l, long l2, long l3, long l4, long l5, long l6, SimpleDateFormat simpleDateFormat) {
        ConsumerPerformance$.MODULE$.printProgressMessage(n, l, l2, l3, l4, l5, l6, simpleDateFormat);
    }

    public static void consume(KafkaConsumer<byte[], byte[]> kafkaConsumer, List<String> list, long l, long l2, ConsumerPerfConfig consumerPerfConfig, AtomicLong atomicLong, AtomicLong atomicLong2) {
        ConsumerPerformance$.MODULE$.consume(kafkaConsumer, list, l, l2, consumerPerfConfig, atomicLong, atomicLong2);
    }

    public static void main(String[] stringArray) {
        ConsumerPerformance$.MODULE$.main(stringArray);
    }

    public static class ConsumerPerfConfig
    extends PerfConfig {
        private final ArgumentAcceptingOptionSpec<String> zkConnectOpt = this.parser().accepts("zookeeper", "REQUIRED (only when using old consumer): The connection string for the zookeeper connection in the form host:port. Multiple URLS can be given to allow fail-over. This option is only used with the old consumer.").withRequiredArg().describedAs("urls").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> bootstrapServersOpt = this.parser().accepts("broker-list", "REQUIRED (unless old consumer is used): A broker list to use for connecting if using the new consumer.").withRequiredArg().describedAs("host").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> topicOpt = this.parser().accepts("topic", "REQUIRED: The topic to consume from.").withRequiredArg().describedAs("topic").ofType(String.class);
        private final ArgumentAcceptingOptionSpec<String> groupIdOpt = this.parser().accepts("group", "The group id to consume on.").withRequiredArg().describedAs("gid").defaultsTo(new StringBuilder().append((Object)"perf-consumer-").append(BoxesRunTime.boxToInteger(new Random().nextInt(100000))).toString(), (String[])((Object[])new String[0])).ofType(String.class);
        private final ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = this.parser().accepts("fetch-size", "The amount of data to fetch in a single request.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x100000), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder resetBeginningOffsetOpt = this.parser().accepts("from-latest", "If the consumer does not already have an established offset to consume from, start with the latest message present in the log rather than the earliest message.");
        private final ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt = this.parser().accepts("socket-buffer-size", "The size of the tcp RECV size.").withRequiredArg().describedAs("size").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(0x200000), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> numThreadsOpt = this.parser().accepts("threads", "Number of processing threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(10), (Integer[])((Object[])new Integer[0]));
        private final ArgumentAcceptingOptionSpec<Integer> numFetchersOpt = this.parser().accepts("num-fetch-threads", "Number of fetcher threads.").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        private final OptionSpecBuilder newConsumerOpt = this.parser().accepts("new-consumer", "Use the new consumer implementation. This is the default.");
        private final ArgumentAcceptingOptionSpec<String> consumerConfigOpt = this.parser().accepts("consumer.config", "Consumer config properties file.").withRequiredArg().describedAs("config file").ofType(String.class);
        private final OptionSet options;
        private final boolean useOldConsumer;
        private final Properties props;
        private final int numThreads;
        private final String topic;
        private final long numMessages;
        private final int reportingInterval;
        private final boolean showDetailedStats;
        private final SimpleDateFormat dateFormat;
        private final boolean hideHeader;

        public ArgumentAcceptingOptionSpec<String> zkConnectOpt() {
            return this.zkConnectOpt;
        }

        public ArgumentAcceptingOptionSpec<String> bootstrapServersOpt() {
            return this.bootstrapServersOpt;
        }

        public ArgumentAcceptingOptionSpec<String> topicOpt() {
            return this.topicOpt;
        }

        public ArgumentAcceptingOptionSpec<String> groupIdOpt() {
            return this.groupIdOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt() {
            return this.fetchSizeOpt;
        }

        public OptionSpecBuilder resetBeginningOffsetOpt() {
            return this.resetBeginningOffsetOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> socketBufferSizeOpt() {
            return this.socketBufferSizeOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numThreadsOpt() {
            return this.numThreadsOpt;
        }

        public ArgumentAcceptingOptionSpec<Integer> numFetchersOpt() {
            return this.numFetchersOpt;
        }

        public OptionSpecBuilder newConsumerOpt() {
            return this.newConsumerOpt;
        }

        public ArgumentAcceptingOptionSpec<String> consumerConfigOpt() {
            return this.consumerConfigOpt;
        }

        public OptionSet options() {
            return this.options;
        }

        public boolean useOldConsumer() {
            return this.useOldConsumer;
        }

        public Properties props() {
            return this.props;
        }

        public int numThreads() {
            return this.numThreads;
        }

        public String topic() {
            return this.topic;
        }

        public long numMessages() {
            return this.numMessages;
        }

        public int reportingInterval() {
            return this.reportingInterval;
        }

        public boolean showDetailedStats() {
            return this.showDetailedStats;
        }

        public SimpleDateFormat dateFormat() {
            return this.dateFormat;
        }

        public boolean hideHeader() {
            return this.hideHeader;
        }

        public ConsumerPerfConfig(String[] args) {
            super(args);
            Object object;
            this.options = this.parser().parse(args);
            CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.topicOpt(), this.numMessagesOpt()}));
            this.useOldConsumer = this.options().has(this.zkConnectOpt());
            Properties properties = this.props = this.options().has(this.consumerConfigOpt()) ? Utils.loadProps(this.options().valueOf(this.consumerConfigOpt())) : new Properties();
            if (this.useOldConsumer()) {
                if (this.options().has(this.bootstrapServersOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.bootstrapServersOpt(), this.zkConnectOpt()})));
                }
                if (this.options().has(this.newConsumerOpt())) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.parser(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Option ", " is not valid with ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.newConsumerOpt(), this.zkConnectOpt()})));
                }
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.zkConnectOpt(), this.numMessagesOpt()}));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("socket.receive.buffer.bytes", this.options().valueOf(this.socketBufferSizeOpt()).toString());
                this.props().put("fetch.message.max.bytes", this.options().valueOf(this.fetchSizeOpt()).toString());
                this.props().put("auto.offset.reset", this.options().has(this.resetBeginningOffsetOpt()) ? "largest" : "smallest");
                this.props().put("zookeeper.connect", this.options().valueOf(this.zkConnectOpt()));
                this.props().put("consumer.timeout.ms", "1000");
                object = this.props().put("num.consumer.fetchers", this.options().valueOf(this.numFetchersOpt()).toString());
            } else {
                CommandLineUtils$.MODULE$.checkRequiredArgs(this.parser(), this.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{this.bootstrapServersOpt()}));
                this.props().put("bootstrap.servers", this.options().valueOf(this.bootstrapServersOpt()));
                this.props().put("group.id", this.options().valueOf(this.groupIdOpt()));
                this.props().put("receive.buffer.bytes", this.options().valueOf(this.socketBufferSizeOpt()).toString());
                this.props().put("max.partition.fetch.bytes", this.options().valueOf(this.fetchSizeOpt()).toString());
                this.props().put("auto.offset.reset", this.options().has(this.resetBeginningOffsetOpt()) ? "latest" : "earliest");
                this.props().put("key.deserializer", ByteArrayDeserializer.class);
                this.props().put("value.deserializer", ByteArrayDeserializer.class);
                object = this.props().put("check.crcs", "false");
            }
            this.numThreads = this.options().valueOf(this.numThreadsOpt());
            this.topic = this.options().valueOf(this.topicOpt());
            this.numMessages = this.options().valueOf(this.numMessagesOpt());
            this.reportingInterval = this.options().valueOf(this.reportingIntervalOpt());
            if (this.reportingInterval() <= 0) {
                throw new IllegalArgumentException("Reporting interval must be greater than 0.");
            }
            this.showDetailedStats = this.options().has(this.showDetailedStatsOpt());
            this.dateFormat = new SimpleDateFormat(this.options().valueOf(this.dateFormatOpt()));
            this.hideHeader = this.options().has(this.hideHeaderOpt());
        }
    }

    public static class ConsumerPerfThread
    extends Thread {
        private final int threadId;
        private final KafkaStream<byte[], byte[]> stream;
        private final ConsumerPerfConfig config;
        private final AtomicLong totalMessagesRead;
        private final AtomicLong totalBytesRead;
        private final AtomicBoolean consumerTimeout;

        @Override
        public void run() {
            long startMs;
            long bytesRead = 0L;
            long messagesRead = 0L;
            long lastReportTime = startMs = System.currentTimeMillis();
            long lastBytesRead = 0L;
            long lastMessagesRead = 0L;
            try {
                Iterator iter2 = this.stream.iterator();
                while (((IteratorTemplate)iter2).hasNext() && messagesRead < this.config.numMessages()) {
                    Object messageAndMetadata = ((ConsumerIterator)iter2).next();
                    ++messagesRead;
                    bytesRead += (long)((byte[])((MessageAndMetadata)messageAndMetadata).message()).length;
                    long currentTimeMillis = System.currentTimeMillis();
                    if (currentTimeMillis - lastReportTime < (long)this.config.reportingInterval()) continue;
                    if (this.config.showDetailedStats()) {
                        ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, lastReportTime, currentTimeMillis, this.config.dateFormat());
                    }
                    lastReportTime = currentTimeMillis;
                    lastMessagesRead = messagesRead;
                    lastBytesRead = bytesRead;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            catch (ConsumerTimeoutException consumerTimeoutException) {
                this.consumerTimeout.set(true);
            }
            catch (ClosedByInterruptException closedByInterruptException) {
            }
            catch (InterruptedException interruptedException) {}
            this.totalMessagesRead.addAndGet(messagesRead);
            this.totalBytesRead.addAndGet(bytesRead);
            if (this.config.showDetailedStats()) {
                ConsumerPerformance$.MODULE$.printProgressMessage(this.threadId, bytesRead, lastBytesRead, messagesRead, lastMessagesRead, startMs, System.currentTimeMillis(), this.config.dateFormat());
            }
        }

        public ConsumerPerfThread(int threadId, String name, KafkaStream<byte[], byte[]> stream, ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead, AtomicBoolean consumerTimeout) {
            this.threadId = threadId;
            this.stream = stream;
            this.config = config;
            this.totalMessagesRead = totalMessagesRead;
            this.totalBytesRead = totalBytesRead;
            this.consumerTimeout = consumerTimeout;
            super(name);
        }
    }
}

