/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.KafkaStream;
import kafka.tools.ConsumerPerformance;
import kafka.tools.ConsumerPerformance$;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class ConsumerPerformance$ {
    public static final ConsumerPerformance$ MODULE$;
    private final Logger logger;

    static {
        new ConsumerPerformance$();
    }

    private Logger logger() {
        return this.logger;
    }

    public void main(String[] args) {
        ConsumerPerformance.ConsumerPerfConfig config = new ConsumerPerformance.ConsumerPerfConfig(args);
        this.logger().info("Starting consumer...");
        AtomicLong totalMessagesRead = new AtomicLong(0L);
        AtomicLong totalBytesRead = new AtomicLong(0L);
        AtomicBoolean consumerTimeout = new AtomicBoolean(false);
        if (!config.hideHeader()) {
            if (config.showDetailedStats()) {
                Predef$.MODULE$.println("time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            } else {
                Predef$.MODULE$.println("start.time, end.time, data.consumed.in.MB, MB.sec, data.consumed.in.nMsg, nMsg.sec");
            }
        }
        long startMs = 0L;
        long endMs = 0L;
        if (config.useOldConsumer()) {
            ConsumerConfig consumerConfig = new ConsumerConfig(config.props());
            ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
            Map<String, List<KafkaStream<byte[], byte[]>>> topicMessageStreams = consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(config.topic()), BoxesRunTime.boxToInteger(config.numThreads()))})));
            ObjectRef<Nil$> threadList = ObjectRef.create(Nil$.MODULE$);
            topicMessageStreams.values().foreach(new Serializable(config, totalMessagesRead, totalBytesRead, consumerTimeout, threadList){
                public static final long serialVersionUID = 0L;
                public final ConsumerPerformance.ConsumerPerfConfig config$1;
                public final AtomicLong totalMessagesRead$1;
                public final AtomicLong totalBytesRead$1;
                public final AtomicBoolean consumerTimeout$1;
                public final ObjectRef threadList$1;

                public final void apply(List<KafkaStream<byte[], byte[]>> streamList) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), streamList.length()).foreach$mVc$sp((Function1<Object, BoxedUnit>)((Object)new Serializable(this, streamList){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.main.1 $outer;
                        private final List streamList$1;

                        public final void apply(int i) {
                            this.apply$mcVI$sp(i);
                        }

                        public void apply$mcVI$sp(int i) {
                            this.$outer.threadList$1.elem = ((List)this.$outer.threadList$1.elem).$colon$colon(new ConsumerPerformance.ConsumerPerfThread(i, new StringBuilder().append((Object)"kafka-zk-consumer-").append(BoxesRunTime.boxToInteger(i)).toString(), (KafkaStream)this.streamList$1.apply(i), this.$outer.config$1, this.$outer.totalMessagesRead$1, this.$outer.totalBytesRead$1, this.$outer.consumerTimeout$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.streamList$1 = streamList$1;
                        }
                    }));
                }
                {
                    this.config$1 = config$1;
                    this.totalMessagesRead$1 = totalMessagesRead$1;
                    this.totalBytesRead$1 = totalBytesRead$1;
                    this.consumerTimeout$1 = consumerTimeout$1;
                    this.threadList$1 = threadList$1;
                }
            });
            this.logger().info("Sleeping for 1 second.");
            Thread.sleep(1000L);
            this.logger().info("starting threads");
            startMs = System.currentTimeMillis();
            ((List)threadList.elem).foreach(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                    thread.start();
                }
            });
            ((List)threadList.elem).foreach(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(ConsumerPerformance.ConsumerPerfThread thread) {
                    thread.join();
                }
            });
            endMs = consumerTimeout.get() ? System.currentTimeMillis() - (long)consumerConfig.consumerTimeoutMs() : System.currentTimeMillis();
            consumerConnector.shutdown();
        } else {
            KafkaConsumer<byte[], byte[]> consumer = new KafkaConsumer<byte[], byte[]>(config.props());
            consumer.subscribe(Collections.singletonList(config.topic()));
            startMs = System.currentTimeMillis();
            this.consume(consumer, (List<String>)List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{config.topic()})), config.numMessages(), 1000L, config, totalMessagesRead, totalBytesRead);
            endMs = System.currentTimeMillis();
            consumer.close();
        }
        double elapsedSecs = (double)(endMs - startMs) / 1000.0;
        if (!config.showDetailedStats()) {
            double totalMBRead = (double)totalBytesRead.get() * 1.0 / (double)0x100000;
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %s, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{config.dateFormat().format(BoxesRunTime.boxToLong(startMs)), config.dateFormat().format(BoxesRunTime.boxToLong(endMs)), BoxesRunTime.boxToDouble(totalMBRead), BoxesRunTime.boxToDouble(totalMBRead / elapsedSecs), BoxesRunTime.boxToLong(totalMessagesRead.get()), BoxesRunTime.boxToDouble((double)totalMessagesRead.get() / elapsedSecs)})));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void consume(KafkaConsumer<byte[], byte[]> consumer, List<String> topics, long count2, long timeout, ConsumerPerformance.ConsumerPerfConfig config, AtomicLong totalMessagesRead, AtomicLong totalBytesRead) {
        LongRef bytesRead = LongRef.create(0L);
        LongRef messagesRead = LongRef.create(0L);
        LongRef lastBytesRead = LongRef.create(0L);
        LongRef lastMessagesRead = LongRef.create(0L);
        int joinTimeout = 10000;
        AtomicBoolean isAssigned = new AtomicBoolean(false);
        consumer.subscribe((Collection<String>)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava(), new ConsumerRebalanceListener(isAssigned){
            private final AtomicBoolean isAssigned$1;

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.isAssigned$1.set(true);
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
                this.isAssigned$1.set(false);
            }
            {
                this.isAssigned$1 = isAssigned$1;
            }
        });
        long joinStart = System.currentTimeMillis();
        while (true) {
            void var14_12;
            void var16_14;
            if (isAssigned.get()) {
                consumer.seekToBeginning(Collections.<TopicPartition>emptyList());
                long startMs = System.currentTimeMillis();
                LongRef lastReportTime = LongRef.create(startMs);
                long lastConsumedTime = System.currentTimeMillis();
                LongRef currentTimeMillis = LongRef.create(lastConsumedTime);
                while (messagesRead.elem < count2 && currentTimeMillis.elem - lastConsumedTime <= timeout) {
                    Iterable<ConsumerRecord<byte[], byte[]>> records = JavaConverters$.MODULE$.iterableAsScalaIterableConverter(consumer.poll(100L)).asScala();
                    currentTimeMillis.elem = System.currentTimeMillis();
                    if (records.nonEmpty()) {
                        lastConsumedTime = currentTimeMillis.elem;
                    }
                    records.foreach(new Serializable(config, bytesRead, messagesRead, lastBytesRead, lastMessagesRead, lastReportTime, currentTimeMillis){
                        public static final long serialVersionUID = 0L;
                        private final ConsumerPerformance.ConsumerPerfConfig config$2;
                        private final LongRef bytesRead$1;
                        private final LongRef messagesRead$1;
                        private final LongRef lastBytesRead$1;
                        private final LongRef lastMessagesRead$1;
                        private final LongRef lastReportTime$1;
                        private final LongRef currentTimeMillis$1;

                        public final void apply(ConsumerRecord<byte[], byte[]> record2) {
                            ++this.messagesRead$1.elem;
                            if (record2.key() != null) {
                                this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps(record2.key()).size();
                            }
                            if (record2.value() != null) {
                                this.bytesRead$1.elem += (long)Predef$.MODULE$.byteArrayOps(record2.value()).size();
                            }
                            if (this.currentTimeMillis$1.elem - this.lastReportTime$1.elem >= (long)this.config$2.reportingInterval()) {
                                if (this.config$2.showDetailedStats()) {
                                    ConsumerPerformance$.MODULE$.printProgressMessage(0, this.bytesRead$1.elem, this.lastBytesRead$1.elem, this.messagesRead$1.elem, this.lastMessagesRead$1.elem, this.lastReportTime$1.elem, this.currentTimeMillis$1.elem, this.config$2.dateFormat());
                                }
                                this.lastReportTime$1.elem = this.currentTimeMillis$1.elem;
                                this.lastMessagesRead$1.elem = this.messagesRead$1.elem;
                                this.lastBytesRead$1.elem = this.bytesRead$1.elem;
                            }
                        }
                        {
                            this.config$2 = config$2;
                            this.bytesRead$1 = bytesRead$1;
                            this.messagesRead$1 = messagesRead$1;
                            this.lastBytesRead$1 = lastBytesRead$1;
                            this.lastMessagesRead$1 = lastMessagesRead$1;
                            this.lastReportTime$1 = lastReportTime$1;
                            this.currentTimeMillis$1 = currentTimeMillis$1;
                        }
                    });
                }
                totalMessagesRead.set(messagesRead.elem);
                totalBytesRead.set(bytesRead.elem);
                return;
            }
            if (System.currentTimeMillis() - var16_14 >= (long)var14_12) {
                throw new Exception("Timed out waiting for initial group join.");
            }
            consumer.poll(100L);
        }
    }

    public void printProgressMessage(int id, long bytesRead, long lastBytesRead, long messagesRead, long lastMessagesRead, long startMs, long endMs, SimpleDateFormat dateFormat) {
        double elapsedMs = endMs - startMs;
        double totalMBRead = (double)bytesRead * 1.0 / (double)0x100000;
        double mbRead = (double)(bytesRead - lastBytesRead) * 1.0 / (double)0x100000;
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s, %d, %.4f, %.4f, %d, %.4f")).format(Predef$.MODULE$.genericWrapArray(new Object[]{dateFormat.format(BoxesRunTime.boxToLong(endMs)), BoxesRunTime.boxToInteger(id), BoxesRunTime.boxToDouble(totalMBRead), BoxesRunTime.boxToDouble(1000.0 * (mbRead / elapsedMs)), BoxesRunTime.boxToLong(messagesRead), BoxesRunTime.boxToDouble((double)(messagesRead - lastMessagesRead) / elapsedMs * 1000.0)})));
    }

    private ConsumerPerformance$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

