/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.SocketTimeoutException;
import java.util.LinkedHashMap;
import kafka.admin.AdminUtils$;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Replica;
import kafka.common.KafkaStorageException;
import kafka.log.LogConfig$;
import kafka.server.AbstractFetcherThread;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.utils.NetworkClientBlockingOps$;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.LoginType;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B\u0001\u0003\u0001\u001d\u0011ACU3qY&\u001c\u0017MR3uG\",'\u000f\u00165sK\u0006$'BA\u0002\u0005\u0003\u0019\u0019XM\u001d<fe*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\r\u0002\t9\fW.\u001a\t\u0003\u001fUq!\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\ta\u0001\u0015:fI\u00164\u0017B\u0001\f\u0018\u0005\u0019\u0019FO]5oO*\u0011A#E\u0005\u0003\u001beI!AG\u000e\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u0006\u00039\u0011\tQ!\u001e;jYND\u0001B\b\u0001\u0003\u0002\u0003\u0006IaH\u0001\nM\u0016$8\r[3s\u0013\u0012\u0004\"\u0001\u0005\u0011\n\u0005\u0005\n\"aA%oi\"A1\u0005\u0001B\u0001B\u0003%A%\u0001\u0007t_V\u00148-\u001a\"s_.,'\u000f\u0005\u0002&Q5\taE\u0003\u0002(\t\u000591\r\\;ti\u0016\u0014\u0018BA\u0015'\u00059\u0011%o\\6fe\u0016sG\rU8j]RD\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\rEJ|7.\u001a:D_:4\u0017n\u001a\t\u0003\u00135J!A\f\u0002\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\ta\u0001\u0011\t\u0011)A\u0005c\u0005Q!/\u001a9mS\u000e\fWj\u001a:\u0011\u0005%\u0011\u0014BA\u001a\u0003\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\b[\u0016$(/[2t!\t9\u0004)D\u00019\u0015\t)\u0014H\u0003\u0002;w\u000511m\\7n_:T!!\u0002\u001f\u000b\u0005ur\u0014AB1qC\u000eDWMC\u0001@\u0003\ry'oZ\u0005\u0003\u0003b\u0012q!T3ue&\u001c7\u000f\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0003\u0011!\u0018.\\3\u0011\u0005\u0015;U\"\u0001$\u000b\u0005qI\u0014B\u0001%G\u0005\u0011!\u0016.\\3\t\u0011)\u0003!\u0011!Q\u0001\n-\u000bQ!];pi\u0006\u0004\"!\u0003'\n\u00055\u0013!a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019a\u0014N\\5u}QI\u0011KU*U+Z;\u0006,\u0017\t\u0003\u0013\u0001AQ!\u0004(A\u00029AQA\b(A\u0002}AQa\t(A\u0002\u0011BQa\u000b(A\u00021BQ\u0001\r(A\u0002EBQ!\u000e(A\u0002YBQa\u0011(A\u0002\u0011CQA\u0013(A\u0002-+Aa\u0017\u0001\u00019\n\u0019!+R)\u0011\u0005uCgBA\u0005_\u000f\u0015y&\u0001#\u0001a\u0003Q\u0011V\r\u001d7jG\u00064U\r^2iKJ$\u0006N]3bIB\u0011\u0011\"\u0019\u0004\u0006\u0003\tA\tAY\n\u0003C\u000e\u0004\"\u0001\u00053\n\u0005\u0015\f\"AB!osJ+g\rC\u0003PC\u0012\u0005q\rF\u0001a\r\u0015I\u0017\r\u0001\u0002k\u000511U\r^2i%\u0016\fX/Z:u'\rA7m\u001b\t\u0003Y>t!!C7\n\u00059\u0014\u0011!F!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ\u0005\u0003SBT!A\u001c\u0002\t\u0011ID'Q1A\u0005\u0002M\f!\"\u001e8eKJd\u00170\u001b8h+\u0005!\bCA;|\u001d\t1\u00180D\u0001x\u0015\tA\u0018(\u0001\u0005sKF,Xm\u001d;t\u0013\tQx/\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0002}{\n9!)^5mI\u0016\u0014(B\u0001>x\u0011!y\bN!A!\u0002\u0013!\u0018aC;oI\u0016\u0014H._5oO\u0002Baa\u00145\u0005\u0002\u0005\rA\u0003BA\u0003\u0003\u0013\u00012!a\u0002i\u001b\u0005\t\u0007B\u0002:\u0002\u0002\u0001\u0007A\u000fC\u0004\u0002\u000e!$\t!a\u0004\u0002\u000f%\u001cX)\u001c9usV\u0011\u0011\u0011\u0003\t\u0004!\u0005M\u0011bAA\u000b#\t9!i\\8mK\u0006t\u0007bBA\rQ\u0012\u0005\u00111D\u0001\u0007_\u001a47/\u001a;\u0015\t\u0005u\u00111\u0005\t\u0004!\u0005}\u0011bAA\u0011#\t!Aj\u001c8h\u0011!\t)#a\u0006A\u0002\u0005\u001d\u0012A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0005\u0003S\tY#D\u0001:\u0013\r\ti#\u000f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\r\u001d\t\t$\u0019\u0001\u0003\u0003g\u0011Q\u0002U1si&$\u0018n\u001c8ECR\f7#BA\u0018G\u0006U\u0002c\u00017\u00028%\u0019\u0011\u0011\u00079\t\u0015I\fyC!b\u0001\n\u0003\tY$\u0006\u0002\u0002>A!\u0011qHA#\u001d\r1\u0018\u0011I\u0005\u0004\u0003\u0007:\u0018!\u0004$fi\u000eD'+Z:q_:\u001cX-\u0003\u0003\u00022\u0005\u001d#bAA\"o\"Qq0a\f\u0003\u0002\u0003\u0006I!!\u0010\t\u000f=\u000by\u0003\"\u0001\u0002NQ!\u0011qJA)!\u0011\t9!a\f\t\u000fI\fY\u00051\u0001\u0002>!A\u0011QKA\u0018\t\u0003\t9&A\u0005feJ|'oQ8eKV\u0011\u0011\u0011\f\t\u0004!\u0005m\u0013bAA/#\t)1\u000b[8si\"A\u0011\u0011MA\u0018\t\u0003\t\u0019'A\u0005u_J+7m\u001c:egV\u0011\u0011Q\r\t\u0005\u0003O\ni'\u0004\u0002\u0002j)\u0019\u00111N\u001d\u0002\rI,7m\u001c:e\u0013\u0011\ty'!\u001b\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011!\t\u0019(a\f\u0005\u0002\u0005U\u0014!\u00045jO\"<\u0016\r^3s[\u0006\u00148.\u0006\u0002\u0002\u001e!A\u0011\u0011PA\u0018\t\u0003\tY(A\u0005fq\u000e,\u0007\u000f^5p]V\u0011\u0011Q\u0010\t\u0006!\u0005}\u00141Q\u0005\u0004\u0003\u0003\u000b\"AB(qi&|g\u000e\u0005\u0003\u0002\u0006\u0006Ue\u0002BAD\u0003#sA!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0004\u0003\u001b3\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\r\t\u0019*E\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9*!'\u0003\u0013QC'o\\<bE2,'bAAJ#\u00151\u0011Q\u0014\u0001\u0001\u0003?\u0013!\u0001\u0015#\u0011\u0007u\u000by\u0003C\u0005\u0002$\u0002\u0011\r\u0011\"\u0003\u0002X\u0005\u0019b-\u001a;dQJ+\u0017/^3tiZ+'o]5p]\"A\u0011q\u0015\u0001!\u0002\u0013\tI&\u0001\u000bgKR\u001c\u0007NU3rk\u0016\u001cHOV3sg&|g\u000e\t\u0005\n\u0003W\u0003!\u0019!C\u0005\u0003[\u000bQb]8dW\u0016$H+[7f_V$X#A\u0010\t\u000f\u0005E\u0006\u0001)A\u0005?\u0005q1o\\2lKR$\u0016.\\3pkR\u0004\u0003\"CA[\u0001\t\u0007I\u0011BAW\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0004\u0002:\u0002\u0001\u000b\u0011B\u0010\u0002\u0015I,\u0007\u000f\\5dC&#\u0007\u0005C\u0005\u0002>\u0002\u0011\r\u0011\"\u0003\u0002@\u00069Q.\u0019=XC&$XCAAa!\u0011\t\u0019-!4\u000e\u0005\u0005\u0015'\u0002BAd\u0003\u0013\fA\u0001\\1oO*\u0011\u00111Z\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0006\u0015'aB%oi\u0016<WM\u001d\u0005\t\u0003'\u0004\u0001\u0015!\u0003\u0002B\u0006AQ.\u0019=XC&$\b\u0005C\u0005\u0002X\u0002\u0011\r\u0011\"\u0003\u0002@\u0006AQ.\u001b8CsR,7\u000f\u0003\u0005\u0002\\\u0002\u0001\u000b\u0011BAa\u0003%i\u0017N\u001c\"zi\u0016\u001c\b\u0005C\u0005\u0002`\u0002\u0011\r\u0011\"\u0003\u0002@\u0006AQ.\u0019=CsR,7\u000f\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAa\u0003%i\u0017\r\u001f\"zi\u0016\u001c\b\u0005C\u0005\u0002h\u0002\u0011\r\u0011\"\u0003\u0002@\u0006Ia-\u001a;dQNK'0\u001a\u0005\t\u0003W\u0004\u0001\u0015!\u0003\u0002B\u0006Qa-\u001a;dQNK'0\u001a\u0011\t\u000f\u0005=\b\u0001\"\u0003\u0002r\u0006A1\r\\5f]RLE-F\u0001\u000f\u0011%\t)\u0010\u0001b\u0001\n\u0013\t90\u0001\u0006t_V\u00148-\u001a(pI\u0016,\"!!?\u0011\t\u0005%\u00121`\u0005\u0004\u0003{L$\u0001\u0002(pI\u0016D\u0001B!\u0001\u0001A\u0003%\u0011\u0011`\u0001\fg>,(oY3O_\u0012,\u0007\u0005C\u0005\u0003\u0006\u0001\u0011\r\u0011\"\u0003\u0003\b\u0005ia.\u001a;x_J\\7\t\\5f]R,\"A!\u0003\u0011\t\t-!\u0011C\u0007\u0003\u0005\u001bQ1Aa\u0004<\u0003\u001d\u0019G.[3oiNLAAa\u0005\u0003\u000e\tia*\u001a;x_J\\7\t\\5f]RD\u0001Ba\u0006\u0001A\u0003%!\u0011B\u0001\u000f]\u0016$xo\u001c:l\u00072LWM\u001c;!\u0011\u001d\u0011Y\u0002\u0001C!\u0005;\t\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0003\u0005?\u00012\u0001\u0005B\u0011\u0013\r\u0011\u0019#\u0005\u0002\u0005+:LG\u000fC\u0004\u0003(\u0001!\tA!\u000b\u0002)A\u0014xnY3tgB\u000b'\u000f^5uS>tG)\u0019;b)!\u0011yBa\u000b\u0003.\tE\u0002\u0002CA\u0013\u0005K\u0001\r!a\n\t\u0011\t=\"Q\u0005a\u0001\u0003;\t1BZ3uG\"|eMZ:fi\"A!1\u0007B\u0013\u0001\u0004\ty*A\u0007qCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0005\b\u0005o\u0001A\u0011\u0001B\u001d\u0003mi\u0017-\u001f2f/\u0006\u0014h.\u00134Pm\u0016\u00148/\u001b>fIJ+7m\u001c:egR1!q\u0004B\u001e\u0005\u007fA\u0001B!\u0010\u00036\u0001\u0007\u0011QM\u0001\be\u0016\u001cwN\u001d3t\u0011!\t)C!\u000eA\u0002\u0005\u001d\u0002b\u0002B\"\u0001\u0011\u0005!QI\u0001\u0017Q\u0006tG\r\\3PM\u001a\u001cX\r^(vi>3'+\u00198hKR!\u0011Q\u0004B$\u0011!\t)C!\u0011A\u0002\u0005\u001d\u0002b\u0002B&\u0001\u0011\u0005!QJ\u0001\u001bQ\u0006tG\r\\3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5FeJ|'o\u001d\u000b\u0005\u0005?\u0011y\u0005\u0003\u0005\u0003R\t%\u0003\u0019\u0001B*\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0007\u0003\u000b\u0013)&a\n\n\t\t]\u0013\u0011\u0014\u0002\t\u0013R,'/\u00192mK\"9!1\f\u0001\u0005\u0012\tu\u0013!\u00024fi\u000eDG\u0003\u0002B0\u0005W\u0002b!!\"\u0003b\t\u0015\u0014\u0002\u0002B2\u00033\u00131aU3r!\u001d\u0001\"qMA\u0014\u0003?K1A!\u001b\u0012\u0005\u0019!V\u000f\u001d7fe!9!Q\u000eB-\u0001\u0004a\u0016\u0001\u00044fi\u000eD'+Z9vKN$\bb\u0002B9\u0001\u0011%!1O\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0003\u0003v\tm\u0004\u0003\u0002B\u0006\u0005oJAA!\u001f\u0003\u000e\tq1\t\\5f]R\u0014Vm\u001d9p]N,\u0007\u0002\u0003B?\u0005_\u0002\rAa \u0002\u001dI,\u0017/^3ti\n+\u0018\u000e\u001c3feB\"!\u0011\u0011BI!\u0019\u0011\u0019I!#\u0003\u000e:\u0019aO!\"\n\u0007\t\u001du/A\bBEN$(/Y2u%\u0016\fX/Z:u\u0013\ra(1\u0012\u0006\u0004\u0005\u000f;\b\u0003\u0002BH\u0005#c\u0001\u0001\u0002\u0007\u0003\u0014\nm\u0014\u0011!A\u0001\u0006\u0003\u0011)JA\u0002`IE\nBAa&\u0003\u001eB\u0019\u0001C!'\n\u0007\tm\u0015CA\u0004O_RD\u0017N\\4\u0011\u0007Y\u0014y*C\u0002\u0003\"^\u0014q\"\u00112tiJ\f7\r\u001e*fcV,7\u000f\u001e\u0005\b\u0005K\u0003A\u0011\u0002BT\u0003Y)\u0017M\u001d7jKN$xJ\u001d'bi\u0016\u001cHo\u00144gg\u0016$H\u0003CA\u000f\u0005S\u0013YKa,\t\u0011\u0005\u0015\"1\u0015a\u0001\u0003OA\u0001B!,\u0003$\u0002\u0007\u0011QD\u0001\u0011K\u0006\u0014H.[3ti>\u0013H*\u0019;fgRDqA!-\u0003$\u0002\u0007q$\u0001\u0006d_:\u001cX/\\3s\u0013\u0012DqA!.\u0001\t#\u00119,A\tck&dGMR3uG\"\u0014V-];fgR$2\u0001\u0018B]\u0011!\u0011YLa-A\u0002\tu\u0016\u0001\u00049beRLG/[8o\u001b\u0006\u0004\bCBAC\u0005C\u0012y\fE\u0004\u0011\u0005O\n9C!1\u0011\u0007%\u0011\u0019-C\u0002\u0003F\n\u00111\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016DqA!3\u0001\t\u0013\u0011Y-\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)\u0019\t\tB!4\u0003V\"9!Ja2A\u0002\t=\u0007cA\u0005\u0003R&\u0019!1\u001b\u0002\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\t\u0011\u0005\u0015\"q\u0019a\u0001\u0003O\u0001")
public class ReplicaFetcherThread
extends AbstractFetcherThread {
    public final BrokerEndPoint kafka$server$ReplicaFetcherThread$$sourceBroker;
    public final KafkaConfig kafka$server$ReplicaFetcherThread$$brokerConfig;
    private final ReplicaManager replicaMgr;
    private final Time time;
    public final ReplicationQuotaManager kafka$server$ReplicaFetcherThread$$quota;
    private final short fetchRequestVersion;
    private final int socketTimeout;
    private final int replicaId;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer kafka$server$ReplicaFetcherThread$$fetchSize;
    private final Node sourceNode;
    private final NetworkClient networkClient;

    private short fetchRequestVersion() {
        return this.fetchRequestVersion;
    }

    private int socketTimeout() {
        return this.socketTimeout;
    }

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    public Integer kafka$server$ReplicaFetcherThread$$fetchSize() {
        return this.kafka$server$ReplicaFetcherThread$$fetchSize;
    }

    private String clientId() {
        return super.name();
    }

    private Node sourceNode() {
        return this.sourceNode;
    }

    private NetworkClient networkClient() {
        return this.networkClient;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.networkClient().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        try {
            Replica replica = this.replicaMgr.getReplica(topicPartition, this.replicaMgr.getReplica$default$2()).get();
            MemoryRecords records = partitionData.toRecords();
            this.maybeWarnIfOversizedRecords(records, topicPartition);
            if (fetchOffset != replica.logEndOffset().messageOffset()) {
                throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset mismatch for partition %s: fetched offset = %d, log end offset = %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition, BoxesRunTime.boxToLong(fetchOffset), BoxesRunTime.boxToLong(replica.logEndOffset().messageOffset())})));
            }
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, partitionData, replica, records){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final PartitionData partitionData$1;
                    private final Replica replica$1;
                    private final MemoryRecords records$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d for partition %s. Received %d messages and leader hw %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), this.topicPartition$1, BoxesRunTime.boxToInteger(this.records$1.sizeInBytes()), BoxesRunTime.boxToLong(this.partitionData$1.highWatermark())}));
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.partitionData$1 = partitionData$1;
                        this.replica$1 = replica$1;
                        this.records$1 = records$1;
                    }
                }));
            }
            replica.log().get().append(records, false);
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, replica, records){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final Replica replica$1;
                    private final MemoryRecords records$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Follower %d has replica log end offset %d after appending %d bytes of messages for partition %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), BoxesRunTime.boxToLong(this.replica$1.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.records$1.sizeInBytes()), this.topicPartition$1}));
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.replica$1 = replica$1;
                        this.records$1 = records$1;
                    }
                }));
            }
            long followerHighWatermark = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(replica.logEndOffset().messageOffset()), partitionData.highWatermark());
            replica.highWatermark_$eq(new LogOffsetMetadata(followerHighWatermark, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
            if (this.logger().isTraceEnabled()) {
                this.trace((Function0<String>)((Object)new Serializable(this, topicPartition, replica, followerHighWatermark){
                    public static final long serialVersionUID = 0L;
                    private final TopicPartition topicPartition$1;
                    private final Replica replica$1;
                    private final long followerHighWatermark$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Follower ", " set replica high watermark for partition ", " to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.replica$1.brokerId()), this.topicPartition$1, BoxesRunTime.boxToLong(this.followerHighWatermark$1)}));
                    }
                    {
                        this.topicPartition$1 = topicPartition$1;
                        this.replica$1 = replica$1;
                        this.followerHighWatermark$1 = followerHighWatermark$1;
                    }
                }));
            }
            if (this.kafka$server$ReplicaFetcherThread$$quota.isThrottled(topicPartition)) {
                this.kafka$server$ReplicaFetcherThread$$quota.record(records.sizeInBytes());
            }
        }
        catch (KafkaStorageException kafkaStorageException) {
            this.fatal((Function0<String>)((Object)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Disk error while replicating data for ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$1}));
                }
                {
                    this.topicPartition$1 = topicPartition$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, kafkaStorageException){
                public static final long serialVersionUID = 0L;
                private final KafkaStorageException e$1;

                public final KafkaStorageException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            Runtime.getRuntime().halt(1);
        }
    }

    public void maybeWarnIfOversizedRecords(MemoryRecords records, TopicPartition topicPartition) {
        if (this.fetchRequestVersion() <= 2 && records.sizeInBytes() > 0 && records.validBytes() <= 0) {
            this.error((Function0<String>)((Object)new Serializable(this, topicPartition){
                public static final long serialVersionUID = 0L;
                private final TopicPartition topicPartition$2;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Replication is failing due to a message that is greater than replica.fetch.max.bytes for partition ", ". "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$2}))).append((Object)"This generally occurs when the max.message.bytes has been overridden to exceed this value and a suitably large ").append((Object)"message has also been sent. To fix this problem increase replica.fetch.max.bytes in your broker config to be ").append((Object)"equal or larger than your settings for max.message.bytes, both at a broker and topic level.").toString();
                }
                {
                    this.topicPartition$2 = topicPartition$2;
                }
            }));
        }
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        Replica replica = this.replicaMgr.getReplica(topicPartition, this.replicaMgr.getReplica$default$2()).get();
        long leaderEndOffset = this.earliestOrLatestOffset(topicPartition, -1L, this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
        if (leaderEndOffset < replica.logEndOffset().messageOffset()) {
            if (!Predef$.MODULE$.Boolean2boolean(LogConfig$.MODULE$.fromProps(this.kafka$server$ReplicaFetcherThread$$brokerConfig.originals(), AdminUtils$.MODULE$.fetchEntityConfig(this.replicaMgr.zkUtils(), ConfigType$.MODULE$.Topic(), topicPartition.topic())).uncleanLeaderElectionEnable())) {
                this.fatal((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderEndOffset){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ReplicaFetcherThread $outer;
                    private final TopicPartition topicPartition$3;
                    private final Replica replica$2;
                    private final long leaderEndOffset$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Exiting because log truncation is not allowed for partition %s,")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3}))).append((Object)new StringOps(Predef$.MODULE$.augmentString(" Current leader %d's latest offset %d is less than replica %d's latest offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderEndOffset$1), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset())}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.topicPartition$3 = topicPartition$3;
                        this.replica$2 = replica$2;
                        this.leaderEndOffset$1 = leaderEndOffset$1;
                    }
                }));
                System.exit(1);
            }
            this.warn((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderEndOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderEndOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's latest offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicPartition$3, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderEndOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderEndOffset$1 = leaderEndOffset$1;
                }
            }));
            this.replicaMgr.logManager().truncateTo((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), BoxesRunTime.boxToLong(leaderEndOffset))})));
            l = leaderEndOffset;
        } else {
            long leaderStartOffset = this.earliestOrLatestOffset(topicPartition, -2L, this.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId());
            this.warn((Function0<String>)((Object)new Serializable(this, topicPartition, replica, leaderStartOffset){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaFetcherThread $outer;
                private final TopicPartition topicPartition$3;
                private final Replica replica$2;
                private final long leaderStartOffset$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s reset its fetch offset from %d to current leader %d's start offset %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$brokerConfig.brokerId()), this.topicPartition$3, BoxesRunTime.boxToLong(this.replica$2.logEndOffset().messageOffset()), BoxesRunTime.boxToInteger(this.$outer.kafka$server$ReplicaFetcherThread$$sourceBroker.id()), BoxesRunTime.boxToLong(this.leaderStartOffset$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$3 = topicPartition$3;
                    this.replica$2 = replica$2;
                    this.leaderStartOffset$1 = leaderStartOffset$1;
                }
            }));
            long offsetToFetch = Math.max(leaderStartOffset, replica.logEndOffset().messageOffset());
            if (leaderStartOffset > replica.logEndOffset().messageOffset()) {
                this.replicaMgr.logManager().truncateFullyAndStartAt(topicPartition, leaderStartOffset);
            }
            l = offsetToFetch;
        }
        return l;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        this.delayPartitions(partitions, Predef$.MODULE$.Integer2int(this.kafka$server$ReplicaFetcherThread$$brokerConfig.replicaFetchBackoffMs()));
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        ClientResponse clientResponse = this.sendRequest(fetchRequest.underlying());
        FetchResponse fetchResponse = (FetchResponse)clientResponse.responseBody();
        return ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(fetchResponse.responseData()).asScala()).toSeq().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicPartition, FetchResponse.PartitionData> x0$1) {
                Tuple2<TopicPartition, FetchResponse.PartitionData> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition key = tuple2._1();
                    FetchResponse.PartitionData value2 = tuple2._2();
                    Tuple2<TopicPartition, PartitionData> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), new PartitionData(value2));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private ClientResponse sendRequest(AbstractRequest.Builder<? extends AbstractRequest> requestBuilder) {
        try {
            if (NetworkClientBlockingOps$.MODULE$.blockingReady$extension(NetworkClientBlockingOps$.MODULE$.networkClientBlockingOps(this.networkClient()), this.sourceNode(), this.socketTimeout(), this.time)) {
                ClientRequest clientRequest = this.networkClient().newClientRequest(((Object)BoxesRunTime.boxToInteger(this.kafka$server$ReplicaFetcherThread$$sourceBroker.id())).toString(), requestBuilder, this.time.milliseconds(), true);
                return NetworkClientBlockingOps$.MODULE$.blockingSendAndReceive$extension(NetworkClientBlockingOps$.MODULE$.networkClientBlockingOps(this.networkClient()), clientRequest, this.time);
            }
            throw new SocketTimeoutException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to connect within ", " ms"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.socketTimeout())})));
        }
        catch (Throwable throwable) {
            this.networkClient().close(((Object)BoxesRunTime.boxToInteger(this.kafka$server$ReplicaFetcherThread$$sourceBroker.id())).toString());
            throw throwable;
        }
    }

    private long earliestOrLatestOffset(TopicPartition topicPartition, long earliestOrLatest, int consumerId) {
        AbstractRequest.Builder builder;
        if (this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$)) {
            Map partitions = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), Predef$.MODULE$.long2Long(earliestOrLatest))}));
            builder = new ListOffsetRequest.Builder(consumerId).setTargetTimes(JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()).setVersion((short)1);
        } else {
            Map partitions = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicPartition), new ListOffsetRequest.PartitionData(earliestOrLatest, 1))}));
            builder = new ListOffsetRequest.Builder(consumerId).setOffsetData(JavaConverters$.MODULE$.mapAsJavaMapConverter(partitions).asJava()).setVersion((short)0);
        }
        AbstractRequest.Builder requestBuilder = builder;
        ClientResponse clientResponse = this.sendRequest(requestBuilder);
        ListOffsetResponse response = (ListOffsetResponse)clientResponse.responseBody();
        ListOffsetResponse.PartitionData partitionData = response.responseData().get(topicPartition);
        Errors errors = Errors.forCode(partitionData.errorCode);
        if (((Object)((Object)Errors.NONE)).equals((Object)errors)) {
            long l = this.kafka$server$ReplicaFetcherThread$$brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV2$.MODULE$) ? Predef$.MODULE$.Long2long(partitionData.offset) : Predef$.MODULE$.Long2long(partitionData.offsets.get(0));
            return l;
        }
        throw errors.exception();
    }

    @Override
    public FetchRequest buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        partitionMap.foreach(new Serializable(this, requestMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaFetcherThread $outer;
            private final LinkedHashMap requestMap$1;

            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$2) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    PartitionFetchState partitionFetchState = tuple2._2();
                    BoxedUnit boxedUnit = partitionFetchState.isActive() && !this.$outer.kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(this.$outer.kafka$server$ReplicaFetcherThread$$quota, topicPartition) ? this.requestMap$1.put(topicPartition, new FetchRequest.PartitionData(partitionFetchState.offset(), Predef$.MODULE$.Integer2int(this.$outer.kafka$server$ReplicaFetcherThread$$fetchSize()))) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.requestMap$1 = requestMap$1;
            }
        });
        FetchRequest.Builder requestBuilder = new FetchRequest.Builder(Predef$.MODULE$.Integer2int(this.maxWait()), Predef$.MODULE$.Integer2int(this.minBytes()), requestMap).setReplicaId(this.replicaId()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes()));
        requestBuilder.setVersion(this.fetchRequestVersion());
        return new FetchRequest(requestBuilder);
    }

    public boolean kafka$server$ReplicaFetcherThread$$shouldFollowerThrottle(ReplicaQuota quota, TopicPartition topicPartition) {
        boolean isReplicaInSync = this.fetcherLagStats().isReplicaInSync(topicPartition.topic(), topicPartition.partition());
        return quota.isThrottled(topicPartition) && quota.isQuotaExceeded() && !isReplicaInSync;
    }

    public ReplicaFetcherThread(String name, int fetcherId, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, ReplicaManager replicaMgr, Metrics metrics, Time time, ReplicationQuotaManager quota) {
        this.kafka$server$ReplicaFetcherThread$$sourceBroker = sourceBroker;
        this.kafka$server$ReplicaFetcherThread$$brokerConfig = brokerConfig;
        this.replicaMgr = replicaMgr;
        this.time = time;
        this.kafka$server$ReplicaFetcherThread$$quota = quota;
        super(name, name, sourceBroker, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.fetchRequestVersion = (short)(brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_1_IV1$.MODULE$) ? 3 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_10_0_IV0$.MODULE$) ? 2 : (brokerConfig.interBrokerProtocolVersion().$greater$eq(KAFKA_0_9_0$.MODULE$) ? 1 : 0)));
        this.socketTimeout = Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketTimeoutMs());
        this.replicaId = brokerConfig.brokerId();
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.kafka$server$ReplicaFetcherThread$$fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.sourceNode = new Node(sourceBroker.id(), sourceBroker.host(), sourceBroker.port());
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder(brokerConfig.interBrokerSecurityProtocol(), LoginType.SERVER, brokerConfig.values(), brokerConfig.saslMechanismInterBrokerProtocol(), brokerConfig.saslInterBrokerHandshakeRequestEnable());
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(brokerConfig.connectionsMaxIdleMs()), metrics, time, "replica-fetcher", JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("broker-id"), ((Object)BoxesRunTime.boxToInteger(sourceBroker.id())).toString()), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fetcher-id"), ((Object)BoxesRunTime.boxToInteger(fetcherId)).toString())}))).asJava(), false, channelBuilder);
        this.networkClient = new NetworkClient((Selectable)selector, new ManualMetadataUpdater(), this.clientId(), 1, 0L, -1, Predef$.MODULE$.Integer2int(brokerConfig.replicaSocketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(brokerConfig.requestTimeoutMs()), time, false);
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final FetchRequest.Builder underlying;

        public FetchRequest.Builder underlying() {
            return this.underlying;
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().fetchData().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return ((FetchRequest.PartitionData)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.underlying().fetchData()).asScala()).apply(topicPartition)).offset;
        }

        public FetchRequest(FetchRequest.Builder underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponse.PartitionData underlying;

        public FetchResponse.PartitionData underlying() {
            return this.underlying;
        }

        @Override
        public short errorCode() {
            return this.underlying().errorCode;
        }

        @Override
        public MemoryRecords toRecords() {
            return (MemoryRecords)this.underlying().records;
        }

        @Override
        public long highWatermark() {
            return this.underlying().highWatermark;
        }

        @Override
        public Option<Throwable> exception() {
            Errors errors = Errors.forCode(this.errorCode());
            Option option = ((Object)((Object)Errors.NONE)).equals((Object)errors) ? None$.MODULE$ : new Some<ApiException>(errors.exception());
            return option;
        }

        public PartitionData(FetchResponse.PartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

