/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.network.AbstractServerThread;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor$ConnectionId$;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$CloseConnectionAction$;
import kafka.network.RequestChannel$NoOpAction$;
import kafka.network.RequestChannel$SendAction$;
import kafka.security.CredentialProvider;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Product$class;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h!B\u0001\u0003\u0001\u00111!!\u0003)s_\u000e,7o]8s\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001c2\u0001A\u0004\f!\tA\u0011\"D\u0001\u0003\u0013\tQ!A\u0001\u000bBEN$(/Y2u'\u0016\u0014h/\u001a:UQJ,\u0017\r\u001a\t\u0003\u0019=i\u0011!\u0004\u0006\u0003\u001d\u0011\tq!\\3ue&\u001c7/\u0003\u0002\u0011\u001b\t\t2*\u00194lC6+GO]5dg\u001e\u0013x.\u001e9\t\u0011I\u0001!Q1A\u0005\u0002Q\t!!\u001b3\u0004\u0001U\tQ\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrCA\u0002J]RD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!F\u0001\u0004S\u0012\u0004\u0003\u0002\u0003\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0010\u0002\tQLW.\u001a\t\u0003A)j\u0011!\t\u0006\u0003E\r\nQ!\u001e;jYNT!\u0001J\u0013\u0002\r\r|W.\\8o\u0015\t)aE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005\u0011!\u0016.\\3\t\u00115\u0002!\u0011!Q\u0001\nU\ta\"\\1y%\u0016\fX/Z:u'&TX\r\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\"\u0001C\u0019\n\u0005I\u0012!A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0005\ti\u0001\u0011\t\u0011)A\u0005k\u0005\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m\u001d\t\u0003\u0011YJ!a\u000e\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001e\u0002)\r|gN\\3di&|gn]'bq&#G.Z't!\t12(\u0003\u0002=/\t!Aj\u001c8h\u0011!q\u0004A!A!\u0002\u0013y\u0014\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u0001!C\u001b\u0005\t%BA\u0002$\u0013\t\u0019\u0015I\u0001\u0007MSN$XM\\3s\u001d\u0006lW\r\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003G\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G\u000e\u0005\u0002H\u00156\t\u0001J\u0003\u0002JG\u0005A\u0001O]8u_\u000e|G.\u0003\u0002L\u0011\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u0006q1\r[1o]\u0016d7i\u001c8gS\u001e\u001c\bGA(a!\u0011\u0001Vk\u00160\u000e\u0003ES!AU*\u0002\tU$\u0018\u000e\u001c\u0006\u0002)\u0006!!.\u0019<b\u0013\t1\u0016KA\u0002NCB\u0004\"\u0001W.\u000f\u0005YI\u0016B\u0001.\u0018\u0003\u0019\u0001&/\u001a3fM&\u0011A,\u0018\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005i;\u0002CA0a\u0019\u0001!\u0011\"\u0019'\u0002\u0002\u0003\u0005)\u0011\u00012\u0003\u0007}#\u0013'\u0005\u0002dMB\u0011a\u0003Z\u0005\u0003K^\u0011qAT8uQ&tw\r\u0005\u0002\u0017O&\u0011\u0001n\u0006\u0002\u0004\u0003:L\b\u0002\u0003\b\u0001\u0005\u0003\u0005\u000b\u0011\u00026\u0011\u0005-lW\"\u00017\u000b\u00059\u0019\u0013B\u00018m\u0005\u001diU\r\u001e:jGND\u0001\u0002\u001d\u0001\u0003\u0002\u0003\u0006I!]\u0001\u0013GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000f\u0005\u0002sk6\t1O\u0003\u0002u\t\u0005A1/Z2ve&$\u00180\u0003\u0002wg\n\u00112I]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s\u0011\u0015A\b\u0001\"\u0001z\u0003\u0019a\u0014N\\5u}Q\u0011\"p\u001f?~}~\f\t!a\u0001\u0002\u0006\u0005\u001d\u0011\u0011CA\n!\tA\u0001\u0001C\u0003\u0013o\u0002\u0007Q\u0003C\u0003\u001fo\u0002\u0007q\u0004C\u0003.o\u0002\u0007Q\u0003C\u00030o\u0002\u0007\u0001\u0007C\u00035o\u0002\u0007Q\u0007C\u0003:o\u0002\u0007!\bC\u0003?o\u0002\u0007q\bC\u0003Fo\u0002\u0007a\t\u0003\u0004No\u0002\u0007\u0011\u0011\u0002\u0019\u0005\u0003\u0017\ty\u0001E\u0003Q+^\u000bi\u0001E\u0002`\u0003\u001f!!\"YA\u0004\u0003\u0003\u0005\tQ!\u0001c\u0011\u0015qq\u000f1\u0001k\u0011\u0015\u0001x\u000f1\u0001r\u000f\u001d\t9\u0002\u0001E\u0005\u00033\tAbQ8o]\u0016\u001cG/[8o\u0013\u0012\u0004B!a\u0007\u0002\u001e5\t\u0001AB\u0004\u0002 \u0001AI!!\t\u0003\u0019\r{gN\\3di&|g.\u00133\u0014\r\u0005u\u00111EA\u0015!\r1\u0012QE\u0005\u0004\u0003O9\"AB!osJ+g\rE\u0002\u0017\u0003WI1!!\f\u0018\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u001dA\u0018Q\u0004C\u0001\u0003c!\"!!\u0007\t\u0011\u0005U\u0012Q\u0004C\u0001\u0003o\t!B\u001a:p[N#(/\u001b8h)\u0011\tIDa\u0001\u0011\u000bY\tY$a\u0010\n\u0007\u0005urC\u0001\u0004PaRLwN\u001c\t\u0005\u00037\t\tE\u0002\u0004\u0002 \u0001!\u00151I\n\t\u0003\u0003\n\u0019#!\u0012\u0002*A\u0019a#a\u0012\n\u0007\u0005%sCA\u0004Qe>$Wo\u0019;\t\u0017\u00055\u0013\u0011\tBK\u0002\u0013\u0005\u0011qJ\u0001\nY>\u001c\u0017\r\u001c%pgR,\u0012a\u0016\u0005\u000b\u0003'\n\tE!E!\u0002\u00139\u0016A\u00037pG\u0006d\u0007j\\:uA!Q\u0011qKA!\u0005+\u0007I\u0011\u0001\u000b\u0002\u00131|7-\u00197Q_J$\bBCA.\u0003\u0003\u0012\t\u0012)A\u0005+\u0005QAn\\2bYB{'\u000f\u001e\u0011\t\u0017\u0005}\u0013\u0011\tBK\u0002\u0013\u0005\u0011qJ\u0001\u000be\u0016lw\u000e^3I_N$\bBCA2\u0003\u0003\u0012\t\u0012)A\u0005/\u0006Y!/Z7pi\u0016Dun\u001d;!\u0011)\t9'!\u0011\u0003\u0016\u0004%\t\u0001F\u0001\u000be\u0016lw\u000e^3Q_J$\bBCA6\u0003\u0003\u0012\t\u0012)A\u0005+\u0005Y!/Z7pi\u0016\u0004vN\u001d;!\u0011\u001dA\u0018\u0011\tC\u0001\u0003_\"\"\"a\u0010\u0002r\u0005M\u0014QOA<\u0011\u001d\ti%!\u001cA\u0002]Cq!a\u0016\u0002n\u0001\u0007Q\u0003C\u0004\u0002`\u00055\u0004\u0019A,\t\u000f\u0005\u001d\u0014Q\u000ea\u0001+!A\u00111PA!\t\u0003\ni(\u0001\u0005u_N#(/\u001b8h)\u00059\u0006BCAA\u0003\u0003\n\t\u0011\"\u0001\u0002\u0004\u0006!1m\u001c9z))\ty$!\"\u0002\b\u0006%\u00151\u0012\u0005\n\u0003\u001b\ny\b%AA\u0002]C\u0011\"a\u0016\u0002\u0000A\u0005\t\u0019A\u000b\t\u0013\u0005}\u0013q\u0010I\u0001\u0002\u00049\u0006\"CA4\u0003\u007f\u0002\n\u00111\u0001\u0016\u0011)\ty)!\u0011\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019JK\u0002X\u0003+[#!a&\u0011\t\u0005e\u00151U\u0007\u0003\u00037SA!!(\u0002 \u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003C;\u0012AC1o]>$\u0018\r^5p]&!\u0011QUAN\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\u000b\u0003S\u000b\t%%A\u0005\u0002\u0005-\u0016AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[S3!FAK\u0011)\t\t,!\u0011\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\t),!\u0011\u0012\u0002\u0013\u0005\u00111V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\tI,!\u0011\u0002\u0002\u0013\u0005\u00131X\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0006\u0003BA`\u0003\u000bl!!!1\u000b\u0007\u0005\r7+\u0001\u0003mC:<\u0017b\u0001/\u0002B\"I\u0011\u0011ZA!\u0003\u0003%\t\u0001F\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\u000b\u0003\u001b\f\t%!A\u0005\u0002\u0005=\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004M\u0006E\u0007\"CAj\u0003\u0017\f\t\u00111\u0001\u0016\u0003\rAH%\r\u0005\u000b\u0003/\f\t%!A\u0005B\u0005e\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005m\u0007#BAo\u0003G4WBAAp\u0015\r\t\toF\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAs\u0003?\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0005\u000b\u0003S\f\t%!A\u0005\u0002\u0005-\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u00055\u00181\u001f\t\u0004-\u0005=\u0018bAAy/\t9!i\\8mK\u0006t\u0007\"CAj\u0003O\f\t\u00111\u0001g\u0011)\t90!\u0011\u0002\u0002\u0013\u0005\u0013\u0011`\u0001\tQ\u0006\u001c\bnQ8eKR\tQ\u0003\u0003\u0006\u0002~\u0006\u0005\u0013\u0011!C!\u0003\u007f\fa!Z9vC2\u001cH\u0003BAw\u0005\u0003A\u0011\"a5\u0002|\u0006\u0005\t\u0019\u00014\t\u000f\t\u0015\u00111\u0007a\u0001/\u0006\t1\u000f\u0003\u0006\u0003\n\u0005u\u0011\u0011!CA\u0005\u0017\tQ!\u00199qYf$\"\"a\u0010\u0003\u000e\t=!\u0011\u0003B\n\u0011\u001d\tiEa\u0002A\u0002]Cq!a\u0016\u0003\b\u0001\u0007Q\u0003C\u0004\u0002`\t\u001d\u0001\u0019A,\t\u000f\u0005\u001d$q\u0001a\u0001+!Q!qCA\u000f\u0003\u0003%\tI!\u0007\u0002\u000fUt\u0017\r\u001d9msR!!1\u0004B\u0012!\u00151\u00121\bB\u000f!\u001d1\"qD,\u0016/VI1A!\t\u0018\u0005\u0019!V\u000f\u001d7fi!Q!Q\u0005B\u000b\u0003\u0003\u0005\r!a\u0010\u0002\u0007a$\u0003\u0007C\u0005\u0003*\u0001\u0011\r\u0011\"\u0003\u0003,\u0005qa.Z<D_:tWm\u0019;j_:\u001cXC\u0001B\u0017!\u0019\u0011yC!\u000e\u0003:5\u0011!\u0011\u0007\u0006\u0004\u0005g\t\u0016AC2p]\u000e,(O]3oi&!!q\u0007B\u0019\u0005U\u0019uN\\2veJ,g\u000e\u001e'j].,G-U;fk\u0016\u0004BAa\u000f\u0003F5\u0011!Q\b\u0006\u0005\u0005\u007f\u0011\t%\u0001\u0005dQ\u0006tg.\u001a7t\u0015\r\u0011\u0019eU\u0001\u0004]&|\u0017\u0002\u0002B$\u0005{\u0011QbU8dW\u0016$8\t[1o]\u0016d\u0007\u0002\u0003B&\u0001\u0001\u0006IA!\f\u0002\u001f9,woQ8o]\u0016\u001cG/[8og\u0002B\u0011Ba\u0014\u0001\u0005\u0004%IA!\u0015\u0002#%tg\r\\5hQR\u0014Vm\u001d9p]N,7/\u0006\u0002\u0003TA9!Q\u000bB./\nuSB\u0001B,\u0015\u0011\u0011I&a8\u0002\u000f5,H/\u00192mK&\u0019aKa\u0016\u0011\t\t}#Q\r\b\u0004\u0011\t\u0005\u0014b\u0001B2\u0005\u0005q!+Z9vKN$8\t[1o]\u0016d\u0017\u0002\u0002B4\u0005S\u0012\u0001BU3ta>t7/\u001a\u0006\u0004\u0005G\u0012\u0001\u0002\u0003B7\u0001\u0001\u0006IAa\u0015\u0002%%tg\r\\5hQR\u0014Vm\u001d9p]N,7\u000f\t\u0005\n\u0005c\u0002!\u0019!C\u0005\u0005g\n!\"\\3ue&\u001cG+Y4t+\t\u0011)\b\u0005\u0004Q+\u0006u\u0016Q\u0018\u0005\t\u0005s\u0002\u0001\u0015!\u0003\u0003v\u0005YQ.\u001a;sS\u000e$\u0016mZ:!\u0011%\u0011i\b\u0001b\u0001\n\u0013\u0011y(\u0001\u0005tK2,7\r^8s+\t\u0011\t\tE\u0002A\u0005\u0007K1A!\"B\u0005!\u0019V\r\\3di>\u0014\b\u0002\u0003BE\u0001\u0001\u0006IA!!\u0002\u0013M,G.Z2u_J\u0004\u0003b\u0002BG\u0001\u0011\u0005#qR\u0001\u0004eVtGC\u0001BI!\r1\"1S\u0005\u0004\u0005+;\"\u0001B+oSRDqA!'\u0001\t\u0013\u0011y)A\nqe>\u001cWm]:OK^\u0014Vm\u001d9p]N,7\u000f\u0003\u0005\u0003\u001e\u0002!\tB\u0001BP\u00031\u0019XM\u001c3SKN\u0004xN\\:f)\u0011\u0011\tJ!)\t\u0011\t\r&1\u0014a\u0001\u0005;\n\u0001B]3ta>t7/\u001a\u0005\b\u0005O\u0003A\u0011\u0002BH\u0003\u0011\u0001x\u000e\u001c7\t\u000f\t-\u0006\u0001\"\u0003\u0003\u0010\u0006A\u0002O]8dKN\u001c8i\\7qY\u0016$X\r\u001a*fG\u0016Lg/Z:\t\u000f\t=\u0006\u0001\"\u0003\u0003\u0010\u0006)\u0002O]8dKN\u001c8i\\7qY\u0016$X\rZ*f]\u0012\u001c\bb\u0002BZ\u0001\u0011%!qR\u0001\u0014aJ|7-Z:t\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u0005\b\u0005o\u0003A\u0011\u0001B]\u0003\u0019\t7mY3qiR!!\u0011\u0013B^\u0011!\u0011iL!.A\u0002\te\u0012!D:pG.,Go\u00115b]:,G\u000eC\u0004\u0003B\u0002!IAa$\u0002/\r|gNZ5hkJ,g*Z<D_:tWm\u0019;j_:\u001c\bb\u0002Bc\u0001\u0011%!qR\u0001\tG2|7/Z!mY\"A!\u0011\u001a\u0001\u0005\u0002\t\u0011Y-A\u0004dQ\u0006tg.\u001a7\u0015\t\t5'Q\u001b\t\u0006-\u0005m\"q\u001a\t\u0004\u0001\nE\u0017b\u0001Bj\u0003\na1*\u00194lC\u000eC\u0017M\u001c8fY\"9!q\u001bBd\u0001\u00049\u0016\u0001D2p]:,7\r^5p]&#\u0007b\u0002Bn\u0001\u0011\u0005!qR\u0001\u0007o\u0006\\W-\u001e9)\t\te'q\u001c\t\u0005\u0003\u007f\u0013\t/\u0003\u0003\u0003d\u0006\u0005'\u0001C(wKJ\u0014\u0018\u000eZ3")
public class Processor
extends AbstractServerThread
implements KafkaMetricsGroup {
    private final int id;
    public final Time kafka$network$Processor$$time;
    public final RequestChannel kafka$network$Processor$$requestChannel;
    public final ConnectionQuotas kafka$network$Processor$$connectionQuotas;
    public final ListenerName kafka$network$Processor$$listenerName;
    public final SecurityProtocol kafka$network$Processor$$securityProtocol;
    public final Metrics kafka$network$Processor$$metrics;
    private final ConcurrentLinkedQueue<SocketChannel> newConnections;
    private final scala.collection.mutable.Map<String, RequestChannel.Response> kafka$network$Processor$$inflightResponses;
    private final java.util.Map<String, String> kafka$network$Processor$$metricTags;
    private final Selector kafka$network$Processor$$selector;
    private volatile Processor$ConnectionId$ kafka$network$Processor$$ConnectionId$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Processor$ConnectionId$ kafka$network$Processor$$ConnectionId$lzycompute() {
        Processor processor = this;
        synchronized (processor) {
            if (this.kafka$network$Processor$$ConnectionId$module != null) return this.kafka$network$Processor$$ConnectionId$module;
            this.kafka$network$Processor$$ConnectionId$module = new Processor$ConnectionId$(this);
            return this.kafka$network$Processor$$ConnectionId$module;
        }
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    public int id() {
        return this.id;
    }

    public Processor$ConnectionId$ kafka$network$Processor$$ConnectionId() {
        return this.kafka$network$Processor$$ConnectionId$module == null ? this.kafka$network$Processor$$ConnectionId$lzycompute() : this.kafka$network$Processor$$ConnectionId$module;
    }

    private ConcurrentLinkedQueue<SocketChannel> newConnections() {
        return this.newConnections;
    }

    public scala.collection.mutable.Map<String, RequestChannel.Response> kafka$network$Processor$$inflightResponses() {
        return this.kafka$network$Processor$$inflightResponses;
    }

    public java.util.Map<String, String> kafka$network$Processor$$metricTags() {
        return this.kafka$network$Processor$$metricTags;
    }

    public Selector kafka$network$Processor$$selector() {
        return this.kafka$network$Processor$$selector;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.startupComplete();
        while (true) {
            if (this.isRunning()) ** GOTO lbl-1000
            this.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Closing selector - processor ").append(BoxesRunTime.boxToInteger(this.$outer.id())).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.swallowError((Function0<BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$network$Processor$$closeAll();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.shutdownComplete();
            return;
lbl-1000:
            // 1 sources

            {
                this.configureNewConnections();
                this.processNewResponses();
                this.poll();
                this.processCompletedReceives();
                this.processCompletedSends();
                this.processDisconnected();
                continue;
            }
            break;
        }
    }

    private void processNewResponses() {
        ObjectRef<RequestChannel.Response> curr = ObjectRef.create(this.kafka$network$Processor$$requestChannel.receiveResponse(this.id()));
        while ((RequestChannel.Response)curr.elem != null) {
            try {
                BoxedUnit boxedUnit;
                RequestChannel.ResponseAction responseAction = ((RequestChannel.Response)curr.elem).responseAction();
                if (RequestChannel$NoOpAction$.MODULE$.equals(responseAction)) {
                    BoxedUnit boxedUnit2;
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)((Object)new Serializable(this, curr){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef curr$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Socket server received empty response to send, registering for read: ").append((RequestChannel.Response)this.curr$1.elem).toString();
                        }
                        {
                            this.curr$1 = curr$1;
                        }
                    }));
                    String channelId = ((RequestChannel.Response)curr.elem).request().connectionId();
                    if (this.kafka$network$Processor$$selector().channel(channelId) == null && this.kafka$network$Processor$$selector().closingChannel(channelId) == null) {
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        this.kafka$network$Processor$$selector().unmute(channelId);
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                if (RequestChannel$SendAction$.MODULE$.equals(responseAction)) {
                    this.sendResponse((RequestChannel.Response)curr.elem);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                if (RequestChannel$CloseConnectionAction$.MODULE$.equals(responseAction)) {
                    ((RequestChannel.Response)curr.elem).request().updateRequestMetrics();
                    this.trace((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Closing socket connection actively according to the response code.";
                        }
                    }));
                    this.close(this.kafka$network$Processor$$selector(), ((RequestChannel.Response)curr.elem).request().connectionId());
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
                throw new MatchError(responseAction);
            }
            finally {
                curr.elem = this.kafka$network$Processor$$requestChannel.receiveResponse(this.id());
                continue;
            }
            break;
        }
        return;
    }

    public void sendResponse(RequestChannel.Response response) {
        this.trace((Function0<String>)((Object)new Serializable(this, response){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Response response$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Socket server received response to send, registering for write and sending data: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.response$1}));
            }
            {
                this.response$1 = response$1;
            }
        }));
        KafkaChannel channel = this.kafka$network$Processor$$selector().channel(response.responseSend().destination());
        if (channel == null) {
            this.warn((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Processor $outer;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to send response via channel for which there is no open connection, connection id ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.id())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            response.request().updateRequestMetrics();
        } else {
            this.kafka$network$Processor$$selector().send(response.responseSend());
            this.kafka$network$Processor$$inflightResponses().$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(response.request().connectionId()), response));
        }
    }

    private void poll() {
        try {
            this.kafka$network$Processor$$selector().poll(300L);
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalStateException ? true : throwable2 instanceof IOException;
            if (bl) {
                this.error((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing processor ", " due to illegal state or IO exception"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.id())}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$network$Processor$$closeAll();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.shutdownComplete();
                throw throwable2;
            }
            throw throwable;
        }
    }

    private void processCompletedReceives() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().completedReceives()).asScala()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(NetworkReceive receive) {
                Throwable throwable2;
                block2: {
                    try {
                        KafkaChannel openChannel = this.$outer.kafka$network$Processor$$selector().channel(receive.source());
                        KafkaChannel channel = openChannel == null ? this.$outer.kafka$network$Processor$$selector().closingChannel(receive.source()) : openChannel;
                        RequestChannel.Session session = new RequestChannel.Session(new KafkaPrincipal("User", channel.principal().getName()), channel.socketAddress());
                        RequestChannel.Request req = new RequestChannel.Request(this.$outer.id(), receive.source(), session, receive.payload(), this.$outer.kafka$network$Processor$$time.milliseconds(), this.$outer.kafka$network$Processor$$listenerName, this.$outer.kafka$network$Processor$$securityProtocol);
                        this.$outer.kafka$network$Processor$$requestChannel.sendRequest(req);
                        this.$outer.kafka$network$Processor$$selector().mute(receive.source());
                    }
                    catch (Throwable throwable2) {
                        Throwable throwable3 = throwable2;
                        boolean bl = throwable3 instanceof InvalidRequestException ? true : throwable3 instanceof SchemaException;
                        if (!bl) break block2;
                        this.$outer.error((Function0<String>)((Object)new Serializable(this, receive){
                            public static final long serialVersionUID = 0L;
                            private final NetworkReceive receive$1;

                            public final String apply() {
                                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closing socket for ", " because of error"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.receive$1.source()}));
                            }
                            {
                                this.receive$1 = receive$1;
                            }
                        }), (Function0<Throwable>)((Object)new Serializable(this, throwable3){
                            public static final long serialVersionUID = 0L;
                            private final Throwable x5$1;

                            public final Throwable apply() {
                                return this.x5$1;
                            }
                            {
                                this.x5$1 = x5$1;
                            }
                        }));
                        this.$outer.close(this.$outer.kafka$network$Processor$$selector(), receive.source());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw throwable2;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void processCompletedSends() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().completedSends()).asScala()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(Send send2) {
                RequestChannel.Response resp = (RequestChannel.Response)((Object)this.$outer.kafka$network$Processor$$inflightResponses().remove(send2.destination()).getOrElse(new Serializable(this, send2){
                    public static final long serialVersionUID = 0L;
                    private final Send send$1;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Send for ", " completed, but not in `inflightResponses`"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.send$1.destination()})));
                    }
                    {
                        this.send$1 = send$1;
                    }
                }));
                resp.request().updateRequestMetrics();
                this.$outer.kafka$network$Processor$$selector().unmute(send2.destination());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void processDisconnected() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().disconnected()).asScala()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(String connectionId) {
                String remoteHost = ((ConnectionId)((Object)this.$outer.kafka$network$Processor$$ConnectionId().fromString(connectionId).getOrElse(new Serializable(this, connectionId){
                    public static final long serialVersionUID = 0L;
                    private final String connectionId$2;

                    public final Nothing$ apply() {
                        throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"connectionId has unexpected format: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.connectionId$2})));
                    }
                    {
                        this.connectionId$2 = connectionId$2;
                    }
                }))).remoteHost();
                this.$outer.kafka$network$Processor$$inflightResponses().remove(connectionId).foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(RequestChannel.Response x$6) {
                        x$6.request().updateRequestMetrics();
                    }
                });
                this.$outer.kafka$network$Processor$$connectionQuotas.dec(InetAddress.getByName(remoteHost));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void accept(SocketChannel socketChannel) {
        this.newConnections().add(socketChannel);
        this.wakeup();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void configureNewConnections() {
        while (!this.newConnections().isEmpty()) {
            SocketChannel channel = this.newConnections().poll();
            try {
                this.debug((Function0<String>)((Object)new Serializable(this, channel){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;
                    private final SocketChannel channel$2;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " listening to new connection from ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.id()), this.channel$2.socket().getRemoteSocketAddress()}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.channel$2 = channel$2;
                    }
                }));
                String localHost = channel.socket().getLocalAddress().getHostAddress();
                int localPort = channel.socket().getLocalPort();
                String remoteHost = channel.socket().getInetAddress().getHostAddress();
                int remotePort = channel.socket().getPort();
                String connectionId = this.kafka$network$Processor$$ConnectionId().apply(localHost, localPort, remoteHost, remotePort).toString();
                this.kafka$network$Processor$$selector().register(connectionId, channel);
                continue;
            }
            catch (Throwable throwable) {
                void var1_1;
                Throwable throwable2 = throwable;
                Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable2);
                if (option.isEmpty()) {
                    throw throwable;
                }
                Throwable e = option.get();
                SocketAddress remoteAddress = var1_1.getRemoteAddress();
                this.close((SocketChannel)var1_1);
                this.error((Function0<String>)((Object)new Serializable(this, remoteAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ Processor $outer;
                    private final SocketAddress remoteAddress$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Processor ", " closed connection from ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.id()), this.remoteAddress$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.remoteAddress$1 = remoteAddress$1;
                    }
                }), (Function0<Throwable>)((Object)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Throwable e$3;

                    public final Throwable apply() {
                        return this.e$3;
                    }
                    {
                        this.e$3 = e$3;
                    }
                }));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            break;
        }
        return;
    }

    public void kafka$network$Processor$$closeAll() {
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.kafka$network$Processor$$selector().channels()).asScala()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Processor $outer;

            public final void apply(KafkaChannel channel) {
                this.$outer.close(this.$outer.kafka$network$Processor$$selector(), channel.id());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.kafka$network$Processor$$selector().close();
    }

    public Option<KafkaChannel> channel(String connectionId) {
        return Option$.MODULE$.apply(this.kafka$network$Processor$$selector().channel(connectionId));
    }

    @Override
    public void wakeup() {
        this.kafka$network$Processor$$selector().wakeup();
    }

    public Processor(int id, Time time, int maxRequestSize, RequestChannel requestChannel, ConnectionQuotas connectionQuotas, long connectionsMaxIdleMs, ListenerName listenerName, SecurityProtocol securityProtocol2, java.util.Map<String, ?> channelConfigs, Metrics metrics, CredentialProvider credentialProvider) {
        this.id = id;
        this.kafka$network$Processor$$time = time;
        this.kafka$network$Processor$$requestChannel = requestChannel;
        this.kafka$network$Processor$$connectionQuotas = connectionQuotas;
        this.kafka$network$Processor$$listenerName = listenerName;
        this.kafka$network$Processor$$securityProtocol = securityProtocol2;
        this.kafka$network$Processor$$metrics = metrics;
        super(connectionQuotas);
        KafkaMetricsGroup$class.$init$(this);
        this.newConnections = new ConcurrentLinkedQueue();
        this.kafka$network$Processor$$inflightResponses = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        this.kafka$network$Processor$$metricTags = JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("networkProcessor"), ((Object)BoxesRunTime.boxToInteger(id)).toString())}))).asJava();
        this.newGauge("IdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ Processor $outer;

            public double value() {
                return BoxesRunTime.unboxToDouble(Option$.MODULE$.apply(this.$outer.kafka$network$Processor$$metrics.metric(this.$outer.kafka$network$Processor$$metrics.metricName("io-wait-ratio", "socket-server-metrics", this.$outer.kafka$network$Processor$$metricTags()))).fold(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 0.0;
                    }
                }, new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(KafkaMetric x$5) {
                        return x$5.value();
                    }
                }));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, (Map<String, String>)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.kafka$network$Processor$$metricTags()).asScala());
        this.kafka$network$Processor$$selector = new Selector(maxRequestSize, connectionsMaxIdleMs, metrics, time, "socket-server", this.kafka$network$Processor$$metricTags(), false, ChannelBuilders.serverChannelBuilder(securityProtocol2, channelConfigs, credentialProvider.credentialCache()));
    }

    public class ConnectionId
    implements Product,
    Serializable {
        private final String localHost;
        private final int localPort;
        private final String remoteHost;
        private final int remotePort;
        public final /* synthetic */ Processor $outer;

        public String localHost() {
            return this.localHost;
        }

        public int localPort() {
            return this.localPort;
        }

        public String remoteHost() {
            return this.remoteHost;
        }

        public int remotePort() {
            return this.remotePort;
        }

        public String toString() {
            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "-", ":", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.localHost(), BoxesRunTime.boxToInteger(this.localPort()), this.remoteHost(), BoxesRunTime.boxToInteger(this.remotePort())}));
        }

        public ConnectionId copy(String localHost, int localPort, String remoteHost, int remotePort) {
            return new ConnectionId(this.kafka$network$Processor$ConnectionId$$$outer(), localHost, localPort, remoteHost, remotePort);
        }

        public String copy$default$1() {
            return this.localHost();
        }

        public int copy$default$2() {
            return this.localPort();
        }

        public String copy$default$3() {
            return this.remoteHost();
        }

        public int copy$default$4() {
            return this.remotePort();
        }

        @Override
        public String productPrefix() {
            return "ConnectionId";
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger(this.remotePort());
                    break;
                }
                case 2: {
                    object = this.remoteHost();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger(this.localPort());
                    break;
                }
                case 0: {
                    object = this.localHost();
                }
            }
            return object;
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof ConnectionId;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, Statics.anyHash(this.localHost()));
            n = Statics.mix(n, this.localPort());
            n = Statics.mix(n, Statics.anyHash(this.remoteHost()));
            n = Statics.mix(n, this.remotePort());
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ConnectionId)) return false;
            boolean bl = true;
            if (!bl) return false;
            ConnectionId connectionId = (ConnectionId)x$1;
            String string2 = this.localHost();
            String string3 = connectionId.localHost();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (this.localPort() != connectionId.localPort()) return false;
            String string4 = this.remoteHost();
            String string5 = connectionId.remoteHost();
            if (string4 == null) {
                if (string5 != null) {
                    return false;
                }
            } else if (!string4.equals(string5)) return false;
            if (this.remotePort() != connectionId.remotePort()) return false;
            if (!connectionId.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ Processor kafka$network$Processor$ConnectionId$$$outer() {
            return this.$outer;
        }

        public ConnectionId(Processor $outer, String localHost, int localPort, String remoteHost, int remotePort) {
            this.localHost = localHost;
            this.localPort = localPort;
            this.remoteHost = remoteHost;
            this.remotePort = remotePort;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product$class.$init$(this);
        }
    }
}

