/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.TimeIndex$;
import kafka.log.TimestampOffset;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002V5nK&sG-\u001a=\u000b\u0005\r!\u0011a\u00017pO*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001A!\u0003\u0005\u0003\n\u00151aQ\"\u0001\u0002\n\u0005-\u0011!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007\u0010\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0003M_:<\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u0011e\u0001!\u0011!Q\u0001\ni\tAAZ5mKB\u00111\u0004I\u0007\u00029)\u0011QDH\u0001\u0003S>T\u0011aH\u0001\u0005U\u00064\u0018-\u0003\u0002\"9\t!a)\u001b7f\u0011%\u0019\u0003A!A!\u0002\u0013aA%\u0001\u0006cCN,wJ\u001a4tKRL!a\t\u0006\t\u0013\u0019\u0002!\u0011!Q\u0001\n\u001dR\u0013\u0001D7bq&sG-\u001a=TSj,\u0007CA\u0007)\u0013\tIcBA\u0002J]RL!A\n\u0006\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\u0011qs\u0006M\u0019\u0011\u0005%\u0001\u0001\"B\r,\u0001\u0004Q\u0002\"B\u0012,\u0001\u0004a\u0001b\u0002\u0014,!\u0003\u0005\ra\n\u0005\u0006g\u0001!\t\u0005N\u0001\nK:$(/_*ju\u0016,\u0012a\n\u0005\u0006m\u0001!\teN\u0001\u0007SN4U\u000f\u001c7\u0016\u0003a\u0002\"!D\u001d\n\u0005ir!a\u0002\"p_2,\u0017M\u001c\u0005\u0006y\u0001!I!P\u0001\ni&lWm\u001d;b[B$2\u0001\u0004 G\u0011\u0015y4\b1\u0001A\u0003\u0019\u0011WO\u001a4feB\u0011\u0011\tR\u0007\u0002\u0005*\u00111IH\u0001\u0004]&|\u0017BA#C\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0006\u000fn\u0002\raJ\u0001\u0002]\")\u0011\n\u0001C\u0005\u0015\u0006q!/\u001a7bi&4Xm\u00144gg\u0016$HcA\u0014L\u0019\")q\b\u0013a\u0001\u0001\")q\t\u0013a\u0001O!)a\n\u0001C\u0001\u001f\u0006IA.Y:u\u000b:$(/_\u000b\u0002!B\u0011\u0011\"U\u0005\u0003%\n\u0011q\u0002V5nKN$\u0018-\u001c9PM\u001a\u001cX\r\u001e\u0005\u0006)\u0002!\t!V\u0001\u0006K:$(/\u001f\u000b\u0003!ZCQaR*A\u0002\u001dBQ\u0001\u0017\u0001\u0005Be\u000b!\u0002]1sg\u0016,e\u000e\u001e:z)\rQVL\u0018\t\u0003\u0013mK!\u0001\u0018\u0002\u0003\u0015%sG-\u001a=F]R\u0014\u0018\u0010C\u0003@/\u0002\u0007\u0001\tC\u0003H/\u0002\u0007q\u0005C\u0003a\u0001\u0011\u0005\u0011-A\u0006nCf\u0014W-\u00119qK:$G\u0003\u00022fM\"\u0004\"!D2\n\u0005\u0011t!\u0001B+oSRDQ\u0001P0A\u00021AQaZ0A\u00021\taa\u001c4gg\u0016$\bbB5`!\u0003\u0005\r\u0001O\u0001\u000eg.L\u0007OR;mY\u000eCWmY6\t\u000b-\u0004A\u0011\u00017\u0002\r1|wn[;q)\t\u0001V\u000eC\u0003oU\u0002\u0007A\"A\buCJ<W\r\u001e+j[\u0016\u001cH/Y7q\u0011\u0015\u0001\b\u0001\"\u0011r\u0003!!(/\u001e8dCR,G#\u00012\t\u000bM\u0004A\u0011\t;\u0002\u0015Q\u0014XO\\2bi\u0016$v\u000e\u0006\u0002ck\")qM\u001da\u0001\u0019!)q\u000f\u0001C\u0005q\u0006\tBO];oG\u0006$X\rV8F]R\u0014\u0018.Z:\u0015\u0005\tL\b\"\u0002>w\u0001\u00049\u0013aB3oiJLWm\u001d\u0005\u0006y\u0002!\t%]\u0001\fg\u0006t\u0017\u000e^=DQ\u0016\u001c7\u000eC\u0004\u007f\u0001E\u0005I\u0011A@\u0002+5\f\u0017PY3BaB,g\u000e\u001a\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\u0001\u0016\u0004q\u0005\r1FAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=a\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u001b\u0005]\u0001\u0001%A\u0002\u0002\u0003%I!!\u0007%\u0003A\u0019X\u000f]3sI\t\f7/Z(gMN,G/F\u0001\r\u000f%\tiBAA\u0001\u0012\u0003\ty\"A\u0005US6,\u0017J\u001c3fqB\u0019\u0011\"!\t\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003G\u0019B!!\t\u0002&A\u0019Q\"a\n\n\u0007\u0005%bB\u0001\u0004B]f\u0014VM\u001a\u0005\bY\u0005\u0005B\u0011AA\u0017)\t\ty\u0002\u0003\u0006\u00022\u0005\u0005\u0012\u0013!C\u0001\u0003g\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTCAA\u001bU\r9\u00131\u0001")
public class TimeIndex
extends AbstractIndex<Object, Object> {
    public final File kafka$log$TimeIndex$$file;

    public static int $lessinit$greater$default$3() {
        return TimeIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ long kafka$log$TimeIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 12;
    }

    @Override
    public boolean isFull() {
        return this.entries() >= this.maxEntries() - 1;
    }

    public long kafka$log$TimeIndex$$timestamp(ByteBuffer buffer, int n) {
        return buffer.getLong(n * this.entrySize());
    }

    public int kafka$log$TimeIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 8);
    }

    public TimestampOffset lastEntry() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        timestampOffset = (TimestampOffset)this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                    }
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public TimestampOffset entry(int n) {
        return this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int n$1;

            public final TimestampOffset apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from a time index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.n$1), BoxesRunTime.boxToInteger(this.$outer._entries())})));
                }
                ByteBuffer idx = this.$outer.mmap().duplicate();
                return new TimestampOffset(this.$outer.kafka$log$TimeIndex$$timestamp(idx, this.n$1), this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new TimestampOffset(this.kafka$log$TimeIndex$$timestamp(buffer, n), super.baseOffset() + (long)this.kafka$log$TimeIndex$$relativeOffset(buffer, n));
    }

    public void maybeAppend(long timestamp2, long offset, boolean skipFullCheck) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, timestamp2, offset, skipFullCheck){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            public final long timestamp$1;
            public final long offset$1;
            private final boolean skipFullCheck$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (!this.skipFullCheck$1) {
                    Predef$.MODULE$.require(!this.$outer.isFull(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Attempt to append to a full time index (size = ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
                if (this.$outer._entries() != 0 && this.offset$1 < this.$outer.lastEntry().offset()) {
                    throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to slot %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer._entries()), BoxesRunTime.boxToLong(this.$outer.lastEntry().offset()), this.$outer.kafka$log$TimeIndex$$file.getAbsolutePath()})));
                }
                if (this.$outer._entries() != 0 && this.timestamp$1 < this.$outer.lastEntry().timestamp()) {
                    throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an timestamp (%d) to slot %d no larger than the last timestamp appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.timestamp$1), BoxesRunTime.boxToInteger(this.$outer._entries()), BoxesRunTime.boxToLong(this.$outer.lastEntry().timestamp()), this.$outer.kafka$log$TimeIndex$$file.getAbsolutePath()})));
                }
                if (this.timestamp$1 > this.$outer.lastEntry().timestamp()) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.timestamp$1), BoxesRunTime.boxToLong(this.$outer.offset$1), this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().kafka$log$TimeIndex$$file.getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.$outer.mmap().putLong(this.timestamp$1);
                    this.$outer.mmap().putInt((int)(this.offset$1 - this.$outer.kafka$log$TimeIndex$$super$baseOffset()));
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$maybeAppend$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer()._entries()).append((Object)" entries but file position in index is ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$TimeIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                }
            }

            public /* synthetic */ TimeIndex kafka$log$TimeIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.timestamp$1 = timestamp$1;
                this.offset$1 = offset$1;
                this.skipFullCheck$1 = skipFullCheck$1;
            }
        });
    }

    public boolean maybeAppend$default$3() {
        return false;
    }

    public TimestampOffset lookup(long targetTimestamp) {
        return this.maybeLock(this.lock(), new Serializable(this, targetTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long targetTimestamp$1;

            public final TimestampOffset apply() {
                TimestampOffset timestampOffset;
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.indexSlotFor(idx, this.targetTimestamp$1, IndexSearchType$.MODULE$.KEY());
                if (slot == -1) {
                    timestampOffset = new TimestampOffset(-1L, this.$outer.kafka$log$TimeIndex$$super$baseOffset());
                } else {
                    TimestampOffset entry2 = (TimestampOffset)this.$outer.parseEntry(idx, slot);
                    timestampOffset = new TimestampOffset(entry2.timestamp(), entry2.offset());
                }
                return timestampOffset;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetTimestamp$1 = targetTimestamp$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$TimeIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.indexSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.VALUE());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$TimeIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$TimeIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$TimeIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$TimeIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final int entries$1;

            public final Buffer apply() {
                this.$outer._entries_$eq(this.entries$1);
                return this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        TimestampOffset entry2 = this.lastEntry();
        long lastTimestamp = entry2.timestamp();
        long lastOffset = entry2.offset();
        Predef$.MODULE$.require(this._entries() == 0 || lastTimestamp >= this.kafka$log$TimeIndex$$timestamp(this.mmap(), 0), (Function0<Object>)((Object)new Serializable(this, lastTimestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long lastTimestamp$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last timestamp "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$TimeIndex$$file.getAbsolutePath()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the first timestamp ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastTimestamp$1), BoxesRunTime.boxToLong(this.$outer.kafka$log$TimeIndex$$timestamp(this.$outer.mmap(), 0))}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastTimestamp$1 = lastTimestamp$1;
            }
        }));
        Predef$.MODULE$.require(this._entries() == 0 || lastOffset >= super.baseOffset(), (Function0<Object>)((Object)new Serializable(this, lastOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long lastOffset$1;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt time index found, time index file (", ") has non-zero size but the last offset "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$TimeIndex$$file.getAbsolutePath()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is smaller than the first offset ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.lastOffset$1), BoxesRunTime.boxToLong(this.$outer.kafka$log$TimeIndex$$super$baseOffset())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.lastOffset$1 = lastOffset$1;
            }
        }));
        long len = this.kafka$log$TimeIndex$$file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0<Object>)((Object)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TimeIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Time index file ").append((Object)this.$outer.kafka$log$TimeIndex$$file.getAbsolutePath()).append((Object)" is corrupt, found ").append(BoxesRunTime.boxToLong(this.len$1)).append((Object)" bytes which is not positive or not a multiple of 12.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        }));
    }

    public TimeIndex(File file, long baseOffset, int maxIndexSize) {
        this.kafka$log$TimeIndex$$file = file;
        super(file, baseOffset, maxIndexSize);
    }
}

