/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import kafka.common.InvalidOffsetException;
import kafka.log.AbstractIndex;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.log.OffsetIndex$;
import kafka.log.OffsetPosition;
import kafka.utils.CoreUtils$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001B\u0001\u0003\u0001\u001d\u00111b\u00144gg\u0016$\u0018J\u001c3fq*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0005\u0013)a!#D\u0001\u0003\u0013\tY!AA\u0007BEN$(/Y2u\u0013:$W\r\u001f\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0005\u0019>tw\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\u0004\u0013:$\b\u0002\u0003\f\u0001\u0005\u0003\u0005\u000b\u0011B\f\u0002\t\u0019LG.\u001a\t\u00031ui\u0011!\u0007\u0006\u00035m\t!![8\u000b\u0003q\tAA[1wC&\u0011a$\u0007\u0002\u0005\r&dW\rC\u0005!\u0001\t\u0005\t\u0015!\u0003\rC\u0005Q!-Y:f\u001f\u001a47/\u001a;\n\u0005\u0001R\u0001\"C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n%\u00031i\u0017\r_%oI\u0016D8+\u001b>f\u0013\t\u0019#\u0002C\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0005Q%R3\u0006\u0005\u0002\n\u0001!)a#\na\u0001/!)\u0001%\na\u0001\u0019!91%\nI\u0001\u0002\u0004\u0011\u0002\"B\u0017\u0001\t\u0003r\u0013!C3oiJL8+\u001b>f+\u0005\u0011\u0002B\u0002\u0019\u0001A\u0003&A\"A\u0006`Y\u0006\u001cHo\u00144gg\u0016$\b\"\u0002\u001a\u0001\t\u0013\u0019\u0014!\u00037bgR,e\u000e\u001e:z+\u0005!\u0004CA\u00056\u0013\t1$A\u0001\bPM\u001a\u001cX\r\u001e)pg&$\u0018n\u001c8\t\u000ba\u0002A\u0011A\u001d\u0002\u00151\f7\u000f^(gMN,G/F\u0001\r\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0019awn\\6vaR\u0011A'\u0010\u0005\u0006}i\u0002\r\u0001D\u0001\ri\u0006\u0014x-\u001a;PM\u001a\u001cX\r\u001e\u0005\u0006\u0001\u0002!I!Q\u0001\u000fe\u0016d\u0017\r^5wK>3gm]3u)\r\u0011\"I\u0013\u0005\u0006\u0007~\u0002\r\u0001R\u0001\u0007EV4g-\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d[\u0012a\u00018j_&\u0011\u0011J\u0012\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\b\"B&@\u0001\u0004\u0011\u0012!\u00018\t\u000b5\u0003A\u0011\u0002(\u0002\u0011AD\u0017p]5dC2$2AE(Q\u0011\u0015\u0019E\n1\u0001E\u0011\u0015YE\n1\u0001\u0013\u0011\u0015\u0011\u0006\u0001\"\u0011T\u0003)\u0001\u0018M]:f\u000b:$(/\u001f\u000b\u0004)^C\u0006CA\u0005V\u0013\t1&A\u0001\u0006J]\u0012,\u00070\u00128uefDQaQ)A\u0002\u0011CQaS)A\u0002IAQA\u0017\u0001\u0005\u0002m\u000bQ!\u001a8uef$\"\u0001\u000e/\t\u000b-K\u0006\u0019\u0001\n\t\u000by\u0003A\u0011A0\u0002\r\u0005\u0004\b/\u001a8e)\r\u00017-\u001a\t\u0003\u001b\u0005L!A\u0019\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006Iv\u0003\r\u0001D\u0001\u0007_\u001a47/\u001a;\t\u000b\u0019l\u0006\u0019\u0001\n\u0002\u0011A|7/\u001b;j_:DQ\u0001\u001b\u0001\u0005B%\f\u0001\u0002\u001e:v]\u000e\fG/\u001a\u000b\u0002A\")1\u000e\u0001C!Y\u0006QAO];oG\u0006$X\rV8\u0015\u0005\u0001l\u0007\"\u00023k\u0001\u0004a\u0001\"B8\u0001\t\u0013\u0001\u0018!\u0005;sk:\u001c\u0017\r^3U_\u0016sGO]5fgR\u0011\u0001-\u001d\u0005\u0006e:\u0004\rAE\u0001\bK:$(/[3t\u0011\u0015!\b\u0001\"\u0011j\u0003-\u0019\u0018M\\5us\u000eCWmY6\t\u0017Y\u0004\u0001\u0013aA\u0001\u0002\u0013%a\u0006J\u0001\u0013gV\u0004XM\u001d\u0013nCbLe\u000eZ3y'&TX\rC\u0006y\u0001A\u0005\u0019\u0011!A\u0005\ne\n\u0013\u0001E:va\u0016\u0014HEY1tK>3gm]3u\u000f\u001dQ(!!A\t\u0002m\f1b\u00144gg\u0016$\u0018J\u001c3fqB\u0011\u0011\u0002 \u0004\b\u0003\t\t\t\u0011#\u0001~'\tah\u0010\u0005\u0002\u000e\u007f&\u0019\u0011\u0011\u0001\b\u0003\r\u0005s\u0017PU3g\u0011\u00191C\u0010\"\u0001\u0002\u0006Q\t1\u0010C\u0005\u0002\nq\f\n\u0011\"\u0001\u0002\f\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM*\"!!\u0004+\u0007I\tya\u000b\u0002\u0002\u0012A!\u00111CA\u000f\u001b\t\t)B\u0003\u0003\u0002\u0018\u0005e\u0011!C;oG\",7m[3e\u0015\r\tYBD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0010\u0003+\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class OffsetIndex
extends AbstractIndex<Object, Object> {
    public final File kafka$log$OffsetIndex$$file;
    public long kafka$log$OffsetIndex$$_lastOffset;

    public static int $lessinit$greater$default$3() {
        return OffsetIndex$.MODULE$.$lessinit$greater$default$3();
    }

    public /* synthetic */ int kafka$log$OffsetIndex$$super$maxIndexSize() {
        return super.maxIndexSize();
    }

    public /* synthetic */ long kafka$log$OffsetIndex$$super$baseOffset() {
        return super.baseOffset();
    }

    @Override
    public int entrySize() {
        return 8;
    }

    public OffsetPosition kafka$log$OffsetIndex$$lastEntry() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final OffsetPosition apply() {
                OffsetPosition offsetPosition;
                int n = this.$outer._entries();
                switch (n) {
                    default: {
                        offsetPosition = (OffsetPosition)this.$outer.parseEntry(this.$outer.mmap(), n - 1);
                        break;
                    }
                    case 0: {
                        offsetPosition = new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0);
                    }
                }
                return offsetPosition;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public long lastOffset() {
        return this.kafka$log$OffsetIndex$$_lastOffset;
    }

    public OffsetPosition lookup(long targetOffset) {
        return this.maybeLock(this.lock(), new Serializable(this, targetOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long targetOffset$1;

            public final OffsetPosition apply() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.indexSlotFor(idx, this.targetOffset$1, IndexSearchType$.MODULE$.KEY());
                return slot == -1 ? new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$super$baseOffset(), 0) : (OffsetPosition)this.$outer.parseEntry(idx, slot);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.targetOffset$1 = targetOffset$1;
            }
        });
    }

    public int kafka$log$OffsetIndex$$relativeOffset(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize());
    }

    public int kafka$log$OffsetIndex$$physical(ByteBuffer buffer, int n) {
        return buffer.getInt(n * this.entrySize() + 4);
    }

    @Override
    public IndexEntry parseEntry(ByteBuffer buffer, int n) {
        return new OffsetPosition(super.baseOffset() + (long)this.kafka$log$OffsetIndex$$relativeOffset(buffer, n), this.kafka$log$OffsetIndex$$physical(buffer, n));
    }

    public OffsetPosition entry(int n) {
        return this.maybeLock(this.lock(), new Serializable(this, n){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int n$1;

            public final OffsetPosition apply() {
                if (this.n$1 >= this.$outer._entries()) {
                    throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Attempt to fetch the %dth entry from an index of size %d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.n$1), BoxesRunTime.boxToInteger(this.$outer._entries())})));
                }
                ByteBuffer idx = this.$outer.mmap().duplicate();
                return new OffsetPosition(this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, this.n$1), this.$outer.kafka$log$OffsetIndex$$physical(idx, this.n$1));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.n$1 = n$1;
            }
        });
    }

    public void append(long offset, int position) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset, position){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            public final long offset$1;
            public final int position$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Predef$.MODULE$.require(!this.$outer.isFull(), (Function0<Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$append$1 $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Attempt to append to a full index (size = ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer()._entries())).append((Object)").").toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                if (this.$outer._entries() == 0 || this.offset$1 > this.$outer.kafka$log$OffsetIndex$$_lastOffset) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Adding index entry %d => %d to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.offset$1), BoxesRunTime.boxToInteger(this.$outer.position$1), this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().kafka$log$OffsetIndex$$file.getName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    this.$outer.mmap().putInt((int)(this.offset$1 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset()));
                    this.$outer.mmap().putInt(this.position$1);
                    this.$outer._entries_$eq(this.$outer._entries() + 1);
                    this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.offset$1;
                    Predef$.MODULE$.require(this.$outer._entries() * this.$outer.entrySize() == this.$outer.mmap().position(), (Function0<Object>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$append$1 $outer;

                        public final String apply() {
                            return new StringBuilder().append(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().entries()).append((Object)" entries but file position in index is ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$anonfun$$$outer().mmap().position())).append((Object)".").toString();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }));
                    return;
                }
                throw new InvalidOffsetException(new StringOps(Predef$.MODULE$.augmentString("Attempt to append an offset (%d) to position %d no larger than the last offset appended (%d) to %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.offset$1), BoxesRunTime.boxToInteger(this.$outer.entries()), BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$_lastOffset), this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()})));
            }

            public /* synthetic */ OffsetIndex kafka$log$OffsetIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$1 = offset$1;
                this.position$1 = position$1;
            }
        });
    }

    @Override
    public void truncate() {
        this.kafka$log$OffsetIndex$$truncateToEntries(0);
    }

    @Override
    public void truncateTo(long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long offset$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ByteBuffer idx = this.$outer.mmap().duplicate();
                int slot = this.$outer.indexSlotFor(idx, this.offset$2, IndexSearchType$.MODULE$.KEY());
                int newEntries = slot < 0 ? 0 : ((long)this.$outer.kafka$log$OffsetIndex$$relativeOffset(idx, slot) == this.offset$2 - this.$outer.kafka$log$OffsetIndex$$super$baseOffset() ? slot : slot + 1);
                this.$outer.kafka$log$OffsetIndex$$truncateToEntries(newEntries);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.offset$2 = offset$2;
            }
        });
    }

    public void kafka$log$OffsetIndex$$truncateToEntries(int entries) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, entries){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final int entries$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer._entries_$eq(this.entries$1);
                this.$outer.mmap().position(this.$outer._entries() * this.$outer.entrySize());
                this.$outer.kafka$log$OffsetIndex$$_lastOffset = this.$outer.kafka$log$OffsetIndex$$lastEntry().offset();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.entries$1 = entries$1;
            }
        });
    }

    @Override
    public void sanityCheck() {
        Predef$.MODULE$.require(this._entries() == 0 || this.kafka$log$OffsetIndex$$_lastOffset > super.baseOffset(), (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Corrupt index found, index file (", ") has non-zero size but the last offset "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is ", " which is no larger than the base offset ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$super$baseOffset())}))).toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        long len = this.kafka$log$OffsetIndex$$file.length();
        Predef$.MODULE$.require(len % (long)this.entrySize() == 0L, (Function0<Object>)((Object)new Serializable(this, len){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;
            private final long len$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Index file ").append((Object)this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath()).append((Object)" is corrupt, found ").append(BoxesRunTime.boxToLong(this.len$1)).append((Object)" bytes which is not positive or not a multiple of 8.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.len$1 = len$1;
            }
        }));
    }

    public OffsetIndex(File file, long baseOffset, int maxIndexSize) {
        this.kafka$log$OffsetIndex$$file = file;
        super(file, baseOffset, maxIndexSize);
        this.kafka$log$OffsetIndex$$_lastOffset = this.kafka$log$OffsetIndex$$lastEntry().offset();
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ OffsetIndex $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Loaded index file %s with maxEntries = %d, maxIndexSize = %d, entries = %d, lastOffset = %d, file position = %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.kafka$log$OffsetIndex$$file.getAbsolutePath(), BoxesRunTime.boxToInteger(this.$outer.maxEntries()), BoxesRunTime.boxToInteger(this.$outer.kafka$log$OffsetIndex$$super$maxIndexSize()), BoxesRunTime.boxToInteger(this.$outer._entries()), BoxesRunTime.boxToLong(this.$outer.kafka$log$OffsetIndex$$_lastOffset), BoxesRunTime.boxToInteger(this.$outer.mmap().position())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }
}

