/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kafka.common.KafkaException;
import kafka.common.KafkaStorageException;
import kafka.log.CleanerConfig;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogConfig;
import kafka.log.LogManager$;
import kafka.log.LogManager$$anonfun$loadLogs$2$;
import kafka.log.LogManager$$anonfun$loadLogs$2$$anonfun$3$;
import kafka.log.LogManager$$anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$10$;
import kafka.log.LogSegment;
import kafka.server.BrokerState;
import kafka.server.OffsetCheckpoint;
import kafka.server.RecoveringFromUncleanShutdown$;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$Int$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u001b\u0006t\u0017mZ3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001B\u0004\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001eD\u0001\"\u0006\u0001\u0003\u0006\u0004%\tAF\u0001\bY><G)\u001b:t+\u00059\u0002cA\u0005\u00195%\u0011\u0011D\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003\u0018\u0003!awn\u001a#jeN\u0004\u0003\u0002C\u0013\u0001\u0005\u000b\u0007I\u0011\u0001\u0014\u0002\u0019Q|\u0007/[2D_:4\u0017nZ:\u0016\u0003\u001d\u0002B\u0001K\u0016.i5\t\u0011F\u0003\u0002+\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051J#aA'baB\u0011a&\r\b\u0003\u0013=J!\u0001\r\u0006\u0002\rA\u0013X\rZ3g\u0013\t\u00114G\u0001\u0004TiJLgn\u001a\u0006\u0003a)\u0001\"!\u000e\u001c\u000e\u0003\tI!a\u000e\u0002\u0003\u00131{wmQ8oM&<\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u001bQ|\u0007/[2D_:4\u0017nZ:!\u0011!Y\u0004A!b\u0001\n\u0003a\u0014!\u00043fM\u0006,H\u000e^\"p]\u001aLw-F\u00015\u0011!q\u0004A!A!\u0002\u0013!\u0014A\u00043fM\u0006,H\u000e^\"p]\u001aLw\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006i1\r\\3b]\u0016\u00148i\u001c8gS\u001e,\u0012A\u0011\t\u0003k\rK!\u0001\u0012\u0002\u0003\u001b\rcW-\u00198fe\u000e{gNZ5h\u0011!1\u0005A!A!\u0002\u0013\u0011\u0015AD2mK\u0006tWM]\"p]\u001aLw\r\t\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\u0006I\u0011n\u001c+ie\u0016\fGm\u001d\t\u0003\u0013)K!a\u0013\u0006\u0003\u0007%sG\u000f\u0003\u0005N\u0001\t\u0015\r\u0011\"\u0001O\u000311G.^:i\u0007\",7m['t+\u0005y\u0005CA\u0005Q\u0013\t\t&B\u0001\u0003M_:<\u0007\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B(\u0002\u001b\u0019dWo\u001d5DQ\u0016\u001c7.T:!\u0011!)\u0006A!b\u0001\n\u0003q\u0015!\u00054mkND7\t[3dWB|\u0017N\u001c;Ng\"Aq\u000b\u0001B\u0001B\u0003%q*\u0001\ngYV\u001c\bn\u00115fG.\u0004x.\u001b8u\u001bN\u0004\u0003\u0002C-\u0001\u0005\u000b\u0007I\u0011\u0001(\u0002!I,G/\u001a8uS>t7\t[3dW6\u001b\b\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011B(\u0002#I,G/\u001a8uS>t7\t[3dW6\u001b\b\u0005\u0003\u0005^\u0001\t\u0005\t\u0015!\u0003_\u0003%\u00198\r[3ek2,'\u000f\u0005\u0002\u0010?&\u0011\u0001\r\u0005\u0002\n'\u000eDW\rZ;mKJD\u0001B\u0019\u0001\u0003\u0006\u0004%\taY\u0001\fEJ|7.\u001a:Ti\u0006$X-F\u0001e!\t)\u0007.D\u0001g\u0015\t9G!\u0001\u0004tKJ4XM]\u0005\u0003S\u001a\u00141B\u0011:pW\u0016\u00148\u000b^1uK\"A1\u000e\u0001B\u0001B\u0003%A-\u0001\u0007ce>\\WM]*uCR,\u0007\u0005\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0003\u0011!\u0018.\\3\u0011\u0005=DX\"\u00019\u000b\u0005E\t(B\u0001:t\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u001e\u0006\u0003kZ\fa!\u00199bG\",'\"A<\u0002\u0007=\u0014x-\u0003\u0002za\n!A+[7f\u0011\u0015Y\b\u0001\"\u0001}\u0003\u0019a\u0014N\\5u}Q)RP`@\u0002\u0002\u0005\r\u0011QAA\u0004\u0003\u0013\tY!!\u0004\u0002\u0010\u0005E\u0001CA\u001b\u0001\u0011\u0015)\"\u00101\u0001\u0018\u0011\u0015)#\u00101\u0001(\u0011\u0015Y$\u00101\u00015\u0011\u0015\u0001%\u00101\u0001C\u0011\u0015A%\u00101\u0001J\u0011\u0015i%\u00101\u0001P\u0011\u0015)&\u00101\u0001P\u0011\u0015I&\u00101\u0001P\u0011\u0015i&\u00101\u0001_\u0011\u0015\u0011'\u00101\u0001e\u0011\u0015i'\u00101\u0001o\u0011%\t)\u0002\u0001b\u0001\n\u0003\t9\"A\u000eSK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oi\u001aKG.Z\u000b\u0003\u00033\u0001B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?q\u0012\u0001\u00027b]\u001eL1AMA\u000f\u0011!\t)\u0003\u0001Q\u0001\n\u0005e\u0011\u0001\b*fG>4XM]=Q_&tGo\u00115fG.\u0004x.\u001b8u\r&dW\r\t\u0005\n\u0003S\u0001!\u0019!C\u0001\u0003/\t\u0001\u0002T8dW\u001aKG.\u001a\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u001a\u0005IAj\\2l\r&dW\r\t\u0005\n\u0003c\u0001!\u0019!C\u0001\u0003g\t!#\u00138ji&\fG\u000eV1tW\u0012+G.Y=NgV\t\u0011\nC\u0004\u00028\u0001\u0001\u000b\u0011B%\u0002'%s\u0017\u000e^5bYR\u000b7o\u001b#fY\u0006LXj\u001d\u0011\t\u0013\u0005m\u0002A1A\u0005\n\u0005u\u0012!\u00077pO\u000e\u0013X-\u0019;j_:|%\u000fR3mKRLwN\u001c'pG.,\"!a\u0010\u0011\t\u0005m\u0011\u0011I\u0005\u0005\u0003\u0007\niB\u0001\u0004PE*,7\r\u001e\u0005\t\u0003\u000f\u0002\u0001\u0015!\u0003\u0002@\u0005QBn\\4De\u0016\fG/[8o\u001fJ$U\r\\3uS>tGj\\2lA!I\u00111\n\u0001C\u0002\u0013%\u0011QJ\u0001\u0005Y><7/\u0006\u0002\u0002PA9q\"!\u0015\u0002V\u0005u\u0013bAA*!\t!\u0001k\\8m!\u0011\t9&!\u0017\u000e\u0003EL1!a\u0017r\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042!NA0\u0013\r\t\tG\u0001\u0002\u0004\u0019><\u0007\u0002CA3\u0001\u0001\u0006I!a\u0014\u0002\u000b1|wm\u001d\u0011\t\u0013\u0005%\u0004A1A\u0005\n\u0005-\u0014a\u00047pON$vNQ3EK2,G/\u001a3\u0016\u0005\u00055\u0004CBA8\u0003s\ni&\u0004\u0002\u0002r)!\u00111OA;\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003or\u0012\u0001B;uS2LA!a\u001f\u0002r\t\u0019B*\u001b8lK\u0012\u0014En\\2lS:<\u0017+^3vK\"A\u0011q\u0010\u0001!\u0002\u0013\ti'\u0001\tm_\u001e\u001cHk\u001c\"f\t\u0016dW\r^3eA!I\u00111\u0011\u0001C\u0002\u0013%\u0011QQ\u0001\tI&\u0014Hj\\2lgV\u0011\u0011q\u0011\t\u0006Q\u0005%\u0015QR\u0005\u0004\u0003\u0017K#aA*fcB\u0019q\"a$\n\u0007\u0005E\u0005C\u0001\u0005GS2,Gj\\2l\u0011!\t)\n\u0001Q\u0001\n\u0005\u001d\u0015!\u00033je2{7m[:!\u0011%\tI\n\u0001b\u0001\n\u0013\tY*\u0001\rsK\u000e|g/\u001a:z!>Lg\u000e^\"iK\u000e\\\u0007o\\5oiN,\"!!(\u0011\u000f\u0005}\u0015Q\u0015\u000e\u0002(6\u0011\u0011\u0011\u0015\u0006\u0004\u0003GK\u0013!C5n[V$\u0018M\u00197f\u0013\ra\u0013\u0011\u0015\t\u0004K\u0006%\u0016bAAVM\n\u0001rJ\u001a4tKR\u001c\u0005.Z2la>Lg\u000e\u001e\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002\u001e\u0006I\"/Z2pm\u0016\u0014\u0018\u0010U8j]R\u001c\u0005.Z2la>Lg\u000e^:!\u0011%\t\u0019\f\u0001b\u0001\n\u0003\t),A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u0005]\u0006cA\u001b\u0002:&\u0019\u00111\u0018\u0002\u0003\u00151{wm\u00117fC:,'\u000f\u0003\u0005\u0002@\u0002\u0001\u000b\u0011BA\\\u0003!\u0019G.Z1oKJ\u0004\u0003bBAb\u0001\u0011%\u0011QY\u0001\u0019GJ,\u0017\r^3B]\u00124\u0016\r\\5eCR,Gj\\4ESJ\u001cH\u0003BAd\u0003\u001b\u00042!CAe\u0013\r\tYM\u0003\u0002\u0005+:LG\u000f\u0003\u0005\u0002P\u0006\u0005\u0007\u0019AAi\u0003\u0011!\u0017N]:\u0011\t!\nII\u0007\u0005\b\u0003+\u0004A\u0011BAl\u0003-awnY6M_\u001e$\u0015N]:\u0015\t\u0005\u001d\u0015\u0011\u001c\u0005\t\u0003\u001f\f\u0019\u000e1\u0001\u0002R\"9\u0011Q\u001c\u0001\u0005\n\u0005}\u0017\u0001\u00037pC\u0012dunZ:\u0015\u0005\u0005\u001d\u0007bBAr\u0001\u0011\u0005\u0011q\\\u0001\bgR\f'\u000f^;q\u0011\u001d\t9\u000f\u0001C\u0001\u0003?\f\u0001b\u001d5vi\u0012|wO\u001c\u0005\b\u0003W\u0004A\u0011AAw\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0005\u0003\u000f\fy\u000f\u0003\u0005\u0002r\u0006%\b\u0019AAz\u0003A\u0001\u0018M\u001d;ji&|gn\u00144gg\u0016$8\u000fE\u0003)W\u0005Us\nC\u0004\u0002x\u0002!\t!!?\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBAd\u0003w\fy\u0010\u0003\u0005\u0002~\u0006U\b\u0019AA+\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:DqA!\u0001\u0002v\u0002\u0007q*A\u0005oK^|eMZ:fi\"9!Q\u0001\u0001\u0005\u0002\u0005}\u0017AH2iK\u000e\\\u0007o\\5oiJ+7m\u001c<fef\u0004v.\u001b8u\u001f\u001a47/\u001a;t\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017\t1c\u00195fG.\u0004x.\u001b8u\u0019><7/\u00138ESJ$B!a2\u0003\u000e!9!q\u0002B\u0004\u0001\u0004Q\u0012a\u00013je\"9!1\u0003\u0001\u0005\u0002\tU\u0011AB4fi2{w\r\u0006\u0003\u0003\u0018\tu\u0001#B\u0005\u0003\u001a\u0005u\u0013b\u0001B\u000e\u0015\t1q\n\u001d;j_:D\u0001\"!@\u0003\u0012\u0001\u0007\u0011Q\u000b\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0003%\u0019'/Z1uK2{w\r\u0006\u0004\u0002^\t\u0015\"q\u0005\u0005\t\u0003{\u0014y\u00021\u0001\u0002V!9!\u0011\u0006B\u0010\u0001\u0004!\u0014AB2p]\u001aLw\rC\u0004\u0003.\u0001!I!a8\u0002\u0015\u0011,G.\u001a;f\u0019><7\u000fC\u0004\u00032\u0001!\tAa\r\u0002\u0017\u0005\u001c\u0018P\\2EK2,G/\u001a\u000b\u0005\u0003\u000f\u0014)\u0004\u0003\u0005\u0002~\n=\u0002\u0019AA+\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\t!B\\3yi2{w\rR5s)\u0005Q\u0002b\u0002B \u0001\u0011\u0005\u0011q\\\u0001\fG2,\u0017M\\;q\u0019><7\u000fC\u0004\u0003D\u0001!\tA!\u0012\u0002\u000f\u0005dG\u000eT8hgR\u0011!q\t\t\u0006Q\t%\u0013QL\u0005\u0004\u0005\u0017J#\u0001C%uKJ\f'\r\\3\t\u000f\t=\u0003\u0001\"\u0001\u0003R\u0005!Bn\\4t\u0005f$v\u000e]5d!\u0006\u0014H/\u001b;j_:,\"Aa\u0015\u0011\r!Z\u0013QKA/\u0011\u001d\u00119\u0006\u0001C\u0005\u00053\n\u0011\u0002\\8hg\nKH)\u001b:\u0016\u0005\tm\u0003\u0003CAP\u0003K\u000bIBa\u0015\t\u000f\t}\u0003\u0001\"\u0003\u0002`\u0006qa\r\\;tQ\u0012K'\u000f^=M_\u001e\u001c\bf\u0001\u0001\u0003dA\u0019qB!\u001a\n\u0007\t\u001d\u0004C\u0001\u0006uQJ,\u0017\rZ:bM\u0016\u0004")
public class LogManager
implements Logging {
    private final File[] logDirs;
    private final Map<String, LogConfig> topicConfigs;
    private final LogConfig defaultConfig;
    private final CleanerConfig cleanerConfig;
    public final int kafka$log$LogManager$$ioThreads;
    private final long flushCheckMs;
    private final long flushCheckpointMs;
    private final long retentionCheckMs;
    public final Scheduler kafka$log$LogManager$$scheduler;
    private final BrokerState brokerState;
    public final Time kafka$log$LogManager$$time;
    private final String RecoveryPointCheckpointFile;
    private final String LockFile;
    private final int InitialTaskDelayMs;
    private final Object logCreationOrDeletionLock;
    private final Pool<TopicPartition, Log> kafka$log$LogManager$$logs;
    private final LinkedBlockingQueue<Log> kafka$log$LogManager$$logsToBeDeleted;
    private final Seq<FileLock> dirLocks;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints;
    private final LogCleaner cleaner;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogManager logManager = this;
        synchronized (logManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Map<String, LogConfig> topicConfigs() {
        return this.topicConfigs;
    }

    public LogConfig defaultConfig() {
        return this.defaultConfig;
    }

    public CleanerConfig cleanerConfig() {
        return this.cleanerConfig;
    }

    public long flushCheckMs() {
        return this.flushCheckMs;
    }

    public long flushCheckpointMs() {
        return this.flushCheckpointMs;
    }

    public long retentionCheckMs() {
        return this.retentionCheckMs;
    }

    public BrokerState brokerState() {
        return this.brokerState;
    }

    public String RecoveryPointCheckpointFile() {
        return this.RecoveryPointCheckpointFile;
    }

    public String LockFile() {
        return this.LockFile;
    }

    public int InitialTaskDelayMs() {
        return this.InitialTaskDelayMs;
    }

    private Object logCreationOrDeletionLock() {
        return this.logCreationOrDeletionLock;
    }

    public Pool<TopicPartition, Log> kafka$log$LogManager$$logs() {
        return this.kafka$log$LogManager$$logs;
    }

    public LinkedBlockingQueue<Log> kafka$log$LogManager$$logsToBeDeleted() {
        return this.kafka$log$LogManager$$logsToBeDeleted;
    }

    private Seq<FileLock> dirLocks() {
        return this.dirLocks;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogManager$$recoveryPointCheckpoints() {
        return this.kafka$log$LogManager$$recoveryPointCheckpoints;
    }

    public LogCleaner cleaner() {
        return this.cleaner;
    }

    private void createAndValidateLogDirs(Seq<File> dirs) {
        if (((TraversableOnce)dirs.map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$1) {
                return x$1.getCanonicalPath();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().size() < dirs.size()) {
            throw new KafkaException(new StringBuilder().append((Object)"Duplicate log directory found: ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).mkString(", ")).toString());
        }
        dirs.foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(File dir) {
                block5: {
                    block4: {
                        if (dir.exists()) break block4;
                        this.$outer.info((Function0<String>)((Object)new Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$2;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Log directory '").append((Object)this.dir$2.getAbsolutePath()).append((Object)"' not found, creating it.").toString();
                            }
                            {
                                this.dir$2 = dir$2;
                            }
                        }));
                        boolean created = dir.mkdirs();
                        if (!created) break block5;
                    }
                    if (dir.isDirectory() && dir.canRead()) {
                        return;
                    }
                    throw new KafkaException(new StringBuilder().append((Object)dir.getAbsolutePath()).append((Object)" is not a readable log directory.").toString());
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to create data directory ").append((Object)dir.getAbsolutePath()).toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private Seq<FileLock> lockLogDirs(Seq<File> dirs) {
        return dirs.map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            /*
             * WARNING - void declaration
             */
            public final FileLock apply(File dir) {
                void var2_2;
                FileLock lock2 = new FileLock(new File(dir, this.$outer.LockFile()));
                if (lock2.tryLock()) {
                    return var2_2;
                }
                throw new KafkaException(new StringBuilder().append((Object)"Failed to acquire lock on file .lock in ").append((Object)var2_2.file().getParentFile().getAbsolutePath()).append((Object)". A Kafka instance in another process or thread is using this directory.").toString());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private void loadLogs() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Loading logs.";
            }
        }));
        long startMs = this.kafka$log$LogManager$$time.milliseconds();
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        GenMap jobs = Map$.MODULE$.empty();
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new Serializable(this, threadPools, (scala.collection.mutable.Map)jobs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final ArrayBuffer threadPools$1;
            private final scala.collection.mutable.Map jobs$1;

            public final void apply(File dir) {
                ExecutorService pool = Executors.newFixedThreadPool(this.$outer.kafka$log$LogManager$$ioThreads);
                this.threadPools$1.append(Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
                File cleanShutdownFile = new File(dir, Log$.MODULE$.CleanShutdownFile());
                if (cleanShutdownFile.exists()) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, dir){
                        public static final long serialVersionUID = 0L;
                        private final File dir$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Found clean shutdown file. Skipping recovery for all logs in data directory: ").append((Object)this.dir$3.getAbsolutePath()).toString();
                        }
                        {
                            this.dir$3 = dir$3;
                        }
                    }));
                } else {
                    this.$outer.brokerState().newState(RecoveringFromUncleanShutdown$.MODULE$);
                }
                ObjectRef<Map> recoveryPoints = ObjectRef.create((Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$));
                try {
                    recoveryPoints.elem = ((OffsetCheckpoint)this.$outer.kafka$log$LogManager$$recoveryPointCheckpoints().apply(dir)).read();
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<String>)((Object)new Serializable(this, dir){
                        public static final long serialVersionUID = 0L;
                        private final File dir$3;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error occured while reading recovery-point-offset-checkpoint file of directory ").append(this.dir$3).toString();
                        }
                        {
                            this.dir$3 = dir$3;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final Exception e$1;

                        public final Exception apply() {
                            return this.e$1;
                        }
                        {
                            this.e$1 = e$1;
                        }
                    }));
                    this.$outer.warn((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Resetting the recovery checkpoint to 0";
                        }
                    }));
                }
                List<?> jobsForDir = Option$.MODULE$.apply(dir.listFiles()).toList().flatMap(new Serializable(this, recoveryPoints){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$loadLogs$2 $outer;
                    public final ObjectRef recoveryPoints$1;

                    public final ArrayOps<Runnable> apply(File[] dirContent) {
                        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])dirContent).withFilter(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(File logDir) {
                                return logDir.isDirectory();
                            }
                        }).map(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$loadLogs$2$$anonfun$3 $outer;

                            public final Runnable apply(File logDir) {
                                return CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)((Object)new Serializable(this, logDir){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$10 $outer;
                                    public final File logDir$1;

                                    public final void apply() {
                                        this.apply$mcV$sp();
                                    }

                                    public void apply$mcV$sp() {
                                        Log previous;
                                        Log current;
                                        block4: {
                                            block3: {
                                                TopicPartition topicPartition;
                                                block2: {
                                                    this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().debug((Function0<String>)((Object)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$10$$anonfun$apply$1 $outer;

                                                        public final String apply() {
                                                            return new StringBuilder().append((Object)"Loading log '").append((Object)this.$outer.logDir$1.getName()).append((Object)"'").toString();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }));
                                                    topicPartition = Log$.MODULE$.parseTopicPartitionName(this.logDir$1);
                                                    LogConfig config = this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().topicConfigs().getOrElse(topicPartition.topic(), new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$10$$anonfun$apply$1 $outer;

                                                        public final LogConfig apply() {
                                                            return this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().defaultConfig();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                    long logRecoveryPoint = BoxesRunTime.unboxToLong(((Map)this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().recoveryPoints$1.elem).getOrElse(topicPartition, new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        public final long apply() {
                                                            return this.apply$mcJ$sp();
                                                        }

                                                        public long apply$mcJ$sp() {
                                                            return 0L;
                                                        }
                                                    }));
                                                    current = new Log(this.logDir$1, config, logRecoveryPoint, this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$scheduler, this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$time);
                                                    if (!this.logDir$1.getName().endsWith(Log$.MODULE$.DeleteDirSuffix())) break block2;
                                                    this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logsToBeDeleted().add(current);
                                                    break block3;
                                                }
                                                previous = this.$outer.kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$anonfun$$$outer().kafka$log$LogManager$$anonfun$$$outer().kafka$log$LogManager$$logs().put(topicPartition, current);
                                                if (previous != null) break block4;
                                            }
                                            return;
                                        }
                                        throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Duplicate log directories found: %s, %s!")).format(Predef$.MODULE$.genericWrapArray(new Object[]{current.dir().getAbsolutePath(), previous.dir().getAbsolutePath()})));
                                    }

                                    public /* synthetic */ $anonfun$loadLogs$2$$anonfun$3$$anonfun$apply$10 kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.logDir$1 = logDir$1;
                                    }
                                }));
                            }

                            public /* synthetic */ $anonfun$loadLogs$2$$anonfun$3 kafka$log$LogManager$$anonfun$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Runnable.class))));
                    }

                    public /* synthetic */ $anonfun$loadLogs$2 kafka$log$LogManager$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.recoveryPoints$1 = recoveryPoints$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                this.jobs$1.update(cleanShutdownFile, ((scala.collection.immutable.Seq)jobsForDir.map(new Serializable(this, pool){
                    public static final long serialVersionUID = 0L;
                    private final ExecutorService pool$1;

                    public final Future<?> apply(Runnable x$1) {
                        return this.pool$1.submit(x$1);
                    }
                    {
                        this.pool$1 = pool$1;
                    }
                }, List$.MODULE$.canBuildFrom())).toSeq());
            }

            public /* synthetic */ LogManager kafka$log$LogManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadPools$1 = threadPools$1;
                this.jobs$1 = jobs$1;
            }
        });
        try {
            jobs.withFilter(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<File, Seq<Future<?>>> check$ifrefutable$1) {
                    Tuple2<File, Seq<Future<?>>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<File, Seq<Future<?>>> x$3) {
                    Tuple2<File, Seq<Future<?>>> tuple2 = x$3;
                    if (tuple2 != null) {
                        File cleanShutdownFile = tuple2._1();
                        Seq<Future<?>> dirJobs = tuple2._2();
                        dirJobs.foreach(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Future<?> x$2) {
                                return x$2.get();
                            }
                        });
                        boolean bl = cleanShutdownFile.delete();
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            });
            threadPools.foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ExecutorService x$4) {
                    x$4.shutdown();
                }
            });
            this.info((Function0<String>)((Object)new Serializable(this, startMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;
                private final long startMs$1;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Logs loading complete in ", " ms."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.kafka$log$LogManager$$time.milliseconds() - this.startMs$1)}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.startMs$1 = startMs$1;
                }
            }));
            return;
        }
        catch (ExecutionException executionException) {
            try {
                this.error((Function0<String>)((Object)new Serializable(this, executionException){
                    public static final long serialVersionUID = 0L;
                    private final ExecutionException e$2;

                    public final String apply() {
                        return new StringBuilder().append((Object)"There was an error in one of the threads during logs loading: ").append(this.e$2.getCause()).toString();
                    }
                    {
                        this.e$2 = e$2;
                    }
                }));
                throw executionException.getCause();
            }
            catch (Throwable throwable) {
                void var3_2;
                var3_2.foreach(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
        }
    }

    public void startup() {
        if (this.kafka$log$LogManager$$scheduler != null) {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Starting log cleanup with a period of %d ms.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.retentionCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-retention", (Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleanupLogs();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.retentionCheckMs(), TimeUnit.MILLISECONDS);
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Starting log flusher with a default period of %d ms.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.$outer.flushCheckMs())}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
            this.kafka$log$LogManager$$scheduler.schedule("kafka-log-flusher", (Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$flushDirtyLogs();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.flushCheckMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-recovery-point-checkpoint", (Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkpointRecoveryPointOffsets();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), this.flushCheckpointMs(), TimeUnit.MILLISECONDS);
            this.kafka$log$LogManager$$scheduler.schedule("kafka-delete-logs", (Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.kafka$log$LogManager$$deleteLogs();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }), this.InitialTaskDelayMs(), Predef$.MODULE$.Long2long(this.defaultConfig().fileDeleteDelayMs()), TimeUnit.MILLISECONDS);
        }
        if (this.cleanerConfig().enableCleaner()) {
            this.cleaner().startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down.";
            }
        }));
        ArrayBuffer threadPools = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        GenMap jobs = Map$.MODULE$.empty();
        if (this.cleaner() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.cleaner().shutdown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }));
        }
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new Serializable(this, threadPools, (scala.collection.mutable.Map)jobs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final ArrayBuffer threadPools$2;
            private final scala.collection.mutable.Map jobs$2;

            public final void apply(File dir) {
                this.$outer.debug((Function0<String>)((Object)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final File dir$4;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Flushing and closing logs at ").append(this.dir$4).toString();
                    }
                    {
                        this.dir$4 = dir$4;
                    }
                }));
                ExecutorService pool = Executors.newFixedThreadPool(this.$outer.kafka$log$LogManager$$ioThreads);
                this.threadPools$2.append(Predef$.MODULE$.wrapRefArray((Object[])new ExecutorService[]{pool}));
                Iterable<Runnable> logsInDir = ((MapLike)this.$outer.kafka$log$LogManager$$logsByDir().getOrElse(dir.toString(), new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Map<TopicPartition, Nothing$> apply() {
                        return (Map)scala.collection.Map$.MODULE$.apply(Nil$.MODULE$);
                    }
                })).values();
                Iterable<A> jobsForDir = logsInDir.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Runnable apply(Log log2) {
                        return CoreUtils$.MODULE$.runnable((Function0<BoxedUnit>)((Object)new Serializable(this, log2){
                            public static final long serialVersionUID = 0L;
                            private final Log log$2;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                this.log$2.flush();
                                this.log$2.close();
                            }
                            {
                                this.log$2 = log$2;
                            }
                        }));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                this.jobs$2.update(dir, ((TraversableOnce)jobsForDir.map(new Serializable(this, pool){
                    public static final long serialVersionUID = 0L;
                    private final ExecutorService pool$2;

                    public final Future<?> apply(Runnable x$1) {
                        return this.pool$2.submit(x$1);
                    }
                    {
                        this.pool$2 = pool$2;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.threadPools$2 = threadPools$2;
                this.jobs$2 = jobs$2;
            }
        });
        try {
            jobs.withFilter(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<File, Seq<Future<?>>> check$ifrefutable$2) {
                    Tuple2<File, Seq<Future<?>>> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;

                public final void apply(Tuple2<File, Seq<Future<?>>> x$6) {
                    Tuple2<File, Seq<Future<?>>> tuple2 = x$6;
                    if (tuple2 != null) {
                        File dir = tuple2._1();
                        Seq<Future<?>> dirJobs = tuple2._2();
                        dirJobs.foreach(new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Object apply(Future<?> x$5) {
                                return x$5.get();
                            }
                        });
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Updating recovery points at ").append(this.dir$1).toString();
                            }
                            {
                                this.dir$1 = dir$1;
                            }
                        }));
                        this.$outer.kafka$log$LogManager$$checkpointLogsInDir(dir);
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)"Writing clean shutdown marker at ").append(this.dir$1).toString();
                            }
                            {
                                this.dir$1 = dir$1;
                            }
                        }));
                        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, dir){
                            public static final long serialVersionUID = 0L;
                            private final File dir$1;

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                new File(this.dir$1, Log$.MODULE$.CleanShutdownFile()).createNewFile();
                            }
                            {
                                this.dir$1 = dir$1;
                            }
                        }));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            threadPools.foreach(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ExecutorService x$7) {
                    x$7.shutdown();
                }
            });
        }
        catch (ExecutionException executionException) {
            try {
                this.error((Function0<String>)((Object)new Serializable(this, executionException){
                    public static final long serialVersionUID = 0L;
                    private final ExecutionException e$4;

                    public final String apply() {
                        return new StringBuilder().append((Object)"There was an error in one of the threads during LogManager shutdown: ").append(this.e$4.getCause()).toString();
                    }
                    {
                        this.e$4 = e$4;
                    }
                }));
                throw executionException.getCause();
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.foreach(new /* invalid duplicate definition of identical inner class */);
                this.dirLocks().foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLock x$8) {
                        x$8.destroy();
                    }
                });
                throw throwable;
            }
        }
        this.dirLocks().foreach(new /* invalid duplicate definition of identical inner class */);
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutdown complete.";
            }
        }));
        return;
    }

    public void truncateTo(Map<TopicPartition, Object> partitionOffsets) {
        partitionOffsets.withFilter((Function1<TopicPartition, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Object> check$ifrefutable$3) {
                Tuple2<TopicPartition, Object> tuple2 = check$ifrefutable$3;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(Tuple2<TopicPartition, Object> x$9) {
                Tuple2<TopicPartition, Object> tuple2 = x$9;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition topicPartition = tuple2._1();
                    long truncateOffset = tuple2._2$mcJ$sp();
                    Log log2 = this.$outer.kafka$log$LogManager$$logs().get(topicPartition);
                    if (log2 == null) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boolean needToStopCleaner;
                        boolean bl = needToStopCleaner = truncateOffset < log2.activeSegment().baseOffset();
                        if (needToStopCleaner && this.$outer.cleaner() != null) {
                            this.$outer.cleaner().abortAndPauseCleaning(topicPartition);
                        }
                        log2.truncateTo(truncateOffset);
                        if (needToStopCleaner && this.$outer.cleaner() != null) {
                            this.$outer.cleaner().maybeTruncateCheckpoint(log2.dir().getParentFile(), topicPartition, log2.activeSegment().baseOffset());
                            this.$outer.cleaner().resumeCleaning(topicPartition);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.checkpointRecoveryPointOffsets();
    }

    public void truncateFullyAndStartAt(TopicPartition topicPartition, long newOffset) {
        Log log2 = this.kafka$log$LogManager$$logs().get(topicPartition);
        if (log2 != null) {
            if (this.cleaner() != null) {
                this.cleaner().abortAndPauseCleaning(topicPartition);
            }
            log2.truncateFullyAndStartAt(newOffset);
            if (this.cleaner() != null) {
                this.cleaner().maybeTruncateCheckpoint(log2.dir().getParentFile(), topicPartition, log2.activeSegment().baseOffset());
                this.cleaner().resumeCleaning(topicPartition);
            }
        }
        this.checkpointRecoveryPointOffsets();
    }

    public void checkpointRecoveryPointOffsets() {
        Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final void apply(File dir) {
                this.$outer.kafka$log$LogManager$$checkpointLogsInDir(dir);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$log$LogManager$$checkpointLogsInDir(File dir) {
        Option recoveryPoints = this.kafka$log$LogManager$$logsByDir().get(dir.toString());
        if (recoveryPoints.isDefined()) {
            ((OffsetCheckpoint)this.kafka$log$LogManager$$recoveryPointCheckpoints().apply(dir)).write(((MapLike)recoveryPoints.get()).mapValues(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(Log x$10) {
                    return x$10.recoveryPoint();
                }
            }));
        }
    }

    public Option<Log> getLog(TopicPartition topicPartition) {
        return Option$.MODULE$.apply(this.kafka$log$LogManager$$logs().get(topicPartition));
    }

    public Log createLog(TopicPartition topicPartition, LogConfig config) {
        Object object = this.logCreationOrDeletionLock();
        synchronized (object) {
            Log log2 = this.getLog(topicPartition).getOrElse(new Serializable(this, topicPartition, config){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LogManager $outer;
                public final TopicPartition topicPartition$1;
                public final LogConfig config$1;

                /*
                 * WARNING - void declaration
                 */
                public final Log apply() {
                    void var3_3;
                    File dataDir = this.$outer.kafka$log$LogManager$$nextLogDir();
                    File dir = new File(dataDir, new StringBuilder().append((Object)this.topicPartition$1.topic()).append((Object)"-").append(BoxesRunTime.boxToInteger(this.topicPartition$1.partition())).toString());
                    dir.mkdirs();
                    Log log2 = new Log(dir, this.config$1, 0L, this.$outer.kafka$log$LogManager$$scheduler, this.$outer.kafka$log$LogManager$$time);
                    this.$outer.kafka$log$LogManager$$logs().put(this.topicPartition$1, log2);
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, dataDir){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$createLog$1 $outer;
                        private final File dataDir$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Created log for partition [%s,%d] in %s with properties {%s}.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.topicPartition$1.topic(), BoxesRunTime.boxToInteger(this.$outer.topicPartition$1.partition()), this.dataDir$1.getAbsolutePath(), ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.$outer.config$1.originals()).asScala()).mkString(", ")}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.dataDir$1 = dataDir$1;
                        }
                    }));
                    return var3_3;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.topicPartition$1 = topicPartition$1;
                    this.config$1 = config$1;
                }
            });
            return log2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void kafka$log$LogManager$$deleteLogs() {
        try {
            int failed2 = 0;
            while (!this.kafka$log$LogManager$$logsToBeDeleted().isEmpty() && failed2 < this.kafka$log$LogManager$$logsToBeDeleted().size()) {
                Log removedLog = this.kafka$log$LogManager$$logsToBeDeleted().take();
                if (removedLog == null) continue;
                try {
                    removedLog.delete();
                    this.info((Function0<String>)((Object)new Serializable(this, removedLog){
                        public static final long serialVersionUID = 0L;
                        private final Log removedLog$2;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted log for partition ", " in ", "."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.removedLog$2.topicPartition(), this.removedLog$2.dir().getAbsolutePath()}));
                        }
                        {
                            this.removedLog$2 = removedLog$2;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    void var3_2;
                    this.error((Function0<String>)((Object)new Serializable(this, (Log)var3_2){
                        public static final long serialVersionUID = 0L;
                        private final Log removedLog$2;

                        public final String apply() {
                            return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception in deleting ", ". Moving it to the end of the queue."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.removedLog$2}));
                        }
                        {
                            this.removedLog$2 = removedLog$2;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$5;

                        public final Throwable apply() {
                            return this.e$5;
                        }
                        {
                            this.e$5 = e$5;
                        }
                    }));
                    ++failed2;
                    this.kafka$log$LogManager$$logsToBeDeleted().put((Log)var3_2);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception in kafka-delete-logs thread."})).s(Nil$.MODULE$);
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable e$6;

                public final Throwable apply() {
                    return this.e$6;
                }
                {
                    this.e$6 = e$6;
                }
            }));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void asyncDelete(TopicPartition topicPartition) {
        File renamedDir;
        Log removedLog;
        block5: {
            block4: {
                Object object = this.logCreationOrDeletionLock();
                synchronized (object) {
                    Log log2 = this.kafka$log$LogManager$$logs().remove(topicPartition);
                    // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : object
                    removedLog = log2;
                    if (removedLog == null) break block4;
                    if (this.cleaner() != null) {
                        this.cleaner().abortCleaning(topicPartition);
                        this.cleaner().updateCheckpoints(removedLog.dir().getParentFile());
                    }
                    String dirName = new StringBuilder(removedLog.name()).append(".").append(UUID.randomUUID().toString().replaceAll("-", "")).append(Log$.MODULE$.DeleteDirSuffix()).toString();
                    removedLog.close();
                    renamedDir = new File(removedLog.dir().getParent(), dirName);
                    boolean renameSuccessful = removedLog.dir().renameTo(renamedDir);
                    if (!renameSuccessful) break block5;
                    removedLog.dir_$eq(renamedDir);
                }
                removedLog.logSegments().foreach(new Serializable(this, renamedDir){
                    public static final long serialVersionUID = 0L;
                    private final File renamedDir$1;

                    public final void apply(LogSegment logSegment) {
                        logSegment.log().setFile(new File(this.renamedDir$1, logSegment.log().file().getName()));
                        logSegment.index().file_$eq(new File(this.renamedDir$1, logSegment.index().file().getName()));
                    }
                    {
                        this.renamedDir$1 = renamedDir$1;
                    }
                });
                this.kafka$log$LogManager$$logsToBeDeleted().add(removedLog);
                removedLog.removeLogMetrics();
                this.info((Function0<String>)((Object)new Serializable(this, removedLog){
                    public static final long serialVersionUID = 0L;
                    private final Log removedLog$1;

                    public final String apply() {
                        return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Log for partition ", " is renamed to ", " and is scheduled for deletion"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.removedLog$1.topicPartition(), this.removedLog$1.dir().getAbsolutePath()}));
                    }
                    {
                        this.removedLog$1 = removedLog$1;
                    }
                }));
            }
            return;
        }
        throw new KafkaStorageException(new StringBuilder().append((Object)"Failed to rename log directory from ").append((Object)removedLog.dir().getAbsolutePath()).append((Object)" to ").append((Object)renamedDir.getAbsolutePath()).toString());
    }

    public File kafka$log$LogManager$$nextLogDir() {
        File file;
        if (Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).size() == 1) {
            file = this.logDirs()[0];
        } else {
            scala.collection.immutable.Map logCounts = this.allLogs().groupBy(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(Log x$11) {
                    return x$11.dir().getParent();
                }
            }).mapValues(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Iterable<Log> x$12) {
                    return x$12.size();
                }
            });
            scala.collection.immutable.Map zeros = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.logDirs()).map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Object> apply(File dir) {
                    return new Tuple2<String, Object>(dir.getPath(), BoxesRunTime.boxToInteger(0));
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
            Buffer<Object> dirCounts = zeros.$plus$plus(logCounts).toBuffer();
            Tuple2 leastLoaded = (Tuple2)((IterableLike)dirCounts.sortBy(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String, Object> x$13) {
                    return x$13._2$mcI$sp();
                }
            }, Ordering$Int$.MODULE$)).head();
            file = new File((String)leastLoaded._1());
        }
        return file;
    }

    public void cleanupLogs() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Beginning log cleanup...";
            }
        }));
        IntRef total = IntRef.create(0);
        long startMs = this.kafka$log$LogManager$$time.milliseconds();
        this.allLogs().withFilter((Function1<Log, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Log log2) {
                return !log2.config().compact();
            }
        })).foreach(new Serializable(this, total){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;

            public final void apply(Log log2) {
                this.$outer.debug((Function0<String>)((Object)new Serializable(this, log2){
                    public static final long serialVersionUID = 0L;
                    private final Log log$3;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Garbage collecting '").append((Object)this.log$3.name()).append((Object)"'").toString();
                    }
                    {
                        this.log$3 = log$3;
                    }
                }));
                this.total$1.elem += log2.deleteOldSegments();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.total$1 = total$1;
            }
        });
        this.debug((Function0<String>)((Object)new Serializable(this, total, startMs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;
            private final IntRef total$1;
            private final long startMs$2;

            public final String apply() {
                return new StringBuilder().append((Object)"Log cleanup completed. ").append(BoxesRunTime.boxToInteger(this.total$1.elem)).append((Object)" files deleted in ").append(BoxesRunTime.boxToLong((this.$outer.kafka$log$LogManager$$time.milliseconds() - this.startMs$2) / 1000L)).append((Object)" seconds").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.total$1 = total$1;
                this.startMs$2 = startMs$2;
            }
        }));
    }

    public Iterable<Log> allLogs() {
        return this.kafka$log$LogManager$$logs().values();
    }

    public Map<TopicPartition, Log> logsByTopicPartition() {
        return this.kafka$log$LogManager$$logs().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Map<TopicPartition, Log>> kafka$log$LogManager$$logsByDir() {
        return this.logsByTopicPartition().groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicPartition, Log> x0$1) {
                Tuple2<TopicPartition, Log> tuple2 = x0$1;
                if (tuple2 != null) {
                    Log log2 = tuple2._2();
                    String string2 = log2.dir().getParent();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        });
    }

    public void kafka$log$LogManager$$flushDirtyLogs() {
        this.debug((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Checking for dirty logs to flush...";
            }
        }));
        this.kafka$log$LogManager$$logs().withFilter((Function1<Tuple2<TopicPartition, Log>, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Log> check$ifrefutable$4) {
                Tuple2<TopicPartition, Log> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void apply(Tuple2<TopicPartition, Log> x$14) {
                BoxedUnit boxedUnit;
                Tuple2<TopicPartition, Log> tuple2 = x$14;
                if (tuple2 == null) throw new MatchError(tuple2);
                TopicPartition topicPartition = tuple2._1();
                Log log2 = tuple2._2();
                try {
                    long timeSinceLastFlush = this.$outer.kafka$log$LogManager$$time.milliseconds() - log2.lastFlushTime();
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, topicPartition, log2, timeSinceLastFlush){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$2;
                        private final Log log$1;
                        private final long timeSinceLastFlush$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Checking if flush is needed on ").append((Object)this.topicPartition$2.topic()).append((Object)" flush interval  ").append(this.log$1.config().flushMs()).append((Object)" last flushed ").append(BoxesRunTime.boxToLong(this.log$1.lastFlushTime())).append((Object)" time since last flush: ").append(BoxesRunTime.boxToLong(this.timeSinceLastFlush$1)).toString();
                        }
                        {
                            this.topicPartition$2 = topicPartition$2;
                            this.log$1 = log$1;
                            this.timeSinceLastFlush$1 = timeSinceLastFlush$1;
                        }
                    }));
                    if (timeSinceLastFlush >= Predef$.MODULE$.Long2long(log2.config().flushMs())) {
                        log2.flush();
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
                catch (Throwable throwable) {
                    this.$outer.error((Function0<String>)((Object)new Serializable(this, topicPartition){
                        public static final long serialVersionUID = 0L;
                        private final TopicPartition topicPartition$2;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Error flushing topic ").append((Object)this.topicPartition$2.topic()).toString();
                        }
                        {
                            this.topicPartition$2 = topicPartition$2;
                        }
                    }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable e$3;

                        public final Throwable apply() {
                            return this.e$3;
                        }
                        {
                            this.e$3 = e$3;
                        }
                    }));
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public LogManager(File[] logDirs, Map<String, LogConfig> topicConfigs, LogConfig defaultConfig, CleanerConfig cleanerConfig, int ioThreads, long flushCheckMs, long flushCheckpointMs, long retentionCheckMs, Scheduler scheduler, BrokerState brokerState, Time time) {
        this.logDirs = logDirs;
        this.topicConfigs = topicConfigs;
        this.defaultConfig = defaultConfig;
        this.cleanerConfig = cleanerConfig;
        this.kafka$log$LogManager$$ioThreads = ioThreads;
        this.flushCheckMs = flushCheckMs;
        this.flushCheckpointMs = flushCheckpointMs;
        this.retentionCheckMs = retentionCheckMs;
        this.kafka$log$LogManager$$scheduler = scheduler;
        this.brokerState = brokerState;
        this.kafka$log$LogManager$$time = time;
        Logging$class.$init$(this);
        this.RecoveryPointCheckpointFile = "recovery-point-offset-checkpoint";
        this.LockFile = ".lock";
        this.InitialTaskDelayMs = 30000;
        this.logCreationOrDeletionLock = new Object();
        this.kafka$log$LogManager$$logs = new Pool(Pool$.MODULE$.$lessinit$greater$default$1());
        this.kafka$log$LogManager$$logsToBeDeleted = new LinkedBlockingQueue();
        this.createAndValidateLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.dirLocks = this.lockLogDirs(Predef$.MODULE$.wrapRefArray((Object[])logDirs));
        this.kafka$log$LogManager$$recoveryPointCheckpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogManager $outer;

            public final Tuple2<File, OffsetCheckpoint> apply(File dir) {
                return new Tuple2<File, OffsetCheckpoint>(dir, new OffsetCheckpoint(new File(dir, this.$outer.RecoveryPointCheckpointFile())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.loadLogs();
        this.cleaner = cleanerConfig.enableCleaner() ? new LogCleaner(cleanerConfig, logDirs, this.kafka$log$LogManager$$logs(), time) : null;
    }
}

