/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple2$mcJJ$sp;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t-c!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]AZ\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ$G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005qjT\"\u0001\u0002\n\u0005y\u0012!a\u0001'pO\"A\u0001\t\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005C\u0001\u001f\u0001\u0011\u0015Q\u0012\t1\u0001\u001e\u0011\u0015Y\u0013\t1\u0001.\u0011\u001dA\u0005A1A\u0005B%\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005Q\u0005CA&O\u001b\u0005a%BA'%\u0003\u0011a\u0017M\\4\n\u0005=c%AB*ue&tw\r\u0003\u0004R\u0001\u0001\u0006IAS\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005T\u0001\t\u0007I\u0011\u0001\u0002J\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1Q\u000b\u0001Q\u0001\n)\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004X\u0001\t\u0007I\u0011\u0002-\u0002\u0017\rDWmY6q_&tGo]\u000b\u00023B!!l\u0018\u0011b\u001b\u0005Y&B\u0001/^\u0003%IW.\\;uC\ndWM\u0003\u0002_\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&aA'baB\u0011!-Z\u0007\u0002G*\u0011A\rB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u0019\u001c'\u0001E(gMN,Go\u00115fG.\u0004x.\u001b8u\u0011\u0019A\u0007\u0001)A\u00053\u0006a1\r[3dWB|\u0017N\u001c;tA!9!\u000e\u0001b\u0001\n\u0013Y\u0017AC5o!J|wM]3tgV\tA\u000e\u0005\u0003naB\u0012X\"\u00018\u000b\u0005=l\u0016aB7vi\u0006\u0014G.Z\u0005\u0003c:\u0014q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002=g&\u0011AO\u0001\u0002\u0011\u0019><7\t\\3b]&twm\u0015;bi\u0016DaA\u001e\u0001!\u0002\u0013a\u0017aC5o!J|wM]3tg\u0002Bq\u0001\u001f\u0001C\u0002\u0013%\u00110\u0001\u0003m_\u000e\\W#\u0001>\u0011\u0007m\f)!D\u0001}\u0015\tih0A\u0003m_\u000e\\7OC\u0002\u0000\u0003\u0003\t!bY8oGV\u0014(/\u001a8u\u0015\r\t\u0019\u0001J\u0001\u0005kRLG.C\u0002\u0002\bq\u0014QBU3f]R\u0014\u0018M\u001c;M_\u000e\\\u0007bBA\u0006\u0001\u0001\u0006IA_\u0001\u0006Y>\u001c7\u000e\t\u0005\n\u0003\u001f\u0001!\u0019!C\u0005\u0003#\t!\u0003]1vg\u0016$7\t\\3b]&twmQ8oIV\u0011\u00111\u0003\t\u0004w\u0006U\u0011bAA\fy\nI1i\u001c8eSRLwN\u001c\u0005\t\u00037\u0001\u0001\u0015!\u0003\u0002\u0014\u0005\u0019\u0002/Y;tK\u0012\u001cE.Z1oS:<7i\u001c8eA!I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011E\u0001\u001aI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw.\u0006\u0002\u0002$A\u0019\u0001\"!\n\n\u0007\u0005\u001d\u0012B\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0003W\u0001\u0001\u0019!C\u0005\u0003[\tQ\u0004Z5si&,7\u000f\u001e'pO\u000ecW-\u00198bE2,'+\u0019;j_~#S-\u001d\u000b\u0005\u0003_\t)\u0004E\u0002\t\u0003cI1!a\r\n\u0005\u0011)f.\u001b;\t\u0015\u0005]\u0012\u0011FA\u0001\u0002\u0004\t\u0019#A\u0002yIEB\u0001\"a\u000f\u0001A\u0003&\u00111E\u0001\u001bI&\u0014H/[3ti2{wm\u00117fC:\f'\r\\3SCRLw\u000e\t\u0015\u0005\u0003s\ty\u0004E\u0002\t\u0003\u0003J1!a\u0011\n\u0005!1x\u000e\\1uS2,\u0007\"CA$\u0001\u0001\u0007I\u0011BA%\u00035!\u0018.\\3PM2\u000b7\u000f\u001e*v]V\u0011\u00111\n\t\u0004\u0011\u00055\u0013bAA(\u0013\t!Aj\u001c8h\u0011%\t\u0019\u0006\u0001a\u0001\n\u0013\t)&A\tuS6,wJ\u001a'bgR\u0014VO\\0%KF$B!a\f\u0002X!Q\u0011qGA)\u0003\u0003\u0005\r!a\u0013\t\u0011\u0005m\u0003\u0001)Q\u0005\u0003\u0017\na\u0002^5nK>3G*Y:u%Vt\u0007\u0005\u000b\u0003\u0002Z\u0005}\u0002bBA1\u0001\u0011\u0005\u00111M\u0001\u0016C2d7\t\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\t\t)\u0007E\u0004\u0002h\u00055\u0004'a\u0013\u000f\u0007!\tI'C\u0002\u0002l%\ta\u0001\u0015:fI\u00164\u0017b\u00011\u0002p)\u0019\u00111N\u0005\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005IrM]1c\r&dG\u000f[5fgR\u001cu.\u001c9bGR,G\rT8h)\u0011\t9(a!\u0011\u000b!\tI(! \n\u0007\u0005m\u0014B\u0001\u0004PaRLwN\u001c\t\u0004y\u0005}\u0014bAAA\u0005\tQAj\\4U_\u000ecW-\u00198\t\u0011\u0005\u0015\u0015\u0011\u000fa\u0001\u0003\u000f\u000bA\u0001^5nKB!\u0011\u0011RAG\u001b\t\tYI\u0003\u0002\u0011e%!\u0011qRAF\u0005\u0011!\u0016.\\3\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006iA-\u001a7fi\u0006\u0014G.\u001a'pON$\"!a&\u0011\r\u0005e\u0015\u0011VAX\u001d\u0011\tY*!*\u000f\t\u0005u\u00151U\u0007\u0003\u0003?S1!!)\u001c\u0003\u0019a$o\\8u}%\t!\"C\u0002\u0002(&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00065&\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005\u001d\u0016\u0002E\u0003\t\u0003c\u00034(C\u0002\u00024&\u0011a\u0001V;qY\u0016\u0014\u0004bBA\\\u0001\u0011\u0005\u0011\u0011X\u0001\u000eC\n|'\u000f^\"mK\u0006t\u0017N\\4\u0015\t\u0005=\u00121\u0018\u0005\b\u0003{\u000b)\f1\u00011\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!1\u0001\t\u0003\t\u0019-A\u000bbE>\u0014H/\u00118e!\u0006,8/Z\"mK\u0006t\u0017N\\4\u0015\t\u0005=\u0012Q\u0019\u0005\b\u0003{\u000by\f1\u00011\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017\faB]3tk6,7\t\\3b]&tw\r\u0006\u0003\u00020\u00055\u0007bBA_\u0003\u000f\u0004\r\u0001\r\u0005\b\u0003#\u0004A\u0011BAj\u0003EI7o\u00117fC:LgnZ%o'R\fG/\u001a\u000b\u0007\u0003+\fY.!8\u0011\u0007!\t9.C\u0002\u0002Z&\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002>\u0006=\u0007\u0019\u0001\u0019\t\u000f\u0005}\u0017q\u001aa\u0001e\u0006iQ\r\u001f9fGR,Gm\u0015;bi\u0016Dq!a9\u0001\t\u0003\t)/\u0001\u000bdQ\u0016\u001c7n\u00117fC:LgnZ!c_J$X\r\u001a\u000b\u0005\u0003_\t9\u000fC\u0004\u0002>\u0006\u0005\b\u0019\u0001\u0019\t\u000f\u0005-\b\u0001\"\u0001\u0002n\u0006\tR\u000f\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:\u0015\r\u0005=\u0012q^Az\u0011\u001d\t\t0!;A\u0002\u0001\nq\u0001Z1uC\u0012K'\u000f\u0003\u0005\u0002v\u0006%\b\u0019AA|\u0003\u0019)\b\u000fZ1uKB)\u0001\"!\u001f\u0002zB1\u0001\"!-1\u0003\u0017Bq!!@\u0001\t\u0003\ty0A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011q\u0006B\u0001\u0005\u0007\u0011)\u0001C\u0004\u0002r\u0006m\b\u0019\u0001\u0011\t\u000f\u0005u\u00161 a\u0001a!A!qAA~\u0001\u0004\tY%\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u00031!wN\\3DY\u0016\fg.\u001b8h)!\tyCa\u0004\u0003\u0012\tM\u0001bBA_\u0005\u0013\u0001\r\u0001\r\u0005\b\u0003c\u0014I\u00011\u0001!\u0011!\u0011)B!\u0003A\u0002\u0005-\u0013!C3oI>3gm]3u\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057\tA\u0002Z8oK\u0012+G.\u001a;j]\u001e$B!a\f\u0003\u001e!9\u0011Q\u0018B\f\u0001\u0004\u0001t\u0001\u0003B\u0011\u0005!\u0005!Aa\t\u0002#1{wm\u00117fC:,'/T1oC\u001e,'\u000fE\u0002=\u0005K1q!\u0001\u0002\t\u0002\t\u00119c\u0005\u0003\u0003&\u001di\u0001b\u0002\"\u0003&\u0011\u0005!1\u0006\u000b\u0003\u0005GA\u0001Ba\f\u0003&\u0011\u0005!\u0011G\u0001\u0013SN\u001cu.\u001c9bGR\fe\u000e\u001a#fY\u0016$X\r\u0006\u0003\u0002V\nM\u0002BB\u0002\u0003.\u0001\u00071\b\u0003\u0005\u00038\t\u0015B\u0011\u0001B\u001d\u0003A\u0019G.Z1oC\ndWm\u00144gg\u0016$8\u000f\u0006\u0006\u0003<\tu\"q\bB!\u0005\u000f\u0002r\u0001CAY\u0003\u0017\nY\u0005\u0003\u0004\u0004\u0005k\u0001\ra\u000f\u0005\b\u0003{\u0013)\u00041\u00011\u0011!\u0011\u0019E!\u000eA\u0002\t\u0015\u0013!\u00037bgR\u001cE.Z1o!\u0015Qv\fMA&\u0011!\u0011IE!\u000eA\u0002\u0005-\u0013a\u00018po\u0002")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress;
    private final ReentrantLock lock;
    private final Condition kafka$log$LogCleanerManager$$pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log2, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map2, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, map2, l);
    }

    public static boolean isCompactAndDelete(Log log2) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log2);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    public scala.collection.immutable.Map<File, OffsetCheckpoint> kafka$log$LogCleanerManager$$checkpoints() {
        return this.kafka$log$LogCleanerManager$$checkpoints;
    }

    public HashMap<TopicPartition, LogCleaningState> kafka$log$LogCleanerManager$$inProgress() {
        return this.kafka$log$LogCleanerManager$$inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    public Condition kafka$log$LogCleanerManager$$pausedCleaningCond() {
        return this.kafka$log$LogCleanerManager$$pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    public void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    public void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.kafka$log$LogCleanerManager$$checkpoints().values().flatMap(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<TopicPartition, Object> apply(OffsetCheckpoint x$1) {
                return x$1.read();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, time){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final Time time$1;

            public final Option<LogToClean> apply() {
                Option option;
                long now = this.time$1.milliseconds();
                this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
                scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.$outer.allCleanerCheckpoints();
                Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.$outer.logs().filter((Function1)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$1) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Log log2 = tuple2._2();
                            boolean bl = log2.config().compact();
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                }))).filterNot(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$grabFilthiestCompactedLog$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$2) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$2;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            boolean bl = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains(topicPartition);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                })).map(new scala.Serializable(this, now, lastClean){
                    public static final long serialVersionUID = 0L;
                    private final long now$1;
                    private final scala.collection.immutable.Map lastClean$1;

                    public final LogToClean apply(Tuple2<TopicPartition, Log> x0$3) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$3;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            Log log2 = tuple2._2();
                            Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log2, topicPartition, this.lastClean$1, this.now$1);
                            if (tuple22 != null) {
                                Tuple2$mcJJ$sp tuple2$mcJJ$sp;
                                long firstDirtyOffset = tuple22._1$mcJ$sp();
                                long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                                Tuple2$mcJJ$sp tuple2$mcJJ$sp2 = tuple2$mcJJ$sp = new Tuple2$mcJJ$sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                                long firstDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp2)._1$mcJ$sp();
                                long firstUncleanableDirtyOffset2 = ((Tuple2)tuple2$mcJJ$sp2)._2$mcJ$sp();
                                LogToClean logToClean = new LogToClean(topicPartition, log2, firstDirtyOffset2, firstUncleanableDirtyOffset2);
                                return logToClean;
                            }
                            throw new MatchError(tuple22);
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.now$1 = now$1;
                        this.lastClean$1 = lastClean$1;
                    }
                }, Iterable$.MODULE$.canBuildFrom())).filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.totalBytes() > 0L;
                    }
                });
                this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
                Iterable cleanableLogs = (Iterable)dirtyLogs.filter(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(LogToClean ltc) {
                        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
                    }
                });
                if (cleanableLogs.isEmpty()) {
                    option = None$.MODULE$;
                } else {
                    LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                    this.$outer.kafka$log$LogCleanerManager$$inProgress().put(filthiest.topicPartition(), LogCleaningInProgress$.MODULE$);
                    option = new Some<LogToClean>(filthiest);
                }
                return option;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.time$1 = time$1;
            }
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            /*
             * WARNING - void declaration
             */
            public final Iterable<Tuple2<TopicPartition, Log>> apply() {
                void var1_1;
                Iterable toClean = (Iterable)this.$outer.logs().filter((Function1)((Object)new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final boolean apply(Tuple2<TopicPartition, Log> x0$4) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicPartition topicPartition = tuple2._1();
                            Log log2 = tuple2._2();
                            boolean bl = !this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().contains(topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log2);
                            return bl;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                toClean.foreach(new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$deletableLogs$1 $outer;

                    public final Option<LogCleaningState> apply(Tuple2<TopicPartition, Log> x0$5) {
                        Tuple2<TopicPartition, Log> tuple2 = x0$5;
                        if (tuple2 != null) {
                            TopicPartition tp = tuple2._1();
                            Option<LogCleaningState> option = this.$outer.kafka$log$LogCleanerManager$$anonfun$$$outer().kafka$log$LogCleanerManager$$inProgress().put(tp, LogCleaningInProgress$.MODULE$);
                            return option;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return var1_1;
            }

            public /* synthetic */ LogCleanerManager kafka$log$LogCleanerManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.abortAndPauseCleaning(this.topicPartition$1);
                this.$outer.resumeCleaning(this.topicPartition$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$1 = topicPartition$1;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$1;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$1}));
            }
            {
                this.topicPartition$1 = topicPartition$1;
            }
        }));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Option<LogCleaningState> option;
                block7: {
                    LogCleaningState logCleaningState;
                    block8: {
                        block6: {
                            Option<LogCleaningState> option2;
                            block5: {
                                option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicPartition$3);
                                if (!None$.MODULE$.equals(option)) break block5;
                                option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$3, LogCleaningPaused$.MODULE$);
                                break block6;
                            }
                            if (!(option instanceof Some)) break block7;
                            Some some = (Some)option;
                            LogCleaningState state = (LogCleaningState)some.x();
                            logCleaningState = state;
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block8;
                            Option<LogCleaningState> option3 = this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$3, LogCleaningAborted$.MODULE$);
                            option2 = option3;
                        }
                        while (true) {
                            if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$3, LogCleaningPaused$.MODULE$)) {
                                return;
                            }
                            this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
                        }
                    }
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$3 = topicPartition$3;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$3;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$3}));
            }
            {
                this.topicPartition$3 = topicPartition$3;
            }
        }));
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$4;

            public final Option<LogCleaningState> apply() {
                Option<LogCleaningState> option = this.$outer.kafka$log$LogCleanerManager$$inProgress().get(this.topicPartition$4);
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4})));
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    LogCleaningState state = (LogCleaningState)some.x();
                    LogCleaningState logCleaningState = state;
                    if (LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                        Option<LogCleaningState> option2;
                        Option<LogCleaningState> option3 = option2 = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$4);
                        return option3;
                    }
                    throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4, logCleaningState})));
                }
                throw new MatchError(option);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$4 = topicPartition$4;
            }
        });
        this.info((Function0<String>)((Object)new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final TopicPartition topicPartition$4;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$4}));
            }
            {
                this.topicPartition$4 = topicPartition$4;
            }
        }));
    }

    public boolean kafka$log$LogCleanerManager$$isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        Option<LogCleaningState> option;
        block4: {
            boolean bl;
            block3: {
                LogCleaningState state;
                block2: {
                    option = this.kafka$log$LogCleanerManager$$inProgress().get(topicPartition);
                    if (!None$.MODULE$.equals(option)) break block2;
                    bl = false;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogCleaningState logCleaningState = state = (LogCleaningState)some.x();
                LogCleaningState logCleaningState2 = expectedState;
                bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$5;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                if (this.$outer.kafka$log$LogCleanerManager$$isCleaningInState(this.topicPartition$5, LogCleaningAborted$.MODULE$)) {
                    throw new LogCleaningAbortedException();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$5 = topicPartition$5;
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update2) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, update2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$1;
            private final Option update$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$1);
                Map<TopicPartition, Object> existing = checkpoint.read().filterKeys(this.$outer.logs().keys()).$plus$plus(Option$.MODULE$.option2Iterable(this.update$1));
                checkpoint.write(existing);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$1 = dataDir$1;
                this.update$1 = update$1;
            }
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, dataDir, topicPartition, offset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final File dataDir$2;
            private final TopicPartition topicPartition$2;
            private final long offset$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                OffsetCheckpoint checkpoint;
                Map<TopicPartition, Object> existing;
                if (this.$outer.logs().get(this.topicPartition$2).config().compact() && BoxesRunTime.unboxToLong((existing = (checkpoint = (OffsetCheckpoint)this.$outer.kafka$log$LogCleanerManager$$checkpoints().apply(this.dataDir$2)).read()).getOrElse(this.topicPartition$2, new scala.Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return 0L;
                    }
                })) > this.offset$1) {
                    checkpoint.write(existing.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.topicPartition$2), BoxesRunTime.boxToLong(this.offset$1))));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.dataDir$2 = dataDir$2;
                this.topicPartition$2 = topicPartition$2;
                this.offset$1 = offset$1;
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition, dataDir, endOffset){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$6;
            private final File dataDir$3;
            private final long endOffset$1;

            public final Object apply() {
                LogCleaningState logCleaningState;
                block4: {
                    Serializable serializable;
                    block3: {
                        block2: {
                            logCleaningState = this.$outer.kafka$log$LogCleanerManager$$inProgress().apply(this.topicPartition$6);
                            if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) break block2;
                            this.$outer.updateCheckpoints(this.dataDir$3, Option$.MODULE$.apply(new Tuple2<TopicPartition, Long>(this.topicPartition$6, BoxesRunTime.boxToLong(this.endOffset$1))));
                            serializable = this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$6);
                            break block3;
                        }
                        if (!LogCleaningAborted$.MODULE$.equals(logCleaningState)) break block4;
                        this.$outer.kafka$log$LogCleanerManager$$inProgress().put(this.topicPartition$6, LogCleaningPaused$.MODULE$);
                        this.$outer.kafka$log$LogCleanerManager$$pausedCleaningCond().signalAll();
                        serializable = BoxedUnit.UNIT;
                    }
                    return serializable;
                }
                throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.topicPartition$6, logCleaningState})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$6 = topicPartition$6;
                this.dataDir$3 = dataDir$3;
                this.endOffset$1 = endOffset$1;
            }
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), new scala.Serializable(this, topicPartition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;
            private final TopicPartition topicPartition$7;

            public final Option<LogCleaningState> apply() {
                return this.$outer.kafka$log$LogCleanerManager$$inProgress().remove(this.topicPartition$7);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.topicPartition$7 = topicPartition$7;
            }
        });
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.kafka$log$LogCleanerManager$$checkpoints = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])logDirs).map(new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerManager $outer;

            public final Tuple2<File, OffsetCheckpoint> apply(File dir) {
                return new Tuple2<File, OffsetCheckpoint>(dir, new OffsetCheckpoint(new File(dir, this.$outer.offsetCheckpointFile())));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        this.kafka$log$LogCleanerManager$$inProgress = (HashMap)HashMap$.MODULE$.apply(Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.kafka$log$LogCleanerManager$$pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

