/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.text.NumberFormat;
import kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Log$ {
    public static final Log$ MODULE$;
    private final String LogFileSuffix;
    private final String IndexFileSuffix;
    private final String TimeIndexFileSuffix;
    private final String DeletedFileSuffix;
    private final String CleanedFileSuffix;
    private final String SwapFileSuffix;
    private final String CleanShutdownFile;
    private final String DeleteDirSuffix;

    static {
        new Log$();
    }

    public String LogFileSuffix() {
        return this.LogFileSuffix;
    }

    public String IndexFileSuffix() {
        return this.IndexFileSuffix;
    }

    public String TimeIndexFileSuffix() {
        return this.TimeIndexFileSuffix;
    }

    public String DeletedFileSuffix() {
        return this.DeletedFileSuffix;
    }

    public String CleanedFileSuffix() {
        return this.CleanedFileSuffix;
    }

    public String SwapFileSuffix() {
        return this.SwapFileSuffix;
    }

    public String CleanShutdownFile() {
        return this.CleanShutdownFile;
    }

    public String DeleteDirSuffix() {
        return this.DeleteDirSuffix;
    }

    public String filenamePrefixFromOffset(long offset) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(20);
        nf.setMaximumFractionDigits(0);
        nf.setGroupingUsed(false);
        return nf.format(offset);
    }

    public File logFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.LogFileSuffix()).toString());
    }

    public File indexFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.IndexFileSuffix()).toString());
    }

    public File timeIndexFilename(File dir, long offset) {
        return new File(dir, new StringBuilder().append((Object)this.filenamePrefixFromOffset(offset)).append((Object)this.TimeIndexFileSuffix()).toString());
    }

    public TopicPartition parseTopicPartitionName(File dir) {
        String dirName = dir.getName();
        if (dirName != null && !dirName.isEmpty() && new StringOps(Predef$.MODULE$.augmentString(dirName)).contains(BoxesRunTime.boxToCharacter('-'))) {
            String name = dirName.endsWith(this.DeleteDirSuffix()) ? dirName.substring(0, dirName.indexOf(46)) : dirName;
            int index2 = name.lastIndexOf(45);
            String topic = name.substring(0, index2);
            String partition2 = name.substring(index2 + 1);
            if (topic.length() < 1 || partition2.length() < 1) {
                throw this.exception$1(dir);
            }
            return new TopicPartition(topic, new StringOps(Predef$.MODULE$.augmentString(partition2)).toInt());
        }
        throw this.exception$1(dir);
    }

    public long $lessinit$greater$default$3() {
        return 0L;
    }

    public Time $lessinit$greater$default$5() {
        return Time.SYSTEM;
    }

    private final KafkaException exception$1(File dir) {
        return new KafkaException(new StringBuilder().append((Object)"Found directory ").append((Object)dir.getCanonicalPath()).append((Object)", ").append((Object)"'").append((Object)dir.getName()).append((Object)"' is not in the form of topic-partition\n").append((Object)"If a directory does not contain Kafka topic data it should not exist in Kafka's log ").append((Object)"directory").toString());
    }

    private Log$() {
        MODULE$ = this;
        this.LogFileSuffix = ".log";
        this.IndexFileSuffix = ".index";
        this.TimeIndexFileSuffix = ".timeindex";
        this.DeletedFileSuffix = ".deleted";
        this.CleanedFileSuffix = ".cleaned";
        this.SwapFileSuffix = ".swap";
        this.CleanShutdownFile = ".kafka_cleanshutdown";
        this.DeleteDirSuffix = "-delete";
    }
}

