/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.log.TimeIndex;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.NonLocalReturnControl$mcZ$sp;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Uh!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7c\u0001\u0001\b\u001bA\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\t\u000e\u0003=Q!\u0001\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005Iy!a\u0002'pO\u001eLgn\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001-\u0005\u0011\u0011\u000eZ\u0002\u0001+\u00059\u0002C\u0001\u0005\u0019\u0013\tI\u0012BA\u0002J]RD\u0001b\u0007\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0004S\u0012\u0004\u0003\u0002C\u000f\u0001\u0005\u000b\u0007I\u0011\u0001\u0010\u0002\u0013=4gm]3u\u001b\u0006\u0004X#A\u0010\u0011\u0005\u0001\nS\"\u0001\u0002\n\u0005\t\u0012!!C(gMN,G/T1q\u0011!!\u0003A!A!\u0002\u0013y\u0012AC8gMN,G/T1qA!Aa\u0005\u0001B\u0001B\u0003%q#\u0001\u0007j_\n+hMZ3s'&TX\r\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003\u0018\u0003=i\u0017\r_%p\u0005V4g-\u001a:TSj,\u0007\u0002\u0003\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0016\u0002'\u0011,\bOQ;gM\u0016\u0014Hj\\1e\r\u0006\u001cGo\u001c:\u0011\u0005!a\u0013BA\u0017\n\u0005\u0019!u.\u001e2mK\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u0005uQJ|G\u000f\u001e7feB\u0011a\"M\u0005\u0003e=\u0011\u0011\u0002\u00165s_R$H.\u001a:\t\u0011Q\u0002!\u0011!Q\u0001\nU\nA\u0001^5nKB\u0011agP\u0007\u0002o)\u0011\u0001\u0003\u000f\u0006\u0003si\naaY8n[>t'BA\u0003<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001;$\u0001\u0002+j[\u0016D\u0001B\u0011\u0001\u0003\u0002\u0003\u0006IaQ\u0001\nG\",7m\u001b#p]\u0016\u0004B\u0001\u0003#G\u0015&\u0011Q)\u0003\u0002\n\rVt7\r^5p]F\u0002\"a\u0012%\u000e\u0003aJ!!\u0013\u001d\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]B\u0011\u0001bS\u0005\u0003\u0019&\u0011A!\u00168ji\")a\n\u0001C\u0001\u001f\u00061A(\u001b8jiz\"\u0012\u0002U)S'R+fk\u0016-\u0011\u0005\u0001\u0002\u0001\"\u0002\u000bN\u0001\u00049\u0002\"B\u000fN\u0001\u0004y\u0002\"\u0002\u0014N\u0001\u00049\u0002\"\u0002\u0015N\u0001\u00049\u0002\"\u0002\u0016N\u0001\u0004Y\u0003\"B\u0018N\u0001\u0004\u0001\u0004\"\u0002\u001bN\u0001\u0004)\u0004\"\u0002\"N\u0001\u0004\u0019\u0005b\u0002.\u0001\u0005\u0004%\teW\u0001\u000bY><w-\u001a:OC6,W#\u0001/\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017\u0001\u00027b]\u001eT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n11\u000b\u001e:j]\u001eDa!\u001a\u0001!\u0002\u0013a\u0016a\u00037pO\u001e,'OT1nK\u0002Bqa\u001a\u0001A\u0002\u0013%\u0001.\u0001\u0006sK\u0006$')\u001e4gKJ,\u0012!\u001b\t\u0003U6l\u0011a\u001b\u0006\u0003Y\u0002\f1A\\5p\u0013\tq7N\u0001\u0006CsR,')\u001e4gKJDq\u0001\u001d\u0001A\u0002\u0013%\u0011/\u0001\bsK\u0006$')\u001e4gKJ|F%Z9\u0015\u0005)\u0013\bbB:p\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0004BB;\u0001A\u0003&\u0011.A\u0006sK\u0006$')\u001e4gKJ\u0004\u0003bB<\u0001\u0001\u0004%I\u0001[\u0001\foJLG/\u001a\"vM\u001a,'\u000fC\u0004z\u0001\u0001\u0007I\u0011\u0002>\u0002\u001f]\u0014\u0018\u000e^3Ck\u001a4WM]0%KF$\"AS>\t\u000fMD\u0018\u0011!a\u0001S\"1Q\u0010\u0001Q!\n%\fAb\u001e:ji\u0016\u0014UO\u001a4fe\u0002Bqa \u0001\u0005\u0002\t\t\t!A\u0003dY\u0016\fg\u000e\u0006\u0003\u0002\u0004\u0005U\u0001c\u0002\u0005\u0002\u0006\u0005%\u0011qB\u0005\u0004\u0003\u000fI!A\u0002+va2,'\u0007E\u0002\t\u0003\u0017I1!!\u0004\n\u0005\u0011auN\\4\u0011\u0007\u0001\n\t\"C\u0002\u0002\u0014\t\u0011Ab\u00117fC:,'o\u0015;biNDq!a\u0006\u007f\u0001\u0004\tI\"A\u0005dY\u0016\fg.\u00192mKB\u0019\u0001%a\u0007\n\u0007\u0005u!A\u0001\u0006M_\u001e$vn\u00117fC:D\u0001\"!\t\u0001\t\u0003\u0011\u00111E\u0001\u000eG2,\u0017M\\*fO6,g\u000e^:\u0015\u0017)\u000b)#!\f\u0002D\u0005\u001d\u00131\n\u0005\b\u0007\u0005}\u0001\u0019AA\u0014!\r\u0001\u0013\u0011F\u0005\u0004\u0003W\u0011!a\u0001'pO\"A\u0011qFA\u0010\u0001\u0004\t\t$\u0001\u0005tK\u001elWM\u001c;t!\u0019\t\u0019$!\u000f\u0002>5\u0011\u0011Q\u0007\u0006\u0004\u0003oI\u0011AC2pY2,7\r^5p]&!\u00111HA\u001b\u0005\r\u0019V-\u001d\t\u0004A\u0005}\u0012bAA!\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005\u0015\u0013q\u0004a\u0001?\u0005\u0019Q.\u00199\t\u0011\u0005%\u0013q\u0004a\u0001\u0003\u0013\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u001b\ny\u00021\u0001\u0002\u0010\u0005)1\u000f^1ug\"A\u0011\u0011\u000b\u0001\u0005\u0002\t\t\u0019&A\u0005dY\u0016\fg.\u00138u_Ry!*!\u0016\u0002Z\u0005u\u0013\u0011MA2\u0003[\n\t\bC\u0004\u0002X\u0005=\u0003\u0019\u0001$\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"A\u00111LA(\u0001\u0004\ti$\u0001\u0004t_V\u00148-\u001a\u0005\t\u0003?\ny\u00051\u0001\u0002>\u0005!A-Z:u\u0011\u001d\t)%a\u0014A\u0002}A\u0001\"!\u001a\u0002P\u0001\u0007\u0011qM\u0001\u000ee\u0016$\u0018-\u001b8EK2,G/Z:\u0011\u0007!\tI'C\u0002\u0002l%\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002p\u0005=\u0003\u0019A\f\u0002#5\f\u0007\u0010T8h\u001b\u0016\u001c8/Y4f'&TX\r\u0003\u0005\u0002N\u0005=\u0003\u0019AA\b\u0011\u001d\t)\b\u0001C\u0005\u0003o\n1c\u001d5pk2$'+\u001a;bS:lUm]:bO\u0016$B\"a\u001a\u0002z\u0005m\u0014QPA@\u0003\u001fC\u0001\"a\u0017\u0002t\u0001\u0007\u0011Q\b\u0005\b\u0003\u000b\n\u0019\b1\u0001 \u0011!\t)'a\u001dA\u0002\u0005\u001d\u0004\u0002CAA\u0003g\u0002\r!a!\u0002\u000b\u0015tGO]=\u0011\t\u0005\u0015\u00151R\u0007\u0003\u0003\u000fS1!!#9\u0003\u0019\u0011XmY8sI&!\u0011QRAD\u0005!aunZ#oiJL\b\u0002CA'\u0003g\u0002\r!a\u0004\t\u000f\u0005M\u0005\u0001\"\u0001\u0002\u0016\u0006YqM]8x\u0005V4g-\u001a:t)\rQ\u0015q\u0013\u0005\b\u0003_\n\t\n1\u0001\u0018\u0011\u001d\tY\n\u0001C\u0001\u0003;\u000baB]3ti>\u0014XMQ;gM\u0016\u00148\u000fF\u0001K\u0011!\t\t\u000b\u0001C\u0001\u0005\u0005\r\u0016aE4s_V\u00048+Z4nK:$8OQ=TSj,G\u0003CAS\u0003{\u000b)-!3\u0011\r\u0005\u001d\u0016qWA\u0019\u001d\u0011\tI+a-\u000f\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,\u0016\u0003\u0019a$o\\8u}%\t!\"C\u0002\u00026&\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002:\u0006m&\u0001\u0002'jgRT1!!.\n\u0011!\ty#a(A\u0002\u0005}\u0006CBA\u001a\u0003\u0003\fi$\u0003\u0003\u0002D\u0006U\"\u0001C%uKJ\f'\r\\3\t\u000f\u0005\u001d\u0017q\u0014a\u0001/\u00059Q.\u0019=TSj,\u0007bBAf\u0003?\u0003\raF\u0001\r[\u0006D\u0018J\u001c3fqNK'0\u001a\u0005\t\u0003\u001f\u0004A\u0011\u0001\u0002\u0002R\u0006q!-^5mI>3gm]3u\u001b\u0006\u0004Hc\u0003&\u0002T\u0006U\u0017\u0011\\Ao\u0003?DqaAAg\u0001\u0004\t9\u0003\u0003\u0005\u0002X\u00065\u0007\u0019AA\u0005\u0003\u0015\u0019H/\u0019:u\u0011!\tY.!4A\u0002\u0005%\u0011aA3oI\"9\u0011QIAg\u0001\u0004y\u0002\u0002CA'\u0003\u001b\u0004\r!a\u0004\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u0006A\"-^5mI>3gm]3u\u001b\u0006\u0004hi\u001c:TK\u001elWM\u001c;\u0015\u001d\u0005\u001d\u0014q]Au\u0003[\fy/!=\u0002t\"9\u0011qKAq\u0001\u00041\u0005\u0002CAv\u0003C\u0004\r!!\u0010\u0002\u000fM,w-\\3oi\"9\u0011QIAq\u0001\u0004y\u0002\u0002CAl\u0003C\u0004\r!!\u0003\t\u000f\u0005=\u0014\u0011\u001da\u0001/!A\u0011QJAq\u0001\u0004\ty\u0001")
public class Cleaner
implements Logging {
    private final int id;
    private final OffsetMap offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    private final double dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    public OffsetMap offsetMap() {
        return this.offsetMap;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer x$1) {
        this.kafka$log$Cleaner$$readBuffer = x$1;
    }

    private ByteBuffer writeBuffer() {
        return this.writeBuffer;
    }

    private void writeBuffer_$eq(ByteBuffer x$1) {
        this.writeBuffer = x$1;
    }

    public Tuple2<Object, CleanerStats> clean(LogToClean cleanable) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log2;
            CleanerStats stats;
            block3: {
                block2: {
                    stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Beginning cleaning of log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    log2 = cleanable.log();
                    this.info((Function0<String>)((Object)new Serializable(this, cleanable){
                        public static final long serialVersionUID = 0L;
                        private final LogToClean cleanable$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Building offset map for %s...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = cleanable$1;
                        }
                    }));
                    long upperBoundOffset = cleanable.firstUncleanableOffset();
                    this.buildOffsetMap(log2, cleanable.firstDirtyOffset(), upperBoundOffset, this.offsetMap(), stats);
                    endOffset = this.offsetMap().latestOffset() + 1L;
                    stats.indexDone();
                    option = log2.logSegments(0L, cleanable.firstDirtyOffset()).lastOption();
                    if (!None$.MODULE$.equals(option)) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                LogSegment seg = (LogSegment)some.x();
                l = seg.lastModified() - Predef$.MODULE$.Long2long(log2.config().deleteRetentionMs());
            }
            long deleteHorizonMs = l;
            long cleanableHorizonMs = BoxesRunTime.unboxToLong(log2.logSegments(0L, cleanable.firstUncleanableOffset()).lastOption().map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(LogSegment x$13) {
                    return x$13.lastModified();
                }
            }).getOrElse(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply() {
                    return this.apply$mcJ$sp();
                }

                public long apply$mcJ$sp() {
                    return 0L;
                }
            }));
            this.info((Function0<String>)((Object)new Serializable(this, log2, deleteHorizonMs, cleanableHorizonMs){
                public static final long serialVersionUID = 0L;
                private final Log log$1;
                private final long deleteHorizonMs$1;
                private final long cleanableHorizonMs$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Cleaning log %s (cleaning prior to %s, discarding tombstones prior to %s)...")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$1.name(), new Date(this.cleanableHorizonMs$1), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                    this.cleanableHorizonMs$1 = cleanableHorizonMs$1;
                }
            }));
            this.groupSegmentsBySize(log2.logSegments(0L, endOffset), Predef$.MODULE$.Integer2int(log2.config().segmentSize()), Predef$.MODULE$.Integer2int(log2.config().maxIndexSize())).foreach(new Serializable(this, stats, log2, deleteHorizonMs){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                private final CleanerStats stats$2;
                private final Log log$1;
                private final long deleteHorizonMs$1;

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$1, group, this.$outer.offsetMap(), this.deleteHorizonMs$1, this.stats$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.stats$2 = stats$2;
                    this.log$1 = log$1;
                    this.deleteHorizonMs$1 = deleteHorizonMs$1;
                }
            });
            stats.bufferUtilization_$eq(this.offsetMap().utilization());
            stats.allDone();
            return new Tuple2<Object, CleanerStats>(BoxesRunTime.boxToLong(endOffset), stats);
        }
        throw new MatchError(option);
    }

    public void cleanSegments(Log log2, Seq<LogSegment> segments, OffsetMap map2, long deleteHorizonMs, CleanerStats stats) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        File timeIndexFile = new File(new StringBuilder().append((Object)((LogSegment)segments.head()).timeIndex().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        timeIndexFile.delete();
        FileRecords records = FileRecords.open(logFile, false, log2.initFileSize(), Predef$.MODULE$.Boolean2boolean(log2.config().preallocate()));
        OffsetIndex index2 = new OffsetIndex(indexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).index().maxIndexSize());
        TimeIndex timeIndex = new TimeIndex(timeIndexFile, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).timeIndex().maxIndexSize());
        LogSegment cleaned = new LogSegment(records, index2, timeIndex, ((LogSegment)segments.head()).baseOffset(), ((LogSegment)segments.head()).indexIntervalBytes(), log2.config().randomSegmentJitter(), this.time);
        try {
            segments.foreach(new Serializable(this, log2, map2, deleteHorizonMs, stats, cleaned){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cleaner $outer;
                public final Log log$3;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                private final CleanerStats stats$4;
                public final LogSegment cleaned$1;

                public final void apply(LogSegment old) {
                    boolean retainDeletes = old.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)((Object)new Serializable(this, retainDeletes, old){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$cleanSegments$1 $outer;
                        private final boolean retainDeletes$1;
                        private final LogSegment old$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (largest timestamp %s) into %s, %s deletes.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.old$1.baseOffset()), this.$outer.log$3.name(), new Date(this.old$1.largestTimestamp()), BoxesRunTime.boxToLong(this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.retainDeletes$1 = retainDeletes$1;
                            this.old$1 = old$1;
                        }
                    }));
                    this.$outer.cleanInto(this.log$3.topicPartition(), old, this.cleaned$1, this.map$2, retainDeletes, Predef$.MODULE$.Integer2int(this.log$3.config().maxMessageSize()), this.stats$4);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.log$3 = log$3;
                    this.map$2 = map$2;
                    this.deleteHorizonMs$2 = deleteHorizonMs$2;
                    this.stats$4 = stats$4;
                    this.cleaned$1 = cleaned$1;
                }
            });
            index2.trimToValidSize();
            cleaned.onBecomeInactiveSegment();
            timeIndex.trimToValidSize();
            cleaned.flush();
            long modified = ((LogSegment)segments.last()).lastModified();
            cleaned.lastModified_$eq(modified);
            this.info((Function0<String>)((Object)new Serializable(this, log2, segments, cleaned){
                public static final long serialVersionUID = 0L;
                private final Log log$3;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final long apply(LogSegment x$14) {
                            return x$14.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$3.name()}));
                }
                {
                    this.log$3 = log$3;
                    this.segments$1 = segments$1;
                    this.cleaned$1 = cleaned$1;
                }
            }));
            log2.replaceSegments(cleaned, segments, log2.replaceSegments$default$3());
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicPartition topicPartition, LogSegment source, LogSegment dest, OffsetMap map2, boolean retainDeletes, int maxLogMessageSize, CleanerStats stats) {
        MemoryRecords.LogEntryFilter logCleanerFilter = new MemoryRecords.LogEntryFilter(this, source, map2, retainDeletes, stats){
            private final /* synthetic */ Cleaner $outer;
            private final LogSegment source$1;
            private final OffsetMap map$3;
            private final boolean retainDeletes$2;
            private final CleanerStats stats$5;

            public boolean shouldRetain(LogEntry logEntry) {
                return this.$outer.kafka$log$Cleaner$$shouldRetainMessage(this.source$1, this.map$3, this.retainDeletes$2, logEntry, this.stats$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.source$1 = source$1;
                this.map$3 = map$3;
                this.retainDeletes$2 = retainDeletes$2;
                this.stats$5 = stats$5;
            }
        };
        int position = 0;
        while (position < source.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.writeBuffer().clear();
            source.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
            MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
            this.throttler.maybeThrottle(records.sizeInBytes());
            MemoryRecords.FilterResult result2 = records.filterTo(logCleanerFilter, this.writeBuffer());
            stats.readMessages(result2.messagesRead, result2.bytesRead);
            stats.recopyMessages(result2.messagesRetained, result2.bytesRetained);
            position += result2.bytesRead;
            if (this.writeBuffer().position() > 0) {
                this.writeBuffer().flip();
                MemoryRecords retained = MemoryRecords.readableRecords(this.writeBuffer());
                dest.append(retained.deepEntries().iterator().next().offset(), result2.maxOffset, result2.maxTimestamp, result2.shallowOffsetOfMaxTimestamp, retained);
                this.throttler.maybeThrottle(this.writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || result2.messagesRead != 0) continue;
            this.growBuffers(maxLogMessageSize);
        }
        this.restoreBuffers();
    }

    public boolean kafka$log$Cleaner$$shouldRetainMessage(LogSegment source, OffsetMap map2, boolean retainDeletes, LogEntry entry2, CleanerStats stats) {
        boolean bl;
        boolean pastLatestOffset;
        boolean bl2 = pastLatestOffset = entry2.offset() > map2.latestOffset();
        if (pastLatestOffset) {
            return true;
        }
        if (entry2.record().hasKey()) {
            boolean obsoleteDelete;
            ByteBuffer key = entry2.record().key();
            long foundOffset = map2.get(key);
            boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
            boolean bl3 = obsoleteDelete = !retainDeletes && entry2.record().hasNullValue();
            bl = !redundant && !obsoleteDelete;
        } else {
            stats.invalidMessage();
            bl = false;
        }
        return bl;
    }

    public void growBuffers(int maxLogMessageSize) {
        int maxBufferSize = package$.MODULE$.max(maxLogMessageSize, this.maxIoBufferSize);
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= maxBufferSize || this.writeBuffer().capacity() >= maxBufferSize) {
            throw new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(maxBufferSize)})));
        }
        int newSize = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, maxBufferSize);
        this.info((Function0<String>)((Object)new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final int newSize$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append(BoxesRunTime.boxToInteger(this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append(BoxesRunTime.boxToInteger(this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        }));
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize));
        this.writeBuffer_$eq(ByteBuffer.allocate(newSize));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.writeBuffer().capacity() > this.ioBufferSize) {
            this.writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        List grouped2 = Nil$.MODULE$;
        List segs = segments.toList();
        while (segs.nonEmpty()) {
            List<LogSegment> group = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            int timeIndexSize = ((LogSegment)segs.head()).timeIndex().sizeInBytes();
            segs = (List)segs.tail();
            while (segs.nonEmpty() && logSize + ((LogSegment)segs.head()).size() <= (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() <= maxIndexSize && timeIndexSize + ((LogSegment)segs.head()).timeIndex().sizeInBytes() <= maxIndexSize && ((LogSegment)segs.head()).index().lastOffset() - ((LogSegment)group.last()).index().baseOffset() <= Integer.MAX_VALUE) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon(logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                timeIndexSize += ((LogSegment)segs.head()).timeIndex().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped2 = grouped2.$colon$colon(group.reverse());
        }
        return grouped2.reverse();
    }

    public void buildOffsetMap(Log log2, long start, long end, OffsetMap map2, CleanerStats stats) {
        map2.clear();
        Buffer dirty = log2.logSegments(start, end).toBuffer();
        this.info((Function0<String>)((Object)new Serializable(this, log2, start, end, dirty){
            public static final long serialVersionUID = 0L;
            private final Log log$2;
            private final long start$1;
            private final long end$1;
            private final Buffer dirty$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name(), BoxesRunTime.boxToInteger(this.dirty$1.size()), BoxesRunTime.boxToLong(this.start$1), BoxesRunTime.boxToLong(this.end$1)}));
            }
            {
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.end$1 = end$1;
                this.dirty$1 = dirty$1;
            }
        }));
        BooleanRef full = BooleanRef.create(false);
        dirty.withFilter(new Serializable(this, full){
            public static final long serialVersionUID = 0L;
            private final BooleanRef full$1;

            public final boolean apply(LogSegment segment) {
                return !this.full$1.elem;
            }
            {
                this.full$1 = full$1;
            }
        }).foreach(new Serializable(this, log2, start, map2, stats, dirty, full){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Cleaner $outer;
            private final Log log$2;
            private final long start$1;
            private final OffsetMap map$1;
            private final CleanerStats stats$3;
            public final Buffer dirty$1;
            private final BooleanRef full$1;

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply(this.log$2.topicPartition());
                this.full$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$2.topicPartition(), segment, this.map$1, this.start$1, Predef$.MODULE$.Integer2int(this.log$2.config().maxMessageSize()), this.stats$3);
                if (this.full$1.elem) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, segment){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$buildOffsetMap$3 $outer;
                        private final LogSegment segment$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Offset map is full, %d segments fully mapped, segment with base offset %d is partially mapped")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.dirty$1.indexOf(this.segment$1)), BoxesRunTime.boxToLong(this.segment$1.baseOffset())}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.segment$1 = segment$1;
                        }
                    }));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$2 = log$2;
                this.start$1 = start$1;
                this.map$1 = map$1;
                this.stats$3 = stats$3;
                this.dirty$1 = dirty$1;
                this.full$1 = full$1;
            }
        });
        this.info((Function0<String>)((Object)new Serializable(this, log2){
            public static final long serialVersionUID = 0L;
            private final Log log$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Offset map for log %s complete.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.log$2.name()}));
            }
            {
                this.log$2 = log$2;
            }
        }));
    }

    public boolean kafka$log$Cleaner$$buildOffsetMapForSegment(TopicPartition topicPartition, LogSegment segment, OffsetMap map2, long start, int maxLogMessageSize, CleanerStats stats) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                int position = segment.index().lookup(start).position();
                int maxDesiredMapSize = (int)((double)map2.slots() * this.dupBufferLoadFactor);
                while (position < segment.log().sizeInBytes()) {
                    this.kafka$log$Cleaner$$checkDone.apply(topicPartition);
                    this.kafka$log$Cleaner$$readBuffer().clear();
                    segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position);
                    MemoryRecords records = MemoryRecords.readableRecords(this.kafka$log$Cleaner$$readBuffer());
                    this.throttler.maybeThrottle(records.sizeInBytes());
                    int startPosition = position;
                    ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.deepEntries()).asScala()).foreach(new Serializable(this, map2, start, stats, maxDesiredMapSize, object){
                        public static final long serialVersionUID = 0L;
                        private final OffsetMap map$4;
                        private final long start$2;
                        private final CleanerStats stats$6;
                        private final int maxDesiredMapSize$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(LogEntry entry2) {
                            Record message = entry2.record();
                            if (message.hasKey() && entry2.offset() >= this.start$2) {
                                if (this.map$4.size() < this.maxDesiredMapSize$1) {
                                    this.map$4.put(message.key(), entry2.offset());
                                } else {
                                    throw new NonLocalReturnControl$mcZ$sp(this.nonLocalReturnKey1$1, true);
                                }
                            }
                            this.stats$6.indexMessagesRead(1);
                        }
                        {
                            this.map$4 = map$4;
                            this.start$2 = start$2;
                            this.stats$6 = stats$6;
                            this.maxDesiredMapSize$1 = maxDesiredMapSize$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                    int bytesRead = records.validBytes();
                    stats.indexBytesRead(bytesRead);
                    if ((position += bytesRead) != startPosition) continue;
                    this.growBuffers(maxLogMessageSize);
                }
                this.restoreBuffers();
                bl = false;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append(BoxesRunTime.boxToInteger(id)).append((Object)": ").toString());
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.writeBuffer = ByteBuffer.allocate(ioBufferSize);
        Predef$.MODULE$.require((double)offsetMap.slots() * dupBufferLoadFactor > 1.0, (Function0<Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "offset map is too small to fit in even a single message, so log cleaning will never make progress. You can increase log.cleaner.dedupe.buffer.size or decrease log.cleaner.threads";
            }
        }));
    }
}

