/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kafka.log.AbstractIndex$;
import kafka.log.IndexEntry;
import kafka.log.IndexSearchType$;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Os$;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tMa!B\u0001\u0003\u0003\u00039!!D!cgR\u0014\u0018m\u0019;J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001!F\u0002\t\u000b>\u001b2\u0001A\u0005\u0010!\tQQ\"D\u0001\f\u0015\u0005a\u0011!B:dC2\f\u0017B\u0001\b\f\u0005\u0019\te.\u001f*fMB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003B\u0001\u0006kRLGn]\u0005\u0003)E\u0011q\u0001T8hO&tw\r\u0003\u0005\u0017\u0001\t\u0005\r\u0011\"\u0001\u0018\u0003\u00111\u0017\u000e\\3\u0016\u0003a\u0001\"!\u0007\u0010\u000e\u0003iQ!a\u0007\u000f\u0002\u0005%|'\"A\u000f\u0002\t)\fg/Y\u0005\u0003?i\u0011AAR5mK\"A\u0011\u0005\u0001BA\u0002\u0013\u0005!%\u0001\u0005gS2,w\fJ3r)\t\u0019c\u0005\u0005\u0002\u000bI%\u0011Qe\u0003\u0002\u0005+:LG\u000fC\u0004(A\u0005\u0005\t\u0019\u0001\r\u0002\u0007a$\u0013\u0007\u0003\u0005*\u0001\t\u0005\t\u0015)\u0003\u0019\u0003\u00151\u0017\u000e\\3!Q\tA3\u0006\u0005\u0002\u000bY%\u0011Qf\u0003\u0002\tm>d\u0017\r^5mK\"Aq\u0006\u0001BC\u0002\u0013\u0005\u0001'\u0001\u0006cCN,wJ\u001a4tKR,\u0012!\r\t\u0003\u0015IJ!aM\u0006\u0003\t1{gn\u001a\u0005\tk\u0001\u0011\t\u0011)A\u0005c\u0005Y!-Y:f\u001f\u001a47/\u001a;!\u0011!9\u0004A!b\u0001\n\u0003A\u0014\u0001D7bq&sG-\u001a=TSj,W#A\u001d\u0011\u0005)Q\u0014BA\u001e\f\u0005\rIe\u000e\u001e\u0005\t{\u0001\u0011\t\u0011)A\u0005s\u0005iQ.\u0019=J]\u0012,\u0007pU5{K\u0002BQa\u0010\u0001\u0005\u0002\u0001\u000ba\u0001P5oSRtD\u0003B!R%N\u0003BA\u0011\u0001D\u001d6\t!\u0001\u0005\u0002E\u000b2\u0001A!\u0002$\u0001\u0005\u00049%!A&\u0012\u0005![\u0005C\u0001\u0006J\u0013\tQ5BA\u0004O_RD\u0017N\\4\u0011\u0005)a\u0015BA'\f\u0005\r\te.\u001f\t\u0003\t>#Q\u0001\u0015\u0001C\u0002\u001d\u0013\u0011A\u0016\u0005\u0006-y\u0002\r\u0001\u0007\u0005\u0006_y\u0002\r!\r\u0005\boy\u0002\n\u00111\u0001:\u0011\u0015)\u0006A\"\u00059\u0003%)g\u000e\u001e:z'&TX\rC\u0004X\u0001\t\u0007I\u0011\u0003-\u0002\t1|7m[\u000b\u00023B\u0011!,Y\u0007\u00027*\u0011A,X\u0001\u0006Y>\u001c7n\u001d\u0006\u0003=~\u000b!bY8oGV\u0014(/\u001a8u\u0015\t\u0001G$\u0001\u0003vi&d\u0017B\u00012\\\u00055\u0011V-\u001a8ue\u0006tG\u000fT8dW\"1A\r\u0001Q\u0001\ne\u000bQ\u0001\\8dW\u0002BqA\u001a\u0001A\u0002\u0013Eq-\u0001\u0003n[\u0006\u0004X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-d\u0012a\u00018j_&\u0011QN\u001b\u0002\u0011\u001b\u0006\u0004\b/\u001a3CsR,')\u001e4gKJDqa\u001c\u0001A\u0002\u0013E\u0001/\u0001\u0005n[\u0006\u0004x\fJ3r)\t\u0019\u0013\u000fC\u0004(]\u0006\u0005\t\u0019\u00015\t\rM\u0004\u0001\u0015)\u0003i\u0003\u0015iW.\u00199!Q\t\u00118\u0006\u0003\u0004w\u0001\u0001\u0006K!O\u0001\f?6\f\u00070\u00128ue&,7\u000f\u000b\u0002vW!9\u0011\u0010\u0001a\u0001\n#A\u0014\u0001C0f]R\u0014\u0018.Z:\t\u000fm\u0004\u0001\u0019!C\ty\u0006aq,\u001a8ue&,7o\u0018\u0013fcR\u00111% \u0005\bOi\f\t\u00111\u0001:\u0011\u0019y\b\u0001)Q\u0005s\u0005Iq,\u001a8ue&,7\u000f\t\u0015\u0003}.Bq!!\u0002\u0001\t\u0003\t9!\u0001\u0004jg\u001a+H\u000e\\\u000b\u0003\u0003\u0013\u00012ACA\u0006\u0013\r\tia\u0003\u0002\b\u0005>|G.Z1o\u0011\u0019\t\t\u0002\u0001C\u0001q\u0005QQ.\u0019=F]R\u0014\u0018.Z:\t\r\u0005U\u0001\u0001\"\u00019\u0003\u001d)g\u000e\u001e:jKNDq!!\u0007\u0001\t\u0003\tY\"\u0001\u0004sKNL'0\u001a\u000b\u0004G\u0005u\u0001bBA\u0010\u0003/\u0001\r!O\u0001\b]\u0016<8+\u001b>f\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003K\t\u0001B]3oC6,Gk\u001c\u000b\u0004G\u0005\u001d\u0002bBA\u0015\u0003C\u0001\r\u0001G\u0001\u0002M\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012!\u00024mkNDG#A\u0012\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u00051A-\u001a7fi\u0016$\"!!\u0003\t\u000f\u0005e\u0002\u0001\"\u0001\u00020\u0005yAO]5n)>4\u0016\r\\5e'&TX\r\u0003\u0004\u0002>\u0001!\t\u0001O\u0001\fg&TX-\u00138CsR,7\u000fC\u0004\u0002B\u0001!\t!a\f\u0002\u000b\rdwn]3\t\u000f\u0005\u0015\u0003A\"\u0001\u00020\u0005Y1/\u00198jif\u001c\u0005.Z2l\u0011\u001d\tI\u0005\u0001D\u0001\u0003_\t\u0001\u0002\u001e:v]\u000e\fG/\u001a\u0005\b\u0003\u001b\u0002a\u0011AA(\u0003)!(/\u001e8dCR,Gk\u001c\u000b\u0004G\u0005E\u0003bBA*\u0003\u0017\u0002\r!M\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005]\u0003\u0001\"\u0005\u0002Z\u0005Qam\u001c:dKVsW.\u00199\u0015\u0007\r\nY\u0006C\u0004\u0002^\u0005U\u0003\u0019\u00015\u0002\u00035Dq!!\u0019\u0001\t#\t\u0019'A\u0005nCf\u0014W\rT8dWV!\u0011QMA6)\u0011\t9'!\u001f\u0015\t\u0005%\u0014q\u000e\t\u0004\t\u0006-DaBA7\u0003?\u0012\ra\u0012\u0002\u0002)\"I\u0011\u0011OA0\t\u0003\u0007\u00111O\u0001\u0004MVt\u0007#\u0002\u0006\u0002v\u0005%\u0014bAA<\u0017\tAAHY=oC6,g\bC\u0004X\u0003?\u0002\r!a\u001f\u0011\u0007i\u000bi(C\u0002\u0002\u0000m\u0013A\u0001T8dW\"9\u00111\u0011\u0001\u0007\u0012\u0005\u0015\u0015A\u00039beN,WI\u001c;ssR1\u0011qQAG\u0003/\u00032AQAE\u0013\r\tYI\u0001\u0002\u000b\u0013:$W\r_#oiJL\b\u0002CAH\u0003\u0003\u0003\r!!%\u0002\r\t,hMZ3s!\rI\u00171S\u0005\u0004\u0003+S'A\u0003\"zi\u0016\u0014UO\u001a4fe\"9\u0011\u0011TAA\u0001\u0004I\u0014!\u00018\t\u000f\u0005u\u0005\u0001\"\u0005\u0002 \u0006a\u0011N\u001c3fqNcw\u000e\u001e$peR9\u0011(!)\u0002&\u0006%\u0006\u0002CAR\u00037\u0003\r!!%\u0002\u0007%$\u0007\u0010C\u0004\u0002(\u0006m\u0005\u0019A\u0019\u0002\rQ\f'oZ3u\u0011!\tY+a'A\u0002\u00055\u0016\u0001D:fCJ\u001c\u0007.\u00128uSRL\b\u0003BAX\u0003\u0007tA!!-\u0002@:!\u00111WA_\u001d\u0011\t),a/\u000e\u0005\u0005]&bAA]\r\u00051AH]8pizJ\u0011!B\u0005\u0003\u0007\u0011I1!!1\u0003\u0003=Ie\u000eZ3y'\u0016\f'o\u00195UsB,\u0017\u0002BAc\u0003\u000f\u0014\u0011#\u00138eKb\u001cV-\u0019:dQ\u0016sG/\u001b;z\u0015\r\t\tM\u0001\u0005\b\u0003\u0017\u0004A\u0011BAg\u0003E\u0019w.\u001c9be\u0016Le\u000eZ3y\u000b:$(/\u001f\u000b\bs\u0005=\u00171[Ak\u0011!\t\t.!3A\u0002\u0005\u001d\u0015AC5oI\u0016DXI\u001c;ss\"9\u0011qUAe\u0001\u0004\t\u0004\u0002CAV\u0003\u0013\u0004\r!!,\t\u000f\u0005e\u0007\u0001\"\u0003\u0002\\\u0006A\"o\\;oI\u0012{wO\u001c+p\u000bb\f7\r^'vYRL\u0007\u000f\\3\u0015\u000be\ni.!9\t\u000f\u0005}\u0017q\u001ba\u0001s\u00051a.^7cKJDq!a9\u0002X\u0002\u0007\u0011(\u0001\u0004gC\u000e$xN]\u0004\n\u0003O\u0014\u0011\u0011!E\u0001\u0003S\fQ\"\u00112tiJ\f7\r^%oI\u0016D\bc\u0001\"\u0002l\u001aA\u0011AAA\u0001\u0012\u0003\tioE\u0002\u0002l&AqaPAv\t\u0003\t\t\u0010\u0006\u0002\u0002j\"Q\u0011Q_Av#\u0003%\t!a>\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\tIPa\u0004\u0003\u0012U\u0011\u00111 \u0016\u0004s\u0005u8FAA\u0000!\u0011\u0011\tAa\u0003\u000e\u0005\t\r!\u0002\u0002B\u0003\u0005\u000f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%1\"\u0001\u0006b]:|G/\u0019;j_:LAA!\u0004\u0003\u0004\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0005\r\u0019\u000b\u0019P1\u0001H\t\u0019\u0001\u00161\u001fb\u0001\u000f\u0002")
public abstract class AbstractIndex<K, V>
implements Logging {
    private volatile File file;
    private final long baseOffset;
    private final int maxIndexSize;
    private final ReentrantLock lock;
    private volatile MappedByteBuffer mmap;
    public volatile int kafka$log$AbstractIndex$$_maxEntries;
    private volatile int _entries;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static <K, V> int $lessinit$greater$default$3() {
        return AbstractIndex$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AbstractIndex abstractIndex = this;
        synchronized (abstractIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public int maxIndexSize() {
        return this.maxIndexSize;
    }

    public abstract int entrySize();

    public ReentrantLock lock() {
        return this.lock;
    }

    public MappedByteBuffer mmap() {
        return this.mmap;
    }

    public void mmap_$eq(MappedByteBuffer x$1) {
        this.mmap = x$1;
    }

    public int _entries() {
        return this._entries;
    }

    public void _entries_$eq(int x$1) {
        this._entries = x$1;
    }

    public boolean isFull() {
        return this._entries() >= this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int maxEntries() {
        return this.kafka$log$AbstractIndex$$_maxEntries;
    }

    public int entries() {
        return this._entries();
    }

    public void resize(int newSize) {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this, newSize){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;
            private final int newSize$1;

            /*
             * WARNING - void declaration
             */
            public final Buffer apply() {
                Buffer buffer;
                RandomAccessFile raf = new RandomAccessFile(this.$outer.file(), "rw");
                int roundedNewSize = this.$outer.kafka$log$AbstractIndex$$roundDownToExactMultiple(this.newSize$1, this.$outer.entrySize());
                int position = this.$outer.mmap().position();
                if (Os$.MODULE$.isWindows()) {
                    this.$outer.forceUnmap(this.$outer.mmap());
                }
                try {
                    raf.setLength(roundedNewSize);
                    this.$outer.mmap_$eq(raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, roundedNewSize));
                    this.$outer.kafka$log$AbstractIndex$$_maxEntries = this.$outer.mmap().limit() / this.$outer.entrySize();
                    buffer = this.$outer.mmap().position(position);
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, raf){
                        public static final long serialVersionUID = 0L;
                        private final RandomAccessFile raf$2;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.raf$2.close();
                        }
                        {
                            this.raf$2 = raf$2;
                        }
                    }));
                }
                catch (Throwable throwable) {
                    void var1_1;
                    CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
                    throw throwable;
                }
                return buffer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newSize$1 = newSize$1;
            }
        });
    }

    public void renameTo(File f) {
        try {
            Utils.atomicMoveWithFallback(this.file().toPath(), f.toPath());
            return;
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void flush() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final MappedByteBuffer apply() {
                return this.$outer.mmap().force();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public boolean delete() {
        this.info((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final String apply() {
                return new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting index ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.file().getAbsolutePath()}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$delete$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().forceUnmap(this.$outer.kafka$log$AbstractIndex$$anonfun$$$outer().mmap());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }));
                this.$outer.mmap_$eq(null);
            }

            public /* synthetic */ AbstractIndex kafka$log$AbstractIndex$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return this.file().delete();
    }

    public void trimToValidSize() {
        CoreUtils$.MODULE$.inLock(this.lock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AbstractIndex $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.resize(this.$outer.entrySize() * this.$outer._entries());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public int sizeInBytes() {
        return this.entrySize() * this._entries();
    }

    public void close() {
        this.trimToValidSize();
    }

    public abstract void sanityCheck();

    public abstract void truncate();

    public abstract void truncateTo(long var1);

    public void forceUnmap(MappedByteBuffer m) {
        try {
            MappedByteBuffer mappedByteBuffer = m;
            if (mappedByteBuffer instanceof DirectBuffer) {
                BoxedUnit boxedUnit;
                MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer;
                Cleaner bufferCleaner = ((DirectBuffer)((Object)mappedByteBuffer2)).cleaner();
                if (bufferCleaner == null) {
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    bufferCleaner.clean();
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        catch (Throwable throwable) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error when freeing index buffer";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable t$1;

                public final Throwable apply() {
                    return this.t$1;
                }
                {
                    this.t$1 = t$1;
                }
            }));
        }
    }

    public <T> T maybeLock(Lock lock2, Function0<T> fun) {
        if (Os$.MODULE$.isWindows()) {
            lock2.lock();
        }
        try {
            return fun.apply();
        }
        finally {
            if (Os$.MODULE$.isWindows()) {
                lock2.unlock();
            }
        }
    }

    public abstract IndexEntry parseEntry(ByteBuffer var1, int var2);

    public int indexSlotFor(ByteBuffer idx, long target, Enumeration.Value searchEntity) {
        if (this._entries() == 0) {
            return -1;
        }
        if (this.compareIndexEntry(this.parseEntry(idx, 0), target, searchEntity) > 0) {
            return -1;
        }
        int lo = 0;
        int hi = this._entries() - 1;
        while (lo < hi) {
            int mid = (int)package$.MODULE$.ceil((double)hi / 2.0 + (double)lo / 2.0);
            IndexEntry found = this.parseEntry(idx, mid);
            int compareResult = this.compareIndexEntry(found, target, searchEntity);
            if (compareResult > 0) {
                hi = mid - 1;
                continue;
            }
            if (compareResult < 0) {
                lo = mid;
                continue;
            }
            return mid;
        }
        return lo;
    }

    private int compareIndexEntry(IndexEntry indexEntry, long target, Enumeration.Value searchEntity) {
        Enumeration.Value value2;
        block4: {
            int n;
            block3: {
                block2: {
                    value2 = searchEntity;
                    Enumeration.Value value3 = IndexSearchType$.MODULE$.KEY();
                    Enumeration.Value value4 = value2;
                    if (value3 != null ? !((Object)value3).equals(value4) : value4 != null) break block2;
                    n = Predef$.MODULE$.long2Long(indexEntry.indexKey()).compareTo(Predef$.MODULE$.long2Long(target));
                    break block3;
                }
                Enumeration.Value value5 = IndexSearchType$.MODULE$.VALUE();
                Enumeration.Value value6 = value2;
                if (value5 != null ? !((Object)value5).equals(value6) : value6 != null) break block4;
                n = Predef$.MODULE$.long2Long(indexEntry.indexValue()).compareTo(Predef$.MODULE$.long2Long(target));
            }
            return n;
        }
        throw new MatchError(value2);
    }

    public int kafka$log$AbstractIndex$$roundDownToExactMultiple(int number2, int factor) {
        return factor * (number2 / factor);
    }

    /*
     * WARNING - void declaration
     */
    public AbstractIndex(File file, long baseOffset, int maxIndexSize) {
        this.file = file;
        this.baseOffset = baseOffset;
        this.maxIndexSize = maxIndexSize;
        Logging$class.$init$(this);
        this.lock = new ReentrantLock();
        boolean newlyCreated = this.file().createNewFile();
        RandomAccessFile raf = new RandomAccessFile(this.file(), "rw");
        try {
            if (newlyCreated) {
                if (maxIndexSize < this.entrySize()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid max index size: ").append(BoxesRunTime.boxToInteger(maxIndexSize)).toString());
                }
                raf.setLength(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(maxIndexSize, this.entrySize()));
            }
            long len = raf.length();
            MappedByteBuffer idx = raf.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, len);
            Buffer buffer = newlyCreated ? idx.position(0) : idx.position(this.kafka$log$AbstractIndex$$roundDownToExactMultiple(idx.limit(), this.entrySize()));
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(this, raf){
                public static final long serialVersionUID = 0L;
                private final RandomAccessFile raf$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.raf$1.close();
                }
                {
                    this.raf$1 = raf$1;
                }
            }));
            this.mmap = idx;
        }
        catch (Throwable throwable) {
            void var6_5;
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
        this.kafka$log$AbstractIndex$$_maxEntries = this.mmap().limit() / this.entrySize();
        this._entries = this.mmap().position() / this.entrySize();
    }
}

