/*
 * Decompiled with CFR 0.152.
 */
package kafka.consumer;

import kafka.api.FetchRequest$;
import kafka.api.FetchRequestBuilder;
import kafka.api.FetchResponsePartitionData;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionFetchInfo;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.common.ErrorMapping$;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerFetcherManager;
import kafka.consumer.PartitionTopicInfo;
import kafka.consumer.SimpleConsumer;
import kafka.message.ByteBufferMessageSet;
import kafka.server.AbstractFetcherThread;
import kafka.server.PartitionFetchState;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\rb\u0001B\u0001\u0003\u0001\u001d\u0011QcQ8ogVlWM\u001d$fi\u000eDWM\u001d+ie\u0016\fGM\u0003\u0002\u0004\t\u0005A1m\u001c8tk6,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0005\u0011\u0005%aQ\"\u0001\u0006\u000b\u0005-!\u0011AB:feZ,'/\u0003\u0002\u000e\u0015\t)\u0012IY:ue\u0006\u001cGOR3uG\",'\u000f\u00165sK\u0006$\u0007\u0002C\b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\t\u0002\t9\fW.\u001a\t\u0003#]q!AE\u000b\u000e\u0003MQ\u0011\u0001F\u0001\u0006g\u000e\fG.Y\u0005\u0003-M\ta\u0001\u0015:fI\u00164\u0017B\u0001\r\u001a\u0005\u0019\u0019FO]5oO*\u0011ac\u0005\u0005\t7\u0001\u0011)\u0019!C\u00019\u000511m\u001c8gS\u001e,\u0012!\b\t\u0003=}i\u0011AA\u0005\u0003A\t\u0011abQ8ogVlWM]\"p]\u001aLw\r\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tqa\u00197vgR,'/\u0003\u0002+O\tq!I]8lKJ,e\u000e\u001a)pS:$\b\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0019A\f'\u000f^5uS>tW*\u00199\u0011\t9\n4GP\u0007\u0002_)\u0011\u0001gE\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u001a0\u0005\ri\u0015\r\u001d\t\u0003iqj\u0011!\u000e\u0006\u0003m]\naaY8n[>t'BA\u00039\u0015\tI$(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002w\u0005\u0019qN]4\n\u0005u*$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0003=}J!\u0001\u0011\u0002\u0003%A\u000b'\u000f^5uS>tGk\u001c9jG&sgm\u001c\u0005\t\u0005\u0002\u0011)\u0019!C\u0001\u0007\u000612m\u001c8tk6,'OR3uG\",'/T1oC\u001e,'/F\u0001E!\tqR)\u0003\u0002G\u0005\t12i\u001c8tk6,'OR3uG\",'/T1oC\u001e,'\u000f\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003E\u0003]\u0019wN\\:v[\u0016\u0014h)\u001a;dQ\u0016\u0014X*\u00198bO\u0016\u0014\b\u0005C\u0003K\u0001\u0011\u00051*\u0001\u0004=S:LGO\u0010\u000b\u0007\u00196su\nU)\u0011\u0005y\u0001\u0001\"B\bJ\u0001\u0004\u0001\u0002\"B\u000eJ\u0001\u0004i\u0002\"\u0002\u0013J\u0001\u0004)\u0003\"\u0002\u0017J\u0001\u0004i\u0003\"\u0002\"J\u0001\u0004!U\u0001B*\u0001\u0001Q\u00131AU#R!\t)\u0006M\u0004\u0002\u001f-\u001e)qK\u0001E\u00011\u0006)2i\u001c8tk6,'OR3uG\",'\u000f\u00165sK\u0006$\u0007C\u0001\u0010Z\r\u0015\t!\u0001#\u0001['\tI6\f\u0005\u0002\u00139&\u0011Ql\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b)KF\u0011A0\u0015\u0003a3A!Y-\u0001E\naa)\u001a;dQJ+\u0017/^3tiN\u0019\u0001mW2\u0011\u0005\u0011<gBA\u0005f\u0013\t1'\"A\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\n\u0005\u0005D'B\u00014\u000b\u0011!Q\u0007M!b\u0001\n\u0003Y\u0017AC;oI\u0016\u0014H._5oOV\tA\u000e\u0005\u0002na6\taN\u0003\u0002p\t\u0005\u0019\u0011\r]5\n\u0005\u0005t\u0007\u0002\u0003:a\u0005\u0003\u0005\u000b\u0011\u00027\u0002\u0017UtG-\u001a:ms&tw\r\t\u0005\u0006\u0015\u0002$\t\u0001\u001e\u000b\u0003k^\u0004\"A\u001e1\u000e\u0003eCQA[:A\u00021D\u0001\"\u001f1\t\u0006\u0004%IA_\u0001\u000biB$vn\u00144gg\u0016$X#A>\u0011\t9\n4\u0007 \t\u0003%uL!A`\n\u0003\t1{gn\u001a\u0005\n\u0003\u0003\u0001\u0007\u0012!Q!\nm\f1\u0002\u001e9U_>3gm]3uA!9\u0011Q\u00011\u0005\u0002\u0005\u001d\u0011aB5t\u000b6\u0004H/_\u000b\u0003\u0003\u0013\u00012AEA\u0006\u0013\r\tia\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0002\u0019C\u0001\u0003'\taa\u001c4gg\u0016$Hc\u0001?\u0002\u0016!9\u0011qCA\b\u0001\u0004\u0019\u0014A\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0004\u0007\u00037I\u0006!!\b\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b'\u0015\tIbWA\u0010!\r!\u0017\u0011E\u0005\u0004\u00037A\u0007B\u00036\u0002\u001a\t\u0015\r\u0011\"\u0001\u0002&U\u0011\u0011q\u0005\t\u0004[\u0006%\u0012bAA\u0016]\nQb)\u001a;dQJ+7\u000f]8og\u0016\u0004\u0016M\u001d;ji&|g\u000eR1uC\"Q!/!\u0007\u0003\u0002\u0003\u0006I!a\n\t\u000f)\u000bI\u0002\"\u0001\u00022Q!\u00111GA\u001b!\r1\u0018\u0011\u0004\u0005\bU\u0006=\u0002\u0019AA\u0014\u0011!\tI$!\u0007\u0005\u0002\u0005m\u0012!C3se>\u00148i\u001c3f+\t\ti\u0004E\u0002\u0013\u0003\u007fI1!!\u0011\u0014\u0005\u0015\u0019\u0006n\u001c:u\u0011!\t)%!\u0007\u0005\u0002\u0005\u001d\u0013!\u0003;p%\u0016\u001cwN\u001d3t+\t\tI\u0005\u0005\u0003\u0002L\u0005ESBAA'\u0015\r\ty%N\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005M\u0013Q\n\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u0011\u0005]\u0013\u0011\u0004C\u0001\u00033\nQ\u0002[5hQ^\u000bG/\u001a:nCJ\\W#\u0001?\t\u0011\u0005u\u0013\u0011\u0004C\u0001\u0003?\n\u0011\"\u001a=dKB$\u0018n\u001c8\u0016\u0005\u0005\u0005\u0004#\u0002\n\u0002d\u0005\u001d\u0014bAA3'\t1q\n\u001d;j_:\u0004B!!\u001b\u0002z9!\u00111NA;\u001d\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9\r\u00051AH]8pizJ\u0011\u0001F\u0005\u0004\u0003o\u001a\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003w\niHA\u0005UQJ|w/\u00192mK*\u0019\u0011qO\n\u0006\r\u0005\u0005\u0005\u0001AAB\u0005\t\u0001F\tE\u0002V\u00033A\u0011\"a\"\u0001\u0005\u0004%I!!#\u0002\u0011\rd\u0017.\u001a8u\u0013\u0012,\u0012\u0001\u0005\u0005\b\u0003\u001b\u0003\u0001\u0015!\u0003\u0011\u0003%\u0019G.[3oi&#\u0007\u0005C\u0005\u0002\u0012\u0002\u0011\r\u0011\"\u0003\u0002\u0014\u0006Ia-\u001a;dQNK'0Z\u000b\u0003\u0003+\u00032AEAL\u0013\r\tIj\u0005\u0002\u0004\u0013:$\b\u0002CAO\u0001\u0001\u0006I!!&\u0002\u0015\u0019,Go\u00195TSj,\u0007\u0005C\u0005\u0002\"\u0002\u0011\r\u0011\"\u0003\u0002$\u0006q1/[7qY\u0016\u001cuN\\:v[\u0016\u0014XCAAS!\rq\u0012qU\u0005\u0004\u0003S\u0013!AD*j[BdWmQ8ogVlWM\u001d\u0005\t\u0003[\u0003\u0001\u0015!\u0003\u0002&\u0006y1/[7qY\u0016\u001cuN\\:v[\u0016\u0014\b\u0005C\u0005\u00022\u0002\u0011\r\u0011\"\u0003\u00024\u0006\u0019b-\u001a;dQJ+\u0017/^3ti\n+\u0018\u000e\u001c3feV\u0011\u0011Q\u0017\t\u0004[\u0006]\u0016bAA]]\n\u0019b)\u001a;dQJ+\u0017/^3ti\n+\u0018\u000e\u001c3fe\"A\u0011Q\u0018\u0001!\u0002\u0013\t),\u0001\u000bgKR\u001c\u0007NU3rk\u0016\u001cHOQ;jY\u0012,'\u000f\t\u0005\b\u0003\u0003\u0004A\u0011IAb\u0003AIg.\u001b;jCR,7\u000b[;uI><h\u000e\u0006\u0002\u0002\n!9\u0011q\u0019\u0001\u0005B\u0005%\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005-\u0007c\u0001\n\u0002N&\u0019\u0011qZ\n\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003'\u0004A\u0011AAk\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCRA\u00111ZAl\u00033\fi\u000eC\u0004\u0002\u0018\u0005E\u0007\u0019A\u001a\t\u000f\u0005m\u0017\u0011\u001ba\u0001y\u0006Ya-\u001a;dQ>3gm]3u\u0011!\ty.!5A\u0002\u0005\r\u0015!\u00049beRLG/[8o\t\u0006$\u0018\rC\u0004\u0002d\u0002!\t!!:\u0002-!\fg\u000e\u001a7f\u001f\u001a47/\u001a;PkR|eMU1oO\u0016$2\u0001`At\u0011\u001d\t9\"!9A\u0002MBq!a;\u0001\t\u0003\ti/\u0001\u000eiC:$G.\u001a)beRLG/[8og^KG\u000f[#se>\u00148\u000f\u0006\u0003\u0002L\u0006=\b\u0002CAy\u0003S\u0004\r!a=\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003\u0002j\u0005U8'\u0003\u0003\u0002x\u0006u$\u0001C%uKJ\f'\r\\3\t\u000f\u0005m\b\u0001\"\u0005\u0002~\u0006\t\"-^5mI\u001a+Go\u00195SKF,Xm\u001d;\u0015\u0007Q\u000by\u0010C\u0004-\u0003s\u0004\rA!\u0001\u0011\u000b9\u0012\u0019Aa\u0002\n\u0007\t\u0015qFA\u0002TKF\u0004bA\u0005B\u0005g\t5\u0011b\u0001B\u0006'\t1A+\u001e9mKJ\u00022!\u0003B\b\u0013\r\u0011\tB\u0003\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/\u001a\u0005\b\u0005+\u0001A\u0011\u0003B\f\u0003\u00151W\r^2i)\u0011\u0011IBa\b\u0011\r\u0005%$1\u0004B\u000f\u0013\u0011\u0011)!! \u0011\rI\u0011IaMAB\u0011\u001d\u0011\tCa\u0005A\u0002Q\u000bABZ3uG\"\u0014V-];fgR\u0004")
public class ConsumerFetcherThread
extends AbstractFetcherThread {
    private final ConsumerConfig config;
    private final Map<TopicPartition, PartitionTopicInfo> partitionMap;
    private final ConsumerFetcherManager consumerFetcherManager;
    private final String clientId;
    private final int kafka$consumer$ConsumerFetcherThread$$fetchSize;
    private final SimpleConsumer simpleConsumer;
    private final FetchRequestBuilder kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder;

    public ConsumerConfig config() {
        return this.config;
    }

    public ConsumerFetcherManager consumerFetcherManager() {
        return this.consumerFetcherManager;
    }

    private String clientId() {
        return this.clientId;
    }

    public int kafka$consumer$ConsumerFetcherThread$$fetchSize() {
        return this.kafka$consumer$ConsumerFetcherThread$$fetchSize;
    }

    private SimpleConsumer simpleConsumer() {
        return this.simpleConsumer;
    }

    public FetchRequestBuilder kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder() {
        return this.kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean initiateShutdown() {
        void var1_1;
        boolean justShutdown = super.initiateShutdown();
        if (justShutdown && this.isInterruptible()) {
            this.simpleConsumer().disconnectToHandleJavaIOBug();
        }
        return (boolean)var1_1;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.simpleConsumer().close();
    }

    public void processPartitionData(TopicPartition topicPartition, long fetchOffset, PartitionData partitionData) {
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicPartition);
        if (pti.getFetchOffset() != fetchOffset) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString("Offset doesn't match for partition [%s,%d] pti offset: %d fetch offset: %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topicPartition.topic(), BoxesRunTime.boxToInteger(topicPartition.partition()), BoxesRunTime.boxToLong(pti.getFetchOffset()), BoxesRunTime.boxToLong(fetchOffset)})));
        }
        pti.enqueue((ByteBufferMessageSet)partitionData.underlying().messages());
    }

    @Override
    public long handleOffsetOutOfRange(TopicPartition topicPartition) {
        long l;
        String string2 = this.config().autoOffsetReset();
        String string3 = OffsetRequest$.MODULE$.SmallestTimeString();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            l = OffsetRequest$.MODULE$.EarliestTime();
        } else {
            String string5 = OffsetRequest$.MODULE$.LargestTimeString();
            String string6 = string2;
            l = !(string5 != null ? !string5.equals(string6) : string6 != null) ? OffsetRequest$.MODULE$.LatestTime() : OffsetRequest$.MODULE$.LatestTime();
        }
        long startTimestamp = l;
        TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartition.topic(), topicPartition.partition());
        long newOffset = this.simpleConsumer().earliestOrLatestOffset(topicAndPartition, startTimestamp, Request$.MODULE$.OrdinaryConsumerId());
        PartitionTopicInfo pti = (PartitionTopicInfo)this.partitionMap.apply(topicPartition);
        pti.resetFetchOffset(newOffset);
        pti.resetConsumeOffset(newOffset);
        return newOffset;
    }

    @Override
    public void handlePartitionsWithErrors(Iterable<TopicPartition> partitions) {
        this.removePartitions(partitions.toSet());
        this.consumerFetcherManager().addPartitionsWithError(partitions);
    }

    @Override
    public FetchRequest buildFetchRequest(Seq<Tuple2<TopicPartition, PartitionFetchState>> partitionMap) {
        partitionMap.foreach(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ConsumerFetcherThread $outer;

            public final Object apply(Tuple2<TopicPartition, PartitionFetchState> x0$1) {
                Tuple2<TopicPartition, PartitionFetchState> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicPartition topicPartition = tuple2._1();
                    PartitionFetchState partitionFetchState = tuple2._2();
                    BoxedUnit boxedUnit = partitionFetchState.isActive() ? this.$outer.kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder().addFetch(topicPartition.topic(), topicPartition.partition(), partitionFetchState.offset(), this.$outer.kafka$consumer$ConsumerFetcherThread$$fetchSize()) : BoxedUnit.UNIT;
                    return boxedUnit;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        return new FetchRequest(this.kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder().build());
    }

    public Seq<Tuple2<TopicPartition, PartitionData>> fetch(FetchRequest fetchRequest) {
        return this.simpleConsumer().fetch(fetchRequest.underlying()).data().map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicPartition, PartitionData> apply(Tuple2<TopicAndPartition, FetchResponsePartitionData> x0$2) {
                Tuple2<TopicAndPartition, FetchResponsePartitionData> tuple2 = x0$2;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = tuple2._1();
                    FetchResponsePartitionData value2 = tuple2._2();
                    if (topicAndPartition != null) {
                        String t = topicAndPartition.topic();
                        int p = topicAndPartition.partition();
                        Tuple2<TopicPartition, PartitionData> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(t, p)), new PartitionData(value2));
                        return tuple22;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public ConsumerFetcherThread(String name, ConsumerConfig config, BrokerEndPoint sourceBroker, Map<TopicPartition, PartitionTopicInfo> partitionMap, ConsumerFetcherManager consumerFetcherManager) {
        this.config = config;
        this.partitionMap = partitionMap;
        this.consumerFetcherManager = consumerFetcherManager;
        super(name, config.clientId(), sourceBroker, config.refreshLeaderBackoffMs(), true);
        this.clientId = config.clientId();
        this.kafka$consumer$ConsumerFetcherThread$$fetchSize = config.fetchMessageMaxBytes();
        this.simpleConsumer = new SimpleConsumer(sourceBroker.host(), sourceBroker.port(), config.socketTimeoutMs(), config.socketReceiveBufferBytes(), config.clientId());
        this.kafka$consumer$ConsumerFetcherThread$$fetchRequestBuilder = new FetchRequestBuilder().clientId(this.clientId()).replicaId(Request$.MODULE$.OrdinaryConsumerId()).maxWait(config.fetchWaitMaxMs()).minBytes(config.fetchMinBytes()).requestVersion(FetchRequest$.MODULE$.CurrentVersion());
    }

    public static class FetchRequest
    implements AbstractFetcherThread.FetchRequest {
        private final kafka.api.FetchRequest underlying;
        private Map<TopicPartition, Object> tpToOffset;
        private volatile boolean bitmap$0;

        private Map tpToOffset$lzycompute() {
            FetchRequest fetchRequest = this;
            synchronized (fetchRequest) {
                if (!this.bitmap$0) {
                    this.tpToOffset = ((TraversableOnce)this.underlying().requestInfo().map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<TopicPartition, Object> apply(Tuple2<TopicAndPartition, PartitionFetchInfo> x0$3) {
                            Tuple2<TopicAndPartition, PartitionFetchInfo> tuple2 = x0$3;
                            if (tuple2 != null) {
                                TopicAndPartition tp = tuple2._1();
                                PartitionFetchInfo fetchInfo = tuple2._2();
                                Tuple2<TopicPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new TopicPartition(tp.topic(), tp.partition())), BoxesRunTime.boxToLong(fetchInfo.offset()));
                                return tuple22;
                            }
                            throw new MatchError(tuple2);
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    this.bitmap$0 = true;
                }
                return this.tpToOffset;
            }
        }

        public kafka.api.FetchRequest underlying() {
            return this.underlying;
        }

        private Map<TopicPartition, Object> tpToOffset() {
            return this.bitmap$0 ? this.tpToOffset : this.tpToOffset$lzycompute();
        }

        @Override
        public boolean isEmpty() {
            return this.underlying().requestInfo().isEmpty();
        }

        @Override
        public long offset(TopicPartition topicPartition) {
            return BoxesRunTime.unboxToLong(this.tpToOffset().apply(topicPartition));
        }

        public FetchRequest(kafka.api.FetchRequest underlying) {
            this.underlying = underlying;
        }
    }

    public static class PartitionData
    implements AbstractFetcherThread.PartitionData {
        private final FetchResponsePartitionData underlying;

        public FetchResponsePartitionData underlying() {
            return this.underlying;
        }

        @Override
        public short errorCode() {
            return this.underlying().error();
        }

        @Override
        public MemoryRecords toRecords() {
            return ((ByteBufferMessageSet)this.underlying().messages()).asRecords();
        }

        @Override
        public long highWatermark() {
            return this.underlying().hw();
        }

        @Override
        public Option<Throwable> exception() {
            return this.errorCode() == ErrorMapping$.MODULE$.NoError() ? None$.MODULE$ : new Some<Throwable>(ErrorMapping$.MODULE$.exceptionFor(this.errorCode()));
        }

        public PartitionData(FetchResponsePartitionData underlying) {
            this.underlying = underlying;
        }
    }
}

