/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.cluster.EndPoint$;
import kafka.common.BrokerNotAvailableException;
import kafka.common.KafkaException;
import kafka.utils.Json$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;
    private final String HostKey;
    private final String PortKey;
    private final String VersionKey;
    private final String EndpointsKey;
    private final String kafka$cluster$Broker$$RackKey;
    private final String JmxPortKey;
    private final String ListenerSecurityProtocolMapKey;
    private final String TimestampKey;

    static {
        new Broker$();
    }

    private String HostKey() {
        return this.HostKey;
    }

    private String PortKey() {
        return this.PortKey;
    }

    private String VersionKey() {
        return this.VersionKey;
    }

    private String EndpointsKey() {
        return this.EndpointsKey;
    }

    public String kafka$cluster$Broker$$RackKey() {
        return this.kafka$cluster$Broker$$RackKey;
    }

    private String JmxPortKey() {
        return this.JmxPortKey;
    }

    private String ListenerSecurityProtocolMapKey() {
        return this.ListenerSecurityProtocolMapKey;
    }

    private String TimestampKey() {
        return this.TimestampKey;
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                Seq seq;
                Some some = (Some)option;
                Object m = some.x();
                Map brokerInfo = (Map)m;
                int version = BoxesRunTime.unboxToInt(brokerInfo.apply(this.VersionKey()));
                if (version < 1) {
                    throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply(this.HostKey());
                    int port = BoxesRunTime.unboxToInt(brokerInfo.apply(this.PortKey()));
                    SecurityProtocol securityProtocol2 = SecurityProtocol.PLAINTEXT;
                    EndPoint endPoint = new EndPoint(host, port, ListenerName.forSecurityProtocol(securityProtocol2), securityProtocol2);
                    seq = (Seq)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endPoint}));
                } else {
                    Option<Map<ListenerName, SecurityProtocol>> securityProtocolMap = brokerInfo.get(this.ListenerSecurityProtocolMapKey()).map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Map<ListenerName, SecurityProtocol> apply(Object x$1) {
                            return ((Map)x$1).map(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<ListenerName, SecurityProtocol> apply(Tuple2<String, String> x0$1) {
                                    Tuple2<String, String> tuple2 = x0$1;
                                    if (tuple2 != null) {
                                        String listenerName = tuple2._1();
                                        String securityProtocol2 = tuple2._2();
                                        Tuple2<ListenerName, SecurityProtocol> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(new ListenerName(listenerName)), SecurityProtocol.forName(securityProtocol2));
                                        return tuple22;
                                    }
                                    throw new MatchError(tuple2);
                                }
                            }, Map$.MODULE$.canBuildFrom());
                        }
                    });
                    List listeners = (List)brokerInfo.apply(this.EndpointsKey());
                    seq = listeners.map(new Serializable(securityProtocolMap){
                        public static final long serialVersionUID = 0L;
                        private final Option securityProtocolMap$1;

                        public final EndPoint apply(String x$2) {
                            return EndPoint$.MODULE$.createEndPoint(x$2, this.securityProtocolMap$1);
                        }
                        {
                            this.securityProtocolMap$1 = securityProtocolMap$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                }
                Seq endpoints = seq;
                Option<String> rack = brokerInfo.get(this.kafka$cluster$Broker$$RackKey()).filter(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$3) {
                        return x$3 != null;
                    }
                }).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$4) {
                        return (String)x$4;
                    }
                });
                Broker broker = new Broker(id, endpoints, rack);
                return broker;
            }
            if (None$.MODULE$.equals(option)) {
                throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})), throwable);
        }
    }

    public String toJson(int version, int id, String host, int port, Seq<EndPoint> advertisedEndpoints, int jmxPort, Option<String> rack) {
        scala.collection.mutable.Map jsonMap = (scala.collection.mutable.Map)scala.collection.mutable.Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.VersionKey()), BoxesRunTime.boxToInteger(version)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.HostKey()), host), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.PortKey()), BoxesRunTime.boxToInteger(port)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.EndpointsKey()), ((TraversableOnce)advertisedEndpoints.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(EndPoint x$5) {
                return x$5.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.JmxPortKey()), BoxesRunTime.boxToInteger(jmxPort)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.TimestampKey()), ((Object)BoxesRunTime.boxToLong(Time.SYSTEM.milliseconds())).toString())}));
        rack.foreach(new Serializable(version, jsonMap){
            public static final long serialVersionUID = 0L;
            private final int version$1;
            private final scala.collection.mutable.Map jsonMap$1;

            public final Object apply(String rack) {
                return this.version$1 >= 3 ? this.jsonMap$1.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Broker$.MODULE$.kafka$cluster$Broker$$RackKey()), rack)) : BoxedUnit.UNIT;
            }
            {
                this.version$1 = version$1;
                this.jsonMap$1 = jsonMap$1;
            }
        });
        Object object = version >= 4 ? jsonMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.ListenerSecurityProtocolMapKey()), ((TraversableOnce)advertisedEndpoints.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(EndPoint endPoint) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(endPoint.listenerName().value()), endPoint.securityProtocol().name);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()))) : BoxedUnit.UNIT;
        return Json$.MODULE$.encode(jsonMap);
    }

    public Broker apply(int id, Seq<EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Seq<EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, Seq<EndPoint>, Option<String>>>(new Tuple3<Integer, Seq<EndPoint>, Option<String>>(BoxesRunTime.boxToInteger(x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
        this.HostKey = "host";
        this.PortKey = "port";
        this.VersionKey = "version";
        this.EndpointsKey = "endpoints";
        this.kafka$cluster$Broker$$RackKey = "rack";
        this.JmxPortKey = "jmx_port";
        this.ListenerSecurityProtocolMapKey = "listener_security_protocol_map";
        this.TimestampKey = "timestamp";
    }
}

