/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import org.bson.BsonDocument;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonValue;

final class IndexHelper {
    static String generateIndexName(BsonDocument index2) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index2.keySet()) {
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            BsonValue ascOrDescValue = index2.get(keyNames);
            if (ascOrDescValue instanceof BsonNumber) {
                indexName.append(((BsonNumber)ascOrDescValue).intValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName.toString();
    }

    private IndexHelper() {
    }
}

