/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.QueryBatchCursor;
import com.mongodb.operation.ReadOperation;
import org.bson.BsonDocument;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.codecs.Decoder;

public class GroupOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonJavaScript reduceFunction;
    private final BsonDocument initial;
    private BsonDocument key;
    private BsonJavaScript keyFunction;
    private BsonDocument filter;
    private BsonJavaScript finalizeFunction;

    public GroupOperation(MongoNamespace namespace, BsonJavaScript reduceFunction, BsonDocument initial, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.initial = Assertions.notNull("initial", initial);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getKey() {
        return this.key;
    }

    public GroupOperation<T> key(BsonDocument key) {
        this.key = key;
        return this;
    }

    public BsonJavaScript getKeyFunction() {
        return this.keyFunction;
    }

    public GroupOperation<T> keyFunction(BsonJavaScript keyFunction) {
        this.keyFunction = keyFunction;
        return this;
    }

    public BsonDocument getInitial() {
        return this.initial;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public GroupOperation<T> filter(BsonDocument filter2) {
        this.filter = filter2;
        return this;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public GroupOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    @Override
    public BatchCursor<T> execute(final ReadBinding binding) {
        return (BatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<BatchCursor<T>>(){

            @Override
            public BatchCursor<T> call(ConnectionSource connectionSource, Connection connection) {
                return (BatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(binding, GroupOperation.this.namespace.getDatabaseName(), GroupOperation.this.getCommand(), CommandResultDocumentCodec.create(GroupOperation.this.decoder, "retval"), connection, GroupOperation.this.transformer(connectionSource, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<AsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, GroupOperation.this.namespace.getDatabaseName(), GroupOperation.this.getCommand(), CommandResultDocumentCodec.create(GroupOperation.this.decoder, "retval"), connection, GroupOperation.this.asyncTransformer(connection), OperationHelper.releasingCallback(errHandlingCallback, connection));
                }
            }
        });
    }

    private BsonDocument getCommand() {
        BsonDocument document = new BsonDocument("ns", new BsonString(this.namespace.getCollectionName()));
        if (this.getKey() != null) {
            document.put("key", this.getKey());
        } else if (this.getKeyFunction() != null) {
            document.put("$keyf", this.getKeyFunction());
        }
        document.put("initial", this.getInitial());
        document.put("$reduce", this.getReduceFunction());
        if (this.getFinalizeFunction() != null) {
            document.put("finalize", this.getFinalizeFunction());
        }
        if (this.getFilter() != null) {
            document.put("cond", this.getFilter());
        }
        return new BsonDocument("group", document);
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, BatchCursor<T>>(){

            @Override
            public BatchCursor<T> apply(BsonDocument result2, ServerAddress serverAddress) {
                return new QueryBatchCursor(GroupOperation.this.createQueryResult(result2, connection.getDescription()), 0, 0, GroupOperation.this.decoder, source);
            }
        };
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>> asyncTransformer(final AsyncConnection connection) {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, AsyncBatchCursor<T>>(){

            @Override
            public AsyncBatchCursor<T> apply(BsonDocument result2, ServerAddress serverAddress) {
                return new AsyncQueryBatchCursor(GroupOperation.this.createQueryResult(result2, connection.getDescription()), 0, 0, GroupOperation.this.decoder);
            }
        };
    }

    private QueryResult<T> createQueryResult(BsonDocument result2, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result2, "retval"), 0L, description.getServerAddress());
    }
}

