/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.connection.BufferProvider;
import com.mongodb.internal.connection.ConcurrentPool;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.Map;
import org.bson.ByteBuf;
import org.bson.ByteBufNIO;

public class PowerOfTwoBufferPool
implements BufferProvider {
    private final Map<Integer, ConcurrentPool<ByteBuffer>> powerOfTwoToPoolMap = new HashMap<Integer, ConcurrentPool<ByteBuffer>>();

    public PowerOfTwoBufferPool() {
        this(24);
    }

    public PowerOfTwoBufferPool(int highestPowerOfTwo) {
        int powerOfTwo = 1;
        for (int i = 0; i <= highestPowerOfTwo; ++i) {
            final int size2 = powerOfTwo;
            this.powerOfTwoToPoolMap.put(i, new ConcurrentPool<ByteBuffer>(Integer.MAX_VALUE, new ConcurrentPool.ItemFactory<ByteBuffer>(){

                @Override
                public ByteBuffer create(boolean initialize2) {
                    return PowerOfTwoBufferPool.this.createNew(size2);
                }

                @Override
                public void close(ByteBuffer byteBuffer) {
                }

                @Override
                public boolean shouldPrune(ByteBuffer byteBuffer) {
                    return false;
                }
            }));
            powerOfTwo <<= 1;
        }
    }

    @Override
    public ByteBuf getBuffer(int size2) {
        ConcurrentPool<ByteBuffer> pool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(size2)));
        ByteBuffer byteBuffer = pool == null ? this.createNew(size2) : pool.get();
        byteBuffer.clear();
        byteBuffer.limit(size2);
        return new PooledByteBufNIO(byteBuffer);
    }

    private ByteBuffer createNew(int size2) {
        ByteBuffer buf = ByteBuffer.allocate(size2);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf;
    }

    private void release(ByteBuffer buffer) {
        ConcurrentPool<ByteBuffer> pool = this.powerOfTwoToPoolMap.get(PowerOfTwoBufferPool.log2(PowerOfTwoBufferPool.roundUpToNextHighestPowerOfTwo(buffer.capacity())));
        if (pool != null) {
            pool.release(buffer);
        }
    }

    static int log2(int powerOfTwo) {
        return 31 - Integer.numberOfLeadingZeros(powerOfTwo);
    }

    static int roundUpToNextHighestPowerOfTwo(int size2) {
        int v = size2;
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return ++v;
    }

    private class PooledByteBufNIO
    extends ByteBufNIO {
        public PooledByteBufNIO(ByteBuffer buf) {
            super(buf);
        }

        @Override
        public void release() {
            ByteBuffer wrapped = this.asNIO();
            super.release();
            if (this.getReferenceCount() == 0) {
                PowerOfTwoBufferPool.this.release(wrapped);
            }
        }
    }
}

