/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.BaseWriteCommandMessage;
import com.mongodb.connection.BulkWriteBatchCombiner;
import com.mongodb.connection.ByteBufBsonDocument;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CommandResultCallback;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.RequestMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.connection.WriteCommandResultHelper;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.event.CommandListener;
import com.mongodb.internal.connection.IndexMap;
import org.bson.BsonDocument;
import org.bson.codecs.BsonDocumentCodec;

abstract class WriteCommandProtocol
implements Protocol<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final boolean ordered;
    private final WriteConcern writeConcern;
    private final Boolean bypassDocumentValidation;
    private CommandListener commandListener;

    public WriteCommandProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation) {
        this.namespace = namespace;
        this.ordered = ordered;
        this.writeConcern = writeConcern;
        this.bypassDocumentValidation = bypassDocumentValidation;
    }

    @Override
    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    @Override
    public BulkWriteResult execute(InternalConnection connection) {
        BaseWriteCommandMessage message = this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription()));
        long startTimeNanos = System.nanoTime();
        try {
            BaseWriteCommandMessage nextMessage;
            BulkWriteBatchCombiner bulkWriteBatchCombiner = new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), this.ordered, this.writeConcern);
            int batchNum = 0;
            int currentRangeStartIndex = 0;
            do {
                startTimeNanos = System.nanoTime();
                int itemCount = (nextMessage = this.sendMessage(connection, message, ++batchNum)) != null ? message.getItemCount() - nextMessage.getItemCount() : message.getItemCount();
                IndexMap indexMap = IndexMap.create(currentRangeStartIndex, itemCount);
                BsonDocument result2 = this.receiveMessage(connection, message);
                if ((nextMessage != null || batchNum > 1) && this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Received response for batch %d", batchNum));
                }
                if (WriteCommandResultHelper.hasError(result2)) {
                    MongoBulkWriteException bulkWriteException = WriteCommandResultHelper.getBulkWriteException(this.getType(), result2, connection.getDescription().getServerAddress());
                    bulkWriteBatchCombiner.addErrorResult(bulkWriteException, indexMap);
                } else {
                    bulkWriteBatchCombiner.addResult(WriteCommandResultHelper.getBulkWriteResult(this.getType(), result2), indexMap);
                }
                this.sendSucceededEvent(connection, message, startTimeNanos, result2);
                currentRangeStartIndex += itemCount;
            } while ((message = nextMessage) != null && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches());
            return bulkWriteBatchCombiner.getResult();
        }
        catch (MongoBulkWriteException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.sendFailedEvent(connection, message, startTimeNanos, e);
            throw e;
        }
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        this.executeBatchesAsync(connection, this.createRequestMessage(ProtocolHelper.getMessageSettings(connection.getDescription())), new BulkWriteBatchCombiner(connection.getDescription().getServerAddress(), this.ordered, this.writeConcern), 0, 0, callback);
    }

    private void executeBatchesAsync(final InternalConnection connection, final BaseWriteCommandMessage message, final BulkWriteBatchCombiner bulkWriteBatchCombiner, final int batchNum, int currentRangeStartIndex, final SingleResultCallback<BulkWriteResult> callback) {
        final long startTimeNanos = System.nanoTime();
        boolean sentStartedEvent = false;
        try {
            if (message != null && !bulkWriteBatchCombiner.shouldStopSendingMoreBatches()) {
                final ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
                RequestMessage.EncodingMetadata metadata = message.encodeWithMetadata(bsonOutput);
                this.sendStartedEvent(connection, message, bsonOutput, metadata);
                sentStartedEvent = true;
                final BaseWriteCommandMessage nextMessage = (BaseWriteCommandMessage)metadata.getNextMessage();
                int itemCount = nextMessage != null ? message.getItemCount() - nextMessage.getItemCount() : message.getItemCount();
                final IndexMap indexMap = IndexMap.create(currentRangeStartIndex, itemCount);
                final int nextBatchNum = batchNum + 1;
                final int nextRangeStartIndex = currentRangeStartIndex + itemCount;
                if (nextBatchNum > 1 && this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Asynchronously sending batch %d", batchNum));
                }
                this.sendMessageAsync(connection, bsonOutput, message, startTimeNanos, callback, new SingleResultCallback<BsonDocument>(){

                    @Override
                    public void onResult(BsonDocument result2, Throwable t) {
                        bsonOutput.close();
                        if (t != null) {
                            WriteCommandProtocol.this.sendFailedEvent(connection, message, startTimeNanos, t);
                            callback.onResult(null, t);
                        } else {
                            WriteCommandProtocol.this.sendSucceededEvent(connection, message, startTimeNanos, result2);
                            if (nextBatchNum > 1 && WriteCommandProtocol.this.getLogger().isDebugEnabled()) {
                                WriteCommandProtocol.this.getLogger().debug(String.format("Asynchronously received response for batch %d", batchNum));
                            }
                            if (WriteCommandResultHelper.hasError(result2)) {
                                bulkWriteBatchCombiner.addErrorResult(WriteCommandResultHelper.getBulkWriteException(WriteCommandProtocol.this.getType(), result2, connection.getDescription().getServerAddress()), indexMap);
                            } else {
                                bulkWriteBatchCombiner.addResult(WriteCommandResultHelper.getBulkWriteResult(WriteCommandProtocol.this.getType(), result2), indexMap);
                            }
                            WriteCommandProtocol.this.executeBatchesAsync(connection, nextMessage, bulkWriteBatchCombiner, nextBatchNum, nextRangeStartIndex, callback);
                        }
                    }
                });
            } else if (bulkWriteBatchCombiner.hasErrors()) {
                callback.onResult(null, bulkWriteBatchCombiner.getError());
            } else {
                callback.onResult(bulkWriteBatchCombiner.getResult(), null);
            }
        }
        catch (Throwable t) {
            if (sentStartedEvent) {
                this.sendFailedEvent(connection, message, startTimeNanos, t);
            }
            callback.onResult(null, t);
        }
    }

    protected abstract WriteRequest.Type getType();

    protected abstract BaseWriteCommandMessage createRequestMessage(MessageSettings var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BaseWriteCommandMessage sendMessage(InternalConnection connection, BaseWriteCommandMessage message, int batchNum) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            RequestMessage.EncodingMetadata encodingMetadata = message.encodeWithMetadata(bsonOutput);
            BaseWriteCommandMessage nextMessage = (BaseWriteCommandMessage)encodingMetadata.getNextMessage();
            this.sendStartedEvent(connection, message, bsonOutput, encodingMetadata);
            if ((nextMessage != null || batchNum > 1) && this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(String.format("Sending batch %d", batchNum));
            }
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            BaseWriteCommandMessage baseWriteCommandMessage = nextMessage;
            return baseWriteCommandMessage;
        }
        finally {
            bsonOutput.close();
        }
    }

    private void sendStartedEvent(InternalConnection connection, BaseWriteCommandMessage message, ByteBufferBsonOutput bsonOutput, RequestMessage.EncodingMetadata encodingMetadata) {
        if (this.commandListener != null) {
            ProtocolHelper.sendCommandStartedEvent(message, this.namespace.getDatabaseName(), message.getCommandName(), ByteBufBsonDocument.createOne(bsonOutput, encodingMetadata.getFirstDocumentPosition()), connection.getDescription(), this.commandListener);
        }
    }

    private void sendSucceededEvent(InternalConnection connection, BaseWriteCommandMessage message, long startTimeNanos, BsonDocument result2) {
        if (this.commandListener != null) {
            ProtocolHelper.sendCommandSucceededEvent(message, message.getCommandName(), result2, connection.getDescription(), startTimeNanos, this.commandListener);
        }
    }

    private void sendFailedEvent(InternalConnection connection, BaseWriteCommandMessage message, long startTimeNanos, Throwable t) {
        if (this.commandListener != null) {
            ProtocolHelper.sendCommandFailedEvent(message, message.getCommandName(), connection.getDescription(), startTimeNanos, t, this.commandListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonDocument receiveMessage(InternalConnection connection, RequestMessage message) {
        ResponseBuffers responseBuffers = connection.receiveMessage(message.getId());
        try {
            ReplyMessage<BsonDocument> replyMessage = new ReplyMessage<BsonDocument>(responseBuffers, new BsonDocumentCodec(), message.getId());
            BsonDocument result2 = replyMessage.getDocuments().get(0);
            if (!ProtocolHelper.isCommandOk(result2)) {
                throw ProtocolHelper.getCommandFailureException(result2, connection.getDescription().getServerAddress());
            }
            BsonDocument bsonDocument = result2;
            return bsonDocument;
        }
        finally {
            responseBuffers.close();
        }
    }

    private void sendMessageAsync(InternalConnection connection, ByteBufferBsonOutput buffer, BaseWriteCommandMessage message, long startTimeNanos, SingleResultCallback<BulkWriteResult> clientCallback, SingleResultCallback<BsonDocument> callback) {
        CommandResultCallback<BsonDocument> receiveCallback = new CommandResultCallback<BsonDocument>(callback, new BsonDocumentCodec(), message.getId(), connection.getDescription().getServerAddress());
        connection.sendMessageAsync(buffer.getByteBuffers(), message.getId(), new SendMessageCallback<BulkWriteResult>(connection, buffer, message, message.getCommandName(), startTimeNanos, this.commandListener, clientCallback, receiveCallback));
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    protected abstract Logger getLogger();

    protected boolean isOrdered() {
        return this.ordered;
    }
}

