/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.MongoInternalException;
import com.mongodb.annotations.Immutable;
import com.mongodb.annotations.NotThreadSafe;

@Immutable
public class SslSettings {
    private final boolean enabled;
    private final boolean invalidHostNameAllowed;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isInvalidHostNameAllowed() {
        return this.invalidHostNameAllowed;
    }

    SslSettings(Builder builder) {
        this.enabled = builder.enabled;
        this.invalidHostNameAllowed = builder.invalidHostNameAllowed;
        if (this.enabled && !this.invalidHostNameAllowed && System.getProperty("java.version").startsWith("1.6.")) {
            throw new MongoInternalException("By default, SSL connections are only supported on Java 7 or later.  If the application must run on Java 6, you must set the SslSettings.invalidHostNameAllowed property to false");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SslSettings that = (SslSettings)o;
        if (this.enabled != that.enabled) {
            return false;
        }
        return this.invalidHostNameAllowed == that.invalidHostNameAllowed;
    }

    public int hashCode() {
        int result2 = this.enabled ? 1 : 0;
        result2 = 31 * result2 + (this.invalidHostNameAllowed ? 1 : 0);
        return result2;
    }

    public String toString() {
        return "SslSettings{enabled=" + this.enabled + ", invalidHostNameAllowed=" + this.invalidHostNameAllowed + '}';
    }

    @NotThreadSafe
    public static class Builder {
        private boolean enabled;
        private boolean invalidHostNameAllowed;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder invalidHostNameAllowed(boolean invalidHostNameAllowed) {
            this.invalidHostNameAllowed = invalidHostNameAllowed;
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            if (connectionString.getSslEnabled() != null) {
                this.enabled = connectionString.getSslEnabled();
            }
            if (connectionString.getSslInvalidHostnameAllowed() != null) {
                this.invalidHostNameAllowed = connectionString.getSslInvalidHostnameAllowed();
            }
            return this;
        }

        public SslSettings build() {
            return new SslSettings(this);
        }
    }
}

