/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.MultiPolygon;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class MultiPolygonCodec
implements Codec<MultiPolygon> {
    private final CodecRegistry registry;

    public MultiPolygonCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(final BsonWriter writer, final MultiPolygon value2, EncoderContext encoderContext) {
        GeometryCodecHelper.encodeGeometry(writer, value2, encoderContext, this.registry, new Runnable(){

            @Override
            public void run() {
                writer.writeStartArray();
                for (PolygonCoordinates polygonCoordinates : value2.getCoordinates()) {
                    GeometryCodecHelper.encodePolygonCoordinates(writer, polygonCoordinates);
                }
                writer.writeEndArray();
            }
        });
    }

    @Override
    public Class<MultiPolygon> getEncoderClass() {
        return MultiPolygon.class;
    }

    @Override
    public MultiPolygon decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

