/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.LineString;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class LineStringCodec
implements Codec<LineString> {
    private final CodecRegistry registry;

    public LineStringCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(final BsonWriter writer, final LineString value2, EncoderContext encoderContext) {
        GeometryCodecHelper.encodeGeometry(writer, value2, encoderContext, this.registry, new Runnable(){

            @Override
            public void run() {
                writer.writeStartArray();
                for (Position position : value2.getCoordinates()) {
                    GeometryCodecHelper.encodePosition(writer, position);
                }
                writer.writeEndArray();
            }
        });
    }

    @Override
    public Class<LineString> getEncoderClass() {
        return LineString.class;
    }

    @Override
    public LineString decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

