/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.GeometryCollection;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class GeometryCollectionCodec
implements Codec<GeometryCollection> {
    private final CodecRegistry registry;

    public GeometryCollectionCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(BsonWriter writer, GeometryCollection value2, EncoderContext encoderContext) {
        writer.writeStartDocument();
        GeometryCodecHelper.encodeType(writer, value2);
        writer.writeName("geometries");
        writer.writeStartArray();
        for (Geometry geometry : value2.getGeometries()) {
            this.encodeGeometry(writer, geometry, encoderContext);
        }
        writer.writeEndArray();
        GeometryCodecHelper.encodeCoordinateReferenceSystem(writer, value2, encoderContext, this.registry);
        writer.writeEndDocument();
    }

    private void encodeGeometry(BsonWriter writer, Geometry geometry, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(geometry.getClass());
        encoderContext.encodeWithChildContext(codec, writer, geometry);
    }

    @Override
    public Class<GeometryCollection> getEncoderClass() {
        return GeometryCollection.class;
    }

    @Override
    public GeometryCollection decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

