/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.PolygonCoordinates;
import com.mongodb.client.model.geojson.Position;
import java.util.List;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

final class GeometryCodecHelper {
    static void encodeGeometry(BsonWriter writer, Geometry geometry, EncoderContext encoderContext, CodecRegistry registry, Runnable coordinatesEncoder) {
        writer.writeStartDocument();
        GeometryCodecHelper.encodeType(writer, geometry);
        writer.writeName("coordinates");
        coordinatesEncoder.run();
        GeometryCodecHelper.encodeCoordinateReferenceSystem(writer, geometry, encoderContext, registry);
        writer.writeEndDocument();
    }

    static void encodeType(BsonWriter writer, Geometry geometry) {
        writer.writeString("type", geometry.getType().getTypeName());
    }

    static void encodeCoordinateReferenceSystem(BsonWriter writer, Geometry geometry, EncoderContext encoderContext, CodecRegistry registry) {
        if (geometry.getCoordinateReferenceSystem() != null) {
            writer.writeName("crs");
            Codec<?> codec = registry.get(geometry.getCoordinateReferenceSystem().getClass());
            encoderContext.encodeWithChildContext(codec, writer, geometry.getCoordinateReferenceSystem());
        }
    }

    static void encodePolygonCoordinates(BsonWriter writer, PolygonCoordinates polygonCoordinates) {
        writer.writeStartArray();
        GeometryCodecHelper.encodeLinearRing(polygonCoordinates.getExterior(), writer);
        for (List<Position> ring : polygonCoordinates.getHoles()) {
            GeometryCodecHelper.encodeLinearRing(ring, writer);
        }
        writer.writeEndArray();
    }

    private static void encodeLinearRing(List<Position> ring, BsonWriter writer) {
        writer.writeStartArray();
        for (Position position : ring) {
            GeometryCodecHelper.encodePosition(writer, position);
        }
        writer.writeEndArray();
    }

    static void encodePosition(BsonWriter writer, Position value2) {
        writer.writeStartArray();
        for (double number2 : value2.getValues()) {
            writer.writeDouble(number2);
        }
        writer.writeEndArray();
    }

    private GeometryCodecHelper() {
    }
}

