/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.SimpleExpression;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Projections {
    private Projections() {
    }

    public static <TExpression> Bson computed(String fieldName, TExpression expression) {
        return new SimpleExpression<TExpression>(fieldName, expression);
    }

    public static Bson include(String ... fieldNames) {
        return Projections.include(Arrays.asList(fieldNames));
    }

    public static Bson include(List<String> fieldNames) {
        return Projections.combine(fieldNames, new BsonInt32(1));
    }

    public static Bson exclude(String ... fieldNames) {
        return Projections.exclude(Arrays.asList(fieldNames));
    }

    public static Bson exclude(List<String> fieldNames) {
        return Projections.combine(fieldNames, new BsonInt32(0));
    }

    public static Bson excludeId() {
        return new BsonDocument("_id", new BsonInt32(0));
    }

    public static Bson elemMatch(String fieldName) {
        return new BsonDocument(fieldName + ".$", new BsonInt32(1));
    }

    public static Bson elemMatch(String fieldName, Bson filter2) {
        return new ElemMatchFilterProjection(fieldName, filter2);
    }

    public static Bson metaTextScore(String fieldName) {
        return new BsonDocument(fieldName, new BsonDocument("$meta", new BsonString("textScore")));
    }

    public static Bson slice(String fieldName, int limit) {
        return new BsonDocument(fieldName, new BsonDocument("$slice", new BsonInt32(limit)));
    }

    public static Bson slice(String fieldName, int skip, int limit) {
        return new BsonDocument(fieldName, new BsonDocument("$slice", new BsonArray(Arrays.asList(new BsonInt32(skip), new BsonInt32(limit)))));
    }

    public static Bson fields(Bson ... projections) {
        return Projections.fields(Arrays.asList(projections));
    }

    public static Bson fields(List<Bson> projections) {
        Assertions.notNull("sorts", projections);
        return new FieldsProjection(projections);
    }

    private static Bson combine(List<String> fieldNames, BsonValue value2) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.remove(fieldName);
            document.append(fieldName, value2);
        }
        return document;
    }

    private static class ElemMatchFilterProjection
    implements Bson {
        private final String fieldName;
        private final Bson filter;

        public ElemMatchFilterProjection(String fieldName, Bson filter2) {
            this.fieldName = fieldName;
            this.filter = filter2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, new BsonDocument("$elemMatch", this.filter.toBsonDocument(documentClass, codecRegistry)));
        }

        public String toString() {
            return "ElemMatch Projection{fieldName='" + this.fieldName + '\'' + ", filter=" + this.filter + '}';
        }
    }

    private static class FieldsProjection
    implements Bson {
        private final List<Bson> projections;

        public FieldsProjection(List<Bson> projections) {
            this.projections = projections;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Bson sort : this.projections) {
                BsonDocument sortDocument = sort.toBsonDocument(documentClass, codecRegistry);
                for (String key : sortDocument.keySet()) {
                    combinedDocument.remove(key);
                    combinedDocument.append(key, sortDocument.get(key));
                }
            }
            return combinedDocument;
        }

        public String toString() {
            return "Projections{projections=" + this.projections + '}';
        }
    }
}

