/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.TextSearchOptions;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Point;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Filters {
    private Filters() {
    }

    public static <TItem> Bson eq(String fieldName, TItem value2) {
        return new SimpleEncodingFilter<TItem>(fieldName, value2);
    }

    public static <TItem> Bson ne(String fieldName, TItem value2) {
        return new OperatorFilter<TItem>("$ne", fieldName, value2);
    }

    public static <TItem> Bson gt(String fieldName, TItem value2) {
        return new OperatorFilter<TItem>("$gt", fieldName, value2);
    }

    public static <TItem> Bson lt(String fieldName, TItem value2) {
        return new OperatorFilter<TItem>("$lt", fieldName, value2);
    }

    public static <TItem> Bson gte(String fieldName, TItem value2) {
        return new OperatorFilter<TItem>("$gte", fieldName, value2);
    }

    public static <TItem> Bson lte(String fieldName, TItem value2) {
        return new OperatorFilter<TItem>("$lte", fieldName, value2);
    }

    public static <TItem> Bson in(String fieldName, TItem ... values) {
        return Filters.in(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson in(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$in", values);
    }

    public static <TItem> Bson nin(String fieldName, TItem ... values) {
        return Filters.nin(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson nin(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$nin", values);
    }

    public static Bson and(Iterable<Bson> filters) {
        return new AndFilter(filters);
    }

    public static Bson and(Bson ... filters) {
        return Filters.and(Arrays.asList(filters));
    }

    public static Bson or(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.OR, filters);
    }

    public static Bson or(Bson ... filters) {
        return Filters.or(Arrays.asList(filters));
    }

    public static Bson not(Bson filter2) {
        return new NotFilter(filter2);
    }

    public static Bson nor(Bson ... filters) {
        return Filters.nor(Arrays.asList(filters));
    }

    public static Bson nor(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.NOR, filters);
    }

    public static Bson exists(String fieldName) {
        return Filters.exists(fieldName, true);
    }

    public static Bson exists(String fieldName, boolean exists2) {
        return new OperatorFilter<BsonBoolean>("$exists", fieldName, BsonBoolean.valueOf(exists2));
    }

    public static Bson type(String fieldName, BsonType type) {
        return new OperatorFilter<BsonInt32>("$type", fieldName, new BsonInt32(type.getValue()));
    }

    public static Bson type(String fieldName, String type) {
        return new OperatorFilter<BsonString>("$type", fieldName, new BsonString(type));
    }

    public static Bson mod(String fieldName, long divisor, long remainder) {
        return new OperatorFilter<BsonArray>("$mod", fieldName, new BsonArray(Arrays.asList(new BsonInt64(divisor), new BsonInt64(remainder))));
    }

    public static Bson regex(String fieldName, String pattern) {
        return Filters.regex(fieldName, pattern, null);
    }

    public static Bson regex(String fieldName, String pattern, String options) {
        Assertions.notNull("pattern", pattern);
        return new SimpleFilter(fieldName, new BsonRegularExpression(pattern, options));
    }

    public static Bson regex(String fieldName, Pattern pattern) {
        Assertions.notNull("pattern", pattern);
        return new SimpleEncodingFilter<Pattern>(fieldName, pattern);
    }

    public static Bson text(String search) {
        Assertions.notNull("search", search);
        return Filters.text(search, new TextSearchOptions());
    }

    @Deprecated
    public static Bson text(String search, String language2) {
        Assertions.notNull("search", search);
        return Filters.text(search, new TextSearchOptions().language(language2));
    }

    public static Bson text(String search, TextSearchOptions textSearchOptions) {
        Assertions.notNull("search", search);
        Assertions.notNull("textSearchOptions", textSearchOptions);
        return new TextFilter(search, textSearchOptions);
    }

    public static Bson where(String javaScriptExpression) {
        Assertions.notNull("javaScriptExpression", javaScriptExpression);
        return new BsonDocument("$where", new BsonString(javaScriptExpression));
    }

    public static <TItem> Bson all(String fieldName, TItem ... values) {
        return Filters.all(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson all(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$all", values);
    }

    public static Bson elemMatch(final String fieldName, final Bson filter2) {
        return new Bson(){

            @Override
            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                return new BsonDocument(fieldName, new BsonDocument("$elemMatch", filter2.toBsonDocument(documentClass, codecRegistry)));
            }
        };
    }

    public static Bson size(String fieldName, int size2) {
        return new OperatorFilter<Integer>("$size", fieldName, size2);
    }

    public static Bson bitsAllClear(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllClear", fieldName, bitmask);
    }

    public static Bson bitsAllSet(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllSet", fieldName, bitmask);
    }

    public static Bson bitsAnyClear(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnyClear", fieldName, bitmask);
    }

    public static Bson bitsAnySet(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnySet", fieldName, bitmask);
    }

    public static Bson geoWithin(String fieldName, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoWithin", fieldName, geometry);
    }

    public static Bson geoWithin(String fieldName, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoWithin", fieldName, geometry);
    }

    public static Bson geoWithinBox(String fieldName, double lowerLeftX, double lowerLeftY, double upperRightX, double upperRightY) {
        BsonDocument box = new BsonDocument("$box", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(lowerLeftX), new BsonDouble(lowerLeftY))), new BsonArray(Arrays.asList(new BsonDouble(upperRightX), new BsonDouble(upperRightY))))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, box);
    }

    public static Bson geoWithinPolygon(String fieldName, List<List<Double>> points) {
        BsonArray pointsArray = new BsonArray();
        for (List<Double> point : points) {
            pointsArray.add(new BsonArray(Arrays.asList(new BsonDouble(point.get(0)), new BsonDouble(point.get(1)))));
        }
        BsonDocument polygon = new BsonDocument("$polygon", pointsArray);
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, polygon);
    }

    public static Bson geoWithinCenter(String fieldName, double x, double y, double radius) {
        BsonDocument center = new BsonDocument("$center", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, center);
    }

    public static Bson geoWithinCenterSphere(String fieldName, double x, double y, double radius) {
        BsonDocument centerSphere = new BsonDocument("$centerSphere", new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, centerSphere);
    }

    public static Bson geoIntersects(String fieldName, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoIntersects", fieldName, geometry);
    }

    public static Bson geoIntersects(String fieldName, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoIntersects", fieldName, geometry);
    }

    public static Bson near(String fieldName, Point geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Point>("$near", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName, Bson geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$near", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName, double x, double y, Double maxDistance, Double minDistance) {
        return Filters.createNearFilterDocument(fieldName, x, y, maxDistance, minDistance, "$near");
    }

    public static Bson nearSphere(String fieldName, Point geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Point>("$nearSphere", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName, Bson geometry, Double maxDistance, Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$nearSphere", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName, double x, double y, Double maxDistance, Double minDistance) {
        return Filters.createNearFilterDocument(fieldName, x, y, maxDistance, minDistance, "$nearSphere");
    }

    private static Bson createNearFilterDocument(String fieldName, double x, double y, Double maxDistance, Double minDistance, String operator) {
        BsonDocument nearFilter = new BsonDocument(operator, new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))));
        if (maxDistance != null) {
            nearFilter.append("$maxDistance", new BsonDouble(maxDistance));
        }
        if (minDistance != null) {
            nearFilter.append("$minDistance", new BsonDouble(minDistance));
        }
        return new BsonDocument(fieldName, nearFilter);
    }

    private static String operatorFilterToString(String fieldName, String operator, Object value2) {
        return "Operator Filter{fieldName='" + fieldName + '\'' + ", operator='" + operator + '\'' + ", value=" + value2 + '}';
    }

    private static class TextFilter
    implements Bson {
        private final String search;
        private final TextSearchOptions textSearchOptions;

        public TextFilter(String search, TextSearchOptions textSearchOptions) {
            this.search = search;
            this.textSearchOptions = textSearchOptions;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument searchDocument = new BsonDocument("$search", new BsonString(this.search));
            if (this.textSearchOptions.getLanguage() != null) {
                searchDocument.put("$language", new BsonString(this.textSearchOptions.getLanguage()));
            }
            if (this.textSearchOptions.getCaseSensitive() != null) {
                searchDocument.put("$caseSensitive", BsonBoolean.valueOf(this.textSearchOptions.getCaseSensitive()));
            }
            if (this.textSearchOptions.getDiacriticSensitive() != null) {
                searchDocument.put("$diacriticSensitive", BsonBoolean.valueOf(this.textSearchOptions.getDiacriticSensitive()));
            }
            return new BsonDocument("$text", searchDocument);
        }

        public String toString() {
            return "Text Filter{search='" + this.search + '\'' + ", textSearchOptions=" + this.textSearchOptions + '}';
        }
    }

    private static class GeometryOperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem geometry;
        private final Double maxDistance;
        private final Double minDistance;

        public GeometryOperatorFilter(String operatorName, String fieldName, TItem geometry) {
            this(operatorName, fieldName, geometry, null, null);
        }

        public GeometryOperatorFilter(String operatorName, String fieldName, TItem geometry, Double maxDistance, Double minDistance) {
            this.operatorName = operatorName;
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.geometry = Assertions.notNull("geometry", geometry);
            this.maxDistance = maxDistance;
            this.minDistance = minDistance;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            writer.writeStartDocument();
            writer.writeName("$geometry");
            BuildersHelper.encodeValue(writer, this.geometry, codecRegistry);
            if (this.maxDistance != null) {
                writer.writeDouble("$maxDistance", this.maxDistance);
            }
            if (this.minDistance != null) {
                writer.writeDouble("$minDistance", this.minDistance);
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Geometry Operator Filter{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operatorName + '\'' + ", geometry=" + this.geometry + ", maxDistance=" + this.maxDistance + ", minDistance=" + this.minDistance + '}';
        }
    }

    private static class NotFilter
    implements Bson {
        private final Bson filter;

        public NotFilter(Bson filter2) {
            this.filter = Assertions.notNull("filter", filter2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument filterDocument = this.filter.toBsonDocument(documentClass, codecRegistry);
            if (filterDocument.size() == 1) {
                Map.Entry<String, BsonValue> entry2 = filterDocument.entrySet().iterator().next();
                return this.createFilter(entry2.getKey(), entry2.getValue());
            }
            BsonArray values = new BsonArray();
            for (Map.Entry<String, BsonValue> docs : filterDocument.entrySet()) {
                values.add(new BsonDocument(docs.getKey(), docs.getValue()));
            }
            return this.createFilter("$and", values);
        }

        private BsonDocument createFilter(String fieldName, BsonValue value2) {
            if (fieldName.startsWith("$")) {
                return new BsonDocument("$not", new BsonDocument(fieldName, value2));
            }
            if (value2.isDocument() || value2.isRegularExpression()) {
                return new BsonDocument(fieldName, new BsonDocument("$not", value2));
            }
            return new BsonDocument(fieldName, new BsonDocument("$not", new BsonDocument("$eq", value2)));
        }

        public String toString() {
            return "Not Filter{filter=" + this.filter + '}';
        }
    }

    private static class SimpleEncodingFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;

        public SimpleEncodingFilter(String fieldName, TItem value2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return "Filter{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class IterableOperatorFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final String operatorName;
        private final Iterable<TItem> values;

        IterableOperatorFilter(String fieldName, String operatorName, Iterable<TItem> values) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.values = Assertions.notNull("values", values);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            writer.writeStartArray();
            for (TItem value2 : this.values) {
                BuildersHelper.encodeValue(writer, value2, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.values);
        }
    }

    private static class OrNorFilter
    implements Bson {
        private final Operator operator;
        private final Iterable<Bson> filters;

        public OrNorFilter(Operator operator, Iterable<Bson> filters) {
            this.operator = Assertions.notNull("operator", operator);
            this.filters = Assertions.notNull("filters", filters);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument orRenderable = new BsonDocument();
            BsonArray filtersArray = new BsonArray();
            for (Bson filter2 : this.filters) {
                filtersArray.add(filter2.toBsonDocument(documentClass, codecRegistry));
            }
            orRenderable.put(this.operator.name, filtersArray);
            return orRenderable;
        }

        public String toString() {
            return this.operator.toStringName + " Filter{" + "filters=" + this.filters + '}';
        }

        private static enum Operator {
            OR("$or", "Or"),
            NOR("$nor", "Nor");

            private final String name;
            private final String toStringName;

            private Operator(String name, String toStringName) {
                this.name = name;
                this.toStringName = toStringName;
            }
        }
    }

    private static class AndFilter
    implements Bson {
        private final Iterable<Bson> filters;

        public AndFilter(Iterable<Bson> filters) {
            this.filters = Assertions.notNull("filters", filters);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument andRenderable = new BsonDocument();
            for (Bson filter2 : this.filters) {
                BsonDocument renderedRenderable = filter2.toBsonDocument(documentClass, codecRegistry);
                for (Map.Entry<String, BsonValue> element : renderedRenderable.entrySet()) {
                    this.addClause(andRenderable, element);
                }
            }
            if (andRenderable.isEmpty()) {
                andRenderable.append("$and", new BsonArray());
            }
            return andRenderable;
        }

        private void addClause(BsonDocument document, Map.Entry<String, BsonValue> clause) {
            if (clause.getKey().equals("$and")) {
                for (BsonValue value2 : clause.getValue().asArray()) {
                    for (Map.Entry<String, BsonValue> element : value2.asDocument().entrySet()) {
                        this.addClause(document, element);
                    }
                }
            } else if (document.size() == 1 && document.keySet().iterator().next().equals("$and")) {
                document.get("$and").asArray().add(new BsonDocument(clause.getKey(), clause.getValue()));
            } else if (document.containsKey(clause.getKey())) {
                if (document.get(clause.getKey()).isDocument() && clause.getValue().isDocument()) {
                    BsonDocument existingClauseValue = document.get(clause.getKey()).asDocument();
                    BsonDocument clauseValue = clause.getValue().asDocument();
                    if (this.keysIntersect(clauseValue, existingClauseValue)) {
                        this.promoteRenderableToDollarForm(document, clause);
                    } else {
                        existingClauseValue.putAll(clauseValue);
                    }
                } else {
                    this.promoteRenderableToDollarForm(document, clause);
                }
            } else {
                document.append(clause.getKey(), clause.getValue());
            }
        }

        private boolean keysIntersect(BsonDocument first, BsonDocument second) {
            for (String name : first.keySet()) {
                if (!second.containsKey(name)) continue;
                return true;
            }
            return false;
        }

        private void promoteRenderableToDollarForm(BsonDocument document, Map.Entry<String, BsonValue> clause) {
            BsonArray clauses = new BsonArray();
            for (Map.Entry<String, BsonValue> queryElement : document.entrySet()) {
                clauses.add(new BsonDocument(queryElement.getKey(), queryElement.getValue()));
            }
            clauses.add(new BsonDocument(clause.getKey(), clause.getValue()));
            document.clear();
            document.put("$and", clauses);
        }

        public String toString() {
            return "And Filter{filters=" + this.filters + '}';
        }
    }

    private static final class OperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem value;

        OperatorFilter(String operatorName, String fieldName, TItem value2) {
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value2;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.value);
        }
    }

    private static final class SimpleFilter
    implements Bson {
        private final String fieldName;
        private final BsonValue value;

        private SimpleFilter(String fieldName, BsonValue value2) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = Assertions.notNull("value", value2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, this.value);
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, "$eq", this.value);
        }
    }
}

