/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ListCollectionsIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.operation.ListCollectionsOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ListCollectionsIterableImpl<TResult>
implements ListCollectionsIterable<TResult> {
    private final String databaseName;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private Bson filter;
    private int batchSize;
    private long maxTimeMS;

    ListCollectionsIterableImpl(String databaseName, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, OperationExecutor executor) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public ListCollectionsIterable<TResult> filter(Bson filter2) {
        Assertions.notNull("filter", filter2);
        this.filter = filter2;
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListCollectionsIterable<TResult> batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        return new OperationIterable(this.createListCollectionsOperation(), this.readPreference, this.executor);
    }

    private ListCollectionsOperation<TResult> createListCollectionsOperation() {
        return new ListCollectionsOperation<TResult>(this.databaseName, this.codecRegistry.get(this.resultClass)).filter(this.toBsonDocument(this.filter)).batchSize(this.batchSize).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(BsonDocument.class, this.codecRegistry);
    }
}

