/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.CursorType;
import com.mongodb.Function;
import com.mongodb.MappingIterable;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class FindIterableImpl<TDocument, TResult>
implements FindIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final FindOptions findOptions;
    private Bson filter;

    FindIterableImpl(MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, Bson filter2, FindOptions findOptions) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", executor);
        this.filter = Assertions.notNull("filter", filter2);
        this.findOptions = Assertions.notNull("findOptions", findOptions);
    }

    @Override
    public FindIterable<TResult> filter(Bson filter2) {
        this.filter = filter2;
        return this;
    }

    @Override
    public FindIterable<TResult> limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    @Override
    public FindIterable<TResult> skip(int skip) {
        this.findOptions.skip(skip);
        return this;
    }

    @Override
    public FindIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.findOptions.maxAwaitTime(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public FindIterable<TResult> batchSize(int batchSize) {
        this.findOptions.batchSize(batchSize);
        return this;
    }

    @Override
    public FindIterable<TResult> modifiers(Bson modifiers) {
        this.findOptions.modifiers(modifiers);
        return this;
    }

    @Override
    public FindIterable<TResult> projection(Bson projection) {
        this.findOptions.projection(projection);
        return this;
    }

    @Override
    public FindIterable<TResult> sort(Bson sort) {
        this.findOptions.sort(sort);
        return this;
    }

    @Override
    public FindIterable<TResult> noCursorTimeout(boolean noCursorTimeout) {
        this.findOptions.noCursorTimeout(noCursorTimeout);
        return this;
    }

    @Override
    public FindIterable<TResult> oplogReplay(boolean oplogReplay) {
        this.findOptions.oplogReplay(oplogReplay);
        return this;
    }

    @Override
    public FindIterable<TResult> partial(boolean partial) {
        this.findOptions.partial(partial);
        return this;
    }

    @Override
    public FindIterable<TResult> cursorType(CursorType cursorType) {
        this.findOptions.cursorType(cursorType);
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return new MappingIterable<TResult, U>(this, mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        return new FindOperationIterable(this.createQueryOperation(), this.readPreference, this.executor);
    }

    private FindOperation<TResult> createQueryOperation() {
        return new FindOperation<TResult>(this.namespace, this.codecRegistry.get(this.resultClass)).filter(this.filter.toBsonDocument(this.documentClass, this.codecRegistry)).batchSize(this.findOptions.getBatchSize()).skip(this.findOptions.getSkip()).limit(this.findOptions.getLimit()).maxTime(this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).maxAwaitTime(this.findOptions.getMaxAwaitTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.toBsonDocument(this.findOptions.getModifiers())).projection(this.toBsonDocument(this.findOptions.getProjection())).sort(this.toBsonDocument(this.findOptions.getSort())).cursorType(this.findOptions.getCursorType()).noCursorTimeout(this.findOptions.isNoCursorTimeout()).oplogReplay(this.findOptions.isOplogReplay()).partial(this.findOptions.isPartial()).slaveOk(this.readPreference.isSlaveOk()).readConcern(this.readConcern);
    }

    private BsonDocument toBsonDocument(Bson document) {
        return document == null ? null : document.toBsonDocument(this.documentClass, this.codecRegistry);
    }

    private final class FindOperationIterable
    extends OperationIterable<TResult> {
        private final ReadPreference readPreference;
        private final OperationExecutor executor;

        FindOperationIterable(FindOperation<TResult> operation, ReadPreference readPreference, OperationExecutor executor) {
            super(operation, readPreference, executor);
            this.readPreference = readPreference;
            this.executor = executor;
        }

        @Override
        public TResult first() {
            FindOperation findFirstOperation = FindIterableImpl.this.createQueryOperation().batchSize(0).limit(-1);
            BatchCursor batchCursor = (BatchCursor)this.executor.execute(findFirstOperation, this.readPreference);
            return batchCursor.hasNext() ? (Object)batchCursor.next().iterator().next() : null;
        }
    }
}

