/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBRef;
import com.mongodb.assertions.Assertions;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class DBRefCodec
implements Codec<DBRef> {
    private final CodecRegistry registry;

    public DBRefCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    @Override
    public void encode(BsonWriter writer, DBRef value2, EncoderContext encoderContext) {
        writer.writeStartDocument();
        writer.writeString("$ref", value2.getCollectionName());
        writer.writeName("$id");
        Codec<?> codec = this.registry.get(value2.getId().getClass());
        codec.encode(writer, value2.getId(), encoderContext);
        if (value2.getDatabaseName() != null) {
            writer.writeString("$db", value2.getDatabaseName());
        }
        writer.writeEndDocument();
    }

    @Override
    public Class<DBRef> getEncoderClass() {
        return DBRef.class;
    }

    @Override
    public DBRef decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("DBRefCodec does not support decoding");
    }
}

