/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.assertions.Assertions;
import java.io.Serializable;

public class DBRef
implements Serializable {
    private static final long serialVersionUID = -849581217713362618L;
    private final Object id;
    private final String collectionName;
    private final String databaseName;

    public DBRef(String collectionName, Object id) {
        this(null, collectionName, id);
    }

    public DBRef(String databaseName, String collectionName, Object id) {
        this.id = Assertions.notNull("id", id);
        this.collectionName = Assertions.notNull("ns", collectionName);
        this.databaseName = databaseName;
    }

    public Object getId() {
        return this.id;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DBRef dbRef = (DBRef)o;
        if (!this.id.equals(dbRef.id)) {
            return false;
        }
        if (!this.collectionName.equals(dbRef.collectionName)) {
            return false;
        }
        return !(this.databaseName != null ? !this.databaseName.equals(dbRef.databaseName) : dbRef.databaseName != null);
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = 31 * result2 + this.collectionName.hashCode();
        result2 = 31 * result2 + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "{ \"$ref\" : \"" + this.collectionName + "\", \"$id\" : \"" + this.id + "" + (this.databaseName == null ? "" : ", \"$db\" : \"" + this.databaseName + "\"") + " }";
    }
}

