/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.Cursor;
import com.mongodb.CursorType;
import com.mongodb.DBCollection;
import com.mongodb.DBDecoderAdapter;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.DBObjects;
import com.mongodb.ExplainVerbosity;
import com.mongodb.Mongo;
import com.mongodb.MongoBatchCursorAdapter;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.ServerCursor;
import com.mongodb.annotations.NotThreadSafe;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.FindOptions;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.FindOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bson.codecs.Decoder;

@NotThreadSafe
public class DBCursor
implements Cursor,
Iterable<DBObject> {
    private final DBCollection collection;
    private final OperationExecutor executor;
    private final DBObject filter;
    private final DBObject modifiers;
    private DBObject projection;
    private DBObject sort;
    private final FindOptions findOptions;
    private int options;
    private ReadPreference readPreference;
    private ReadConcern readConcern;
    private Decoder<DBObject> resultDecoder;
    private DBDecoderFactory decoderFactory;
    private IteratorOrArray iteratorOrArray;
    private DBObject currentObject;
    private int numSeen;
    private boolean closed;
    private final List<DBObject> all = new ArrayList<DBObject>();
    private MongoCursor<DBObject> cursor;
    private OptionalFinalizer optionalFinalizer;

    public DBCursor(DBCollection collection, DBObject query, DBObject fields, ReadPreference readPreference) {
        this(collection, collection.getExecutor(), query, new BasicDBObject(), fields, null, new FindOptions(), readPreference);
        this.addOption(collection.getOptions());
        DBObject indexKeys = DBCursor.lookupSuitableHints(query, collection.getHintFields());
        if (indexKeys != null) {
            this.hint(indexKeys);
        }
    }

    private DBCursor(DBCollection collection, OperationExecutor executor, DBObject filter2, DBObject modifiers, DBObject fields, DBObject sort, FindOptions findOptions, ReadPreference readPreference) {
        if (collection == null) {
            throw new IllegalArgumentException("Collection can't be null");
        }
        this.collection = collection;
        this.executor = executor;
        this.filter = filter2;
        this.modifiers = modifiers;
        this.projection = fields;
        this.sort = sort;
        this.findOptions = findOptions;
        this.readPreference = readPreference;
        this.resultDecoder = collection.getObjectCodec();
        this.decoderFactory = collection.getDBDecoderFactory();
    }

    public DBCursor copy() {
        return new DBCursor(this.collection, this.executor, this.filter, this.modifiers, this.projection, this.sort, new FindOptions(this.findOptions), this.readPreference);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Cursor has been closed");
        }
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.findOptions, this.resultDecoder);
            if (operation.getCursorType() == CursorType.Tailable) {
                operation.cursorType(CursorType.TailableAwait);
            }
            this.initializeCursor(operation);
        }
        boolean hasNext = this.cursor.hasNext();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return hasNext;
    }

    @Override
    public DBObject next() {
        this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextInternal();
    }

    public DBObject tryNext() {
        if (this.cursor == null) {
            FindOperation<DBObject> operation = this.getQueryOperation(this.findOptions, this.resultDecoder);
            if (!operation.getCursorType().isTailable()) {
                throw new IllegalArgumentException("Can only be used with a tailable cursor");
            }
            this.initializeCursor(operation);
        }
        DBObject next2 = this.cursor.tryNext();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return this.currentObject(next2);
    }

    public DBObject curr() {
        return this.currentObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public DBCursor addOption(int option) {
        this.setOptions(this.options |= option);
        return this;
    }

    public DBCursor setOptions(int options) {
        if ((options & 0x40) != 0) {
            throw new UnsupportedOperationException("exhaust query option is not supported");
        }
        this.options = options;
        return this;
    }

    public DBCursor resetOptions() {
        this.options = 0;
        return this;
    }

    public int getOptions() {
        return this.options;
    }

    public int getLimit() {
        return this.findOptions.getLimit();
    }

    public int getBatchSize() {
        return this.findOptions.getBatchSize();
    }

    public DBCursor addSpecial(String name, Object value2) {
        if (name == null || value2 == null) {
            return this;
        }
        if ("$comment".equals(name)) {
            this.comment(value2.toString());
        } else if ("$explain".equals(name)) {
            this.modifiers.put("$explain", true);
        } else if ("$hint".equals(name)) {
            if (value2 instanceof String) {
                this.hint((String)value2);
            } else {
                this.hint((DBObject)value2);
            }
        } else if ("$maxScan".equals(name)) {
            this.maxScan(((Number)value2).intValue());
        } else if ("$maxTimeMS".equals(name)) {
            this.maxTime(((Number)value2).longValue(), TimeUnit.MILLISECONDS);
        } else if ("$max".equals(name)) {
            this.max((DBObject)value2);
        } else if ("$min".equals(name)) {
            this.min((DBObject)value2);
        } else if ("$orderby".equals(name)) {
            this.sort((DBObject)value2);
        } else if ("$returnKey".equals(name)) {
            this.returnKey();
        } else if ("$showDiskLoc".equals(name)) {
            this.showDiskLoc();
        } else if ("$snapshot".equals(name)) {
            this.snapshot();
        } else if ("$natural".equals(name)) {
            this.sort(new BasicDBObject("$natural", (Object)((Number)value2).intValue()));
        } else {
            throw new IllegalArgumentException(name + "is not a supported modifier");
        }
        return this;
    }

    public DBCursor comment(String comment2) {
        this.modifiers.put("$comment", comment2);
        return this;
    }

    public DBCursor maxScan(int max2) {
        this.modifiers.put("$maxScan", max2);
        return this;
    }

    public DBCursor max(DBObject max2) {
        this.modifiers.put("$max", max2);
        return this;
    }

    public DBCursor min(DBObject min2) {
        this.modifiers.put("$min", min2);
        return this;
    }

    public DBCursor returnKey() {
        this.modifiers.put("$returnKey", true);
        return this;
    }

    public DBCursor showDiskLoc() {
        this.modifiers.put("$showDiskLoc", true);
        return this;
    }

    public DBCursor hint(DBObject indexKeys) {
        this.modifiers.put("$hint", indexKeys);
        return this;
    }

    public DBCursor hint(String indexName) {
        this.modifiers.put("$hint", indexName);
        return this;
    }

    public DBCursor maxTime(long maxTime, TimeUnit timeUnit) {
        this.findOptions.maxTime(maxTime, timeUnit);
        return this;
    }

    public DBCursor snapshot() {
        this.modifiers.put("$snapshot", true);
        return this;
    }

    public DBObject explain() {
        return DBObjects.toDBObject(this.executor.execute(this.getQueryOperation(this.findOptions, this.collection.getObjectCodec()).asExplainableOperation(ExplainVerbosity.QUERY_PLANNER), this.getReadPreference()));
    }

    private FindOperation<DBObject> getQueryOperation(FindOptions options, Decoder<DBObject> decoder) {
        FindOperation<DBObject> operation = new FindOperation<DBObject>(this.collection.getNamespace(), decoder).readConcern(this.getReadConcern()).filter(this.collection.wrapAllowNull(this.filter)).batchSize(options.getBatchSize()).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).modifiers(this.collection.wrap(this.modifiers)).projection(this.collection.wrapAllowNull(this.projection)).sort(this.collection.wrapAllowNull(this.sort)).noCursorTimeout(options.isNoCursorTimeout()).oplogReplay(options.isOplogReplay()).partial(options.isPartial());
        if ((this.options & 2) != 0) {
            if ((this.options & 0x20) != 0) {
                operation.cursorType(CursorType.TailableAwait);
            } else {
                operation.cursorType(CursorType.Tailable);
            }
        }
        if ((this.options & 8) != 0) {
            operation.oplogReplay(true);
        }
        if ((this.options & 0x10) != 0) {
            operation.noCursorTimeout(true);
        }
        if ((this.options & 0x80) != 0) {
            operation.partial(true);
        }
        return operation;
    }

    public DBCursor sort(DBObject orderBy) {
        this.sort = orderBy;
        return this;
    }

    public DBCursor limit(int limit) {
        this.findOptions.limit(limit);
        return this;
    }

    public DBCursor batchSize(int numberOfElements) {
        this.findOptions.batchSize(numberOfElements);
        return this;
    }

    public DBCursor skip(int numberOfElements) {
        this.findOptions.skip(numberOfElements);
        return this;
    }

    @Override
    public long getCursorId() {
        if (this.cursor != null && this.cursor.getServerCursor() != null) {
            return this.cursor.getServerCursor().getId();
        }
        return 0L;
    }

    public int numSeen() {
        return this.numSeen;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
            this.setServerCursorOnFinalizer(null);
        }
        this.currentObject = null;
    }

    @Deprecated
    public DBCursor slaveOk() {
        return this.addOption(4);
    }

    @Override
    public Iterator<DBObject> iterator() {
        return this.copy();
    }

    public List<DBObject> toArray() {
        return this.toArray(Integer.MAX_VALUE);
    }

    public List<DBObject> toArray(int max2) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(max2 - 1);
        return this.all;
    }

    public int count() {
        return (int)this.collection.getCount(this.getQuery(), 0L, 0L, this.getReadPreferenceForCursor(), this.getReadConcern(), this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS, this.collection.wrap(this.modifiers).get("$hint"));
    }

    public DBObject one() {
        return this.collection.findOne(this.getQuery(), this.getKeysWanted(), this.sort, this.getReadPreferenceForCursor(), this.getReadConcern(), this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public int length() {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        this.fillArray(Integer.MAX_VALUE);
        return this.all.size();
    }

    public int itcount() {
        int n = 0;
        while (this.hasNext()) {
            this.next();
            ++n;
        }
        return n;
    }

    public int size() {
        return (int)this.collection.getCount(this.getQuery(), this.findOptions.getLimit(), this.findOptions.getSkip(), this.getReadPreference(), this.getReadConcern(), this.findOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
    }

    public DBObject getKeysWanted() {
        return this.projection;
    }

    public DBObject getQuery() {
        return this.filter;
    }

    public DBCollection getCollection() {
        return this.collection;
    }

    @Override
    public ServerAddress getServerAddress() {
        if (this.cursor != null) {
            return this.cursor.getServerAddress();
        }
        return null;
    }

    public DBCursor setReadPreference(ReadPreference readPreference) {
        this.readPreference = readPreference;
        return this;
    }

    public ReadPreference getReadPreference() {
        if (this.readPreference != null) {
            return this.readPreference;
        }
        return this.collection.getReadPreference();
    }

    DBCursor setReadConcern(ReadConcern readConcern) {
        this.readConcern = readConcern;
        return this;
    }

    ReadConcern getReadConcern() {
        if (this.readConcern != null) {
            return this.readConcern;
        }
        return this.collection.getReadConcern();
    }

    public DBCursor setDecoderFactory(DBDecoderFactory factory) {
        this.decoderFactory = factory;
        this.resultDecoder = new DBDecoderAdapter(factory.create(), this.collection, this.getCollection().getBufferPool());
        return this;
    }

    public DBDecoderFactory getDecoderFactory() {
        return this.decoderFactory;
    }

    public String toString() {
        return "DBCursor{collection=" + this.collection + ", find=" + this.findOptions + (this.cursor != null ? ", cursor=" + this.cursor.getServerCursor() : "") + '}';
    }

    private void initializeCursor(FindOperation<DBObject> operation) {
        this.cursor = new MongoBatchCursorAdapter<DBObject>((BatchCursor)((Object)this.executor.execute(operation, this.getReadPreferenceForCursor())));
        if (this.isCursorFinalizerEnabled() && this.cursor.getServerCursor() != null) {
            this.optionalFinalizer = new OptionalFinalizer(this.collection.getDB().getMongo(), this.collection.getNamespace());
        }
    }

    private boolean isCursorFinalizerEnabled() {
        return this.collection.getDB().getMongo().getMongoClientOptions().isCursorFinalizerEnabled();
    }

    private void setServerCursorOnFinalizer(ServerCursor serverCursor) {
        if (this.optionalFinalizer != null) {
            this.optionalFinalizer.setServerCursor(serverCursor);
        }
    }

    private void checkIteratorOrArray(IteratorOrArray expected) {
        if (this.iteratorOrArray == null) {
            this.iteratorOrArray = expected;
            return;
        }
        if (expected == this.iteratorOrArray) {
            return;
        }
        throw new IllegalArgumentException("Can't switch cursor access methods");
    }

    private ReadPreference getReadPreferenceForCursor() {
        ReadPreference readPreference = this.getReadPreference();
        if ((this.options & 4) != 0 && !readPreference.isSlaveOk()) {
            readPreference = ReadPreference.secondaryPreferred();
        }
        return readPreference;
    }

    private void fillArray(int n) {
        this.checkIteratorOrArray(IteratorOrArray.ARRAY);
        while (n >= this.all.size() && this.hasNext()) {
            this.all.add(this.nextInternal());
        }
    }

    private DBObject nextInternal() {
        if (this.iteratorOrArray == null) {
            this.checkIteratorOrArray(IteratorOrArray.ITERATOR);
        }
        DBObject next2 = this.cursor.next();
        this.setServerCursorOnFinalizer(this.cursor.getServerCursor());
        return this.currentObject(next2);
    }

    private DBObject currentObject(DBObject newCurrentObject) {
        if (newCurrentObject != null) {
            this.currentObject = newCurrentObject;
            ++this.numSeen;
            if (this.projection != null && !this.projection.keySet().isEmpty()) {
                this.currentObject.markAsPartialObject();
            }
        }
        return newCurrentObject;
    }

    private static DBObject lookupSuitableHints(DBObject query, List<DBObject> hints) {
        if (hints == null) {
            return null;
        }
        Set<String> keys = query.keySet();
        for (DBObject hint : hints) {
            if (!keys.containsAll(hint.keySet())) continue;
            return hint;
        }
        return null;
    }

    private static class OptionalFinalizer {
        private final Mongo mongo;
        private final MongoNamespace namespace;
        private volatile ServerCursor serverCursor;

        private OptionalFinalizer(Mongo mongo, MongoNamespace namespace) {
            this.namespace = Assertions.notNull("namespace", namespace);
            this.mongo = Assertions.notNull("mongo", mongo);
        }

        private void setServerCursor(ServerCursor serverCursor) {
            this.serverCursor = serverCursor;
        }

        protected void finalize() {
            if (this.serverCursor != null) {
                this.mongo.addOrphanedCursor(this.serverCursor, this.namespace);
            }
        }
    }

    private static enum IteratorOrArray {
        ITERATOR,
        ARRAY;

    }
}

