/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BulkWriteOperation;
import com.mongodb.DBObject;
import com.mongodb.ReplaceRequest;
import com.mongodb.UpdateRequest;
import org.bson.codecs.Encoder;

public class BulkUpdateRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final boolean upsert;
    private final Encoder<DBObject> queryCodec;
    private final Encoder<DBObject> replacementCodec;

    BulkUpdateRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, boolean upsert, Encoder<DBObject> queryCodec, Encoder<DBObject> replacementCodec) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.upsert = upsert;
        this.queryCodec = queryCodec;
        this.replacementCodec = replacementCodec;
    }

    public void replaceOne(DBObject document) {
        this.bulkWriteOperation.addRequest(new ReplaceRequest(this.query, document, this.upsert, this.queryCodec, this.replacementCodec));
    }

    public void update(DBObject update2) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, update2, true, this.upsert, this.queryCodec));
    }

    public void updateOne(DBObject update2) {
        this.bulkWriteOperation.addRequest(new UpdateRequest(this.query, update2, false, this.upsert, this.queryCodec));
    }
}

