/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class StormUICapacityMonitor {
    public static List<String> DMONkeys = Arrays.asList("capacity");

    public static double recurJSON(JSONObject jsonObj2) {
        Double maxcapacity = new Double(0.0);
        Iterator keys = jsonObj2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!(jsonObj2.get(key) instanceof JSONArray)) continue;
            JSONArray a = (JSONArray)jsonObj2.get(key);
            ArrayList list = new ArrayList();
            for (int i = 0; i < a.length(); ++i) {
                JSONObject y;
                if (!(a.get(i) instanceof JSONObject) || !(y = a.getJSONObject(i)).has("capacity")) continue;
                maxcapacity = Double.max(maxcapacity, new Double(y.getString("capacity")));
            }
        }
        return maxcapacity;
    }

    public static String getId(String url, String topologyName) throws Exception {
        String encodedId = new String("");
        URL object = new URL(url + "/api/v1/topology/summary");
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestMethod("GET");
        StringBuilder sb = new StringBuilder();
        int HttpResult = con.getResponseCode();
        if (HttpResult == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            JSONObject jsonObj2 = new JSONObject("" + sb.toString());
            JSONArray a = (JSONArray)jsonObj2.get("topologies");
            ArrayList list = new ArrayList();
            for (int i = 0; i < a.length(); ++i) {
                JSONObject jsonTopology;
                if (!(a.get(i) instanceof JSONObject) || !(jsonTopology = (JSONObject)a.get(i)).get("name").equals(topologyName)) continue;
                encodedId = jsonTopology.get("encodedId").toString();
            }
        } else {
            System.out.println(con.getResponseMessage());
        }
        return encodedId;
    }

    public static double getMaxCapacity(String url, String encodedId) throws Exception {
        double maxcapacity = 0.0;
        URL object = new URL(url + "/api/v1/topology/" + encodedId);
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestMethod("GET");
        StringBuilder sb = new StringBuilder();
        int HttpResult = con.getResponseCode();
        if (HttpResult == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            JSONObject jsonObj2 = new JSONObject("" + sb.toString());
            maxcapacity = StormUICapacityMonitor.recurJSON(jsonObj2);
        } else {
            System.out.println(con.getResponseMessage());
        }
        return maxcapacity;
    }

    public static void main(String[] args) {
        try {
            String encodedId = StormUICapacityMonitor.getId("http://localhost:8080", "topology-qt1");
            double maxcapacity = StormUICapacityMonitor.getMaxCapacity("http://localhost:8080", encodedId);
            System.out.println("Max Bolt Capacity (StormUI, topology=" + encodedId + "): " + maxcapacity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

