/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class DMONBoltCapacityMonitor {
    public static List<String> DMONkeys = Arrays.asList("bolts_0_capacity", "bolts_1_capacity");

    public static double recurJSON(JSONObject jsonObj2) {
        Double maxcapacity = new Double(0.0);
        Iterator keys = jsonObj2.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (jsonObj2.get(key) instanceof JSONObject) {
                JSONObject o = (JSONObject)jsonObj2.get(key);
                for (String pattern : DMONkeys) {
                    if (!o.has(pattern)) continue;
                    maxcapacity = Double.max(maxcapacity, Double.parseDouble(o.get(pattern).toString()));
                }
                maxcapacity = Double.max(maxcapacity, DMONBoltCapacityMonitor.recurJSON(o));
                continue;
            }
            if (!(jsonObj2.get(key) instanceof JSONArray)) continue;
            JSONArray a = (JSONArray)jsonObj2.get(key);
            ArrayList list = new ArrayList();
            for (int i = 0; i < a.length(); ++i) {
                if (!(a.get(i) instanceof JSONObject)) continue;
                maxcapacity = Double.max(maxcapacity, DMONBoltCapacityMonitor.recurJSON(a.getJSONObject(i)));
            }
        }
        return maxcapacity;
    }

    public static double getMaxCapacity(String url, String t0, String t1, int maxDMONRecords) throws Exception {
        double maxcapacity = 0.0;
        URL object = new URL(url + "/dmon/v1/observer/query/json");
        String myJSON = "{\"DMON\":{\"fname\":\"output\",\"ordering\":\"desc\",\"queryString\":\"NOT _type=collectd\",\"size\": " + maxDMONRecords + ",\"tstart\":\"" + t0 + "\",\"tstop\":\"" + t1 + "\"}}";
        HttpURLConnection con = (HttpURLConnection)object.openConnection();
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setRequestMethod("POST");
        OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream());
        wr.write(myJSON);
        wr.flush();
        StringBuilder sb = new StringBuilder();
        int HttpResult = con.getResponseCode();
        if (HttpResult == 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), "utf-8"));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line + "\n");
            }
            br.close();
            JSONObject jsonObj2 = new JSONObject("" + sb.toString());
            maxcapacity = DMONBoltCapacityMonitor.recurJSON(jsonObj2);
        } else {
            System.out.println(con.getResponseMessage());
        }
        return maxcapacity;
    }

    public static void main(String[] args) {
        try {
            String t0 = "2017-03-04T12:19:30.000Z";
            String timeStampDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            String timeStampTime = new SimpleDateFormat("HH:mm:ss.000").format(new Date());
            String t1 = timeStampDate + "T" + timeStampTime + "Z";
            System.out.println(t1);
            t1 = "2017-03-04T12:20:00.000Z";
            int maxDMONRecords = 100;
            double maxcapacity = DMONBoltCapacityMonitor.getMaxCapacity("http://109.231.122.229:5001", t0, t1, maxDMONRecords);
            System.out.println("Max Bolt Capacity: " + maxcapacity);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

