/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.spout;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateSpout
extends BaseRichSpout {
    private static final long serialVersionUID = 1L;
    SpoutOutputCollector collector;
    InputStream inputRates;
    transient Scanner scanner;
    List<Integer> iatList;
    List<Integer> volList;
    List<String> payloadList;
    int arvCursor;
    int dataCursor;
    int cntCursor;
    long lastEmit;
    long lastTimestamp;
    boolean binaryBDoc;
    ArrivalMode arvMode;
    DataMode dataMode;
    String arvFile;
    String dataFile;
    String timeField;
    int dataVol;
    double rateScaler;
    private static final Logger LOG = LoggerFactory.getLogger(RateSpout.class);

    public RateSpout() {
        this.setBinaryBDoc(false);
        this.setRateScaler(1.0);
    }

    public RateSpout(String _arvfname) {
        this.setBinaryBDoc(false);
        this.setArrivalMode(ArrivalMode.RandIat);
        this.setArrivalFile(_arvfname);
        this.setDataMode(DataMode.ParseJSON);
        this.setDataVolume(1024);
        this.setRateScaler(1.0);
    }

    public RateSpout(String _arvfname, int _datavol) {
        this.setBinaryBDoc(false);
        this.setArrivalMode(ArrivalMode.RandIat);
        this.setArrivalFile(_arvfname);
        this.setDataMode(DataMode.RandText);
        this.setRateScaler(1.0);
    }

    public void setRateScaler(double _scale) {
        this.rateScaler = _scale;
    }

    public void setTimeField(String _field) {
        this.timeField = _field;
    }

    public void setBinaryBDoc(boolean val) {
        this.binaryBDoc = val;
    }

    public String getTimeField() {
        return this.timeField;
    }

    public void setArrivalMode(ArrivalMode _arvmode) {
        this.arvMode = _arvmode;
    }

    public void setArrivalFile(String _arvfname) {
        this.arvFile = _arvfname;
    }

    public void setDataMode(DataMode _DataMode) {
        this.dataMode = _DataMode;
    }

    public void setDataFile(String _datafname) {
        this.dataFile = _datafname;
    }

    public void setDataVolume(int _datavol) {
        this.dataVol = _datavol;
    }

    public ArrivalMode getArrivalMode() {
        return this.arvMode;
    }

    public String getArrivalFile() {
        return this.arvFile;
    }

    public DataMode getDataMode() {
        return this.dataMode;
    }

    public String getDataFile() {
        return this.dataFile;
    }

    public int getDataVolume() {
        return this.dataVol;
    }

    private void initData() {
        LOG.info("QTLib started: am = " + (Object)((Object)this.getArrivalMode()) + ", dm = " + (Object)((Object)this.getDataMode()));
        this.arvCursor = 0;
        this.dataCursor = 0;
        this.cntCursor = 0;
        this.lastEmit = System.currentTimeMillis();
        this.lastTimestamp = 0L;
        switch (this.getArrivalMode()) {
            case ParseIat: {
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.arvFile);
                this.scanner = new Scanner(is);
                this.iatList = new ArrayList<Integer>();
                while (this.scanner.hasNext()) {
                    if (this.scanner.hasNextInt()) {
                        this.iatList.add(this.scanner.nextInt());
                        continue;
                    }
                    this.scanner.next();
                }
                break;
            }
            case ParseRate: {
                int holdTime;
                this.iatList = new ArrayList<Integer>();
                this.volList = new ArrayList<Integer>();
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.arvFile);
                this.scanner = new Scanner(is);
                while (this.scanner.hasNext()) {
                    holdTime = this.scanner.nextInt();
                    int rateBytes = this.scanner.nextInt();
                    for (int i = 1; i <= holdTime; ++i) {
                        this.iatList.add(1000);
                        this.volList.add(rateBytes);
                        System.out.println(rateBytes);
                    }
                }
                this.scanner.close();
                break;
            }
            case ParseCount: {
                int holdTime;
                this.iatList = new ArrayList<Integer>();
                this.volList = new ArrayList<Integer>();
                InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.arvFile);
                this.scanner = new Scanner(is);
                while (this.scanner.hasNext()) {
                    holdTime = this.scanner.nextInt();
                    int count2 = this.scanner.nextInt();
                    for (int i = 1; i <= holdTime; ++i) {
                        this.iatList.add(1000);
                        this.volList.add(count2);
                    }
                }
                this.scanner.close();
                break;
            }
            case RandIat: {
                break;
            }
        }
        switch (this.getDataMode()) {
            case ParseJSON: 
            case ParseTimedJSON: {
                InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/" + this.dataFile);
                this.payloadList = new ArrayList<String>();
                try {
                    this.payloadList = IOUtils.readLines(in, "UTF-8");
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            case RandBSON: {
                break;
            }
            case RandBytes: {
                break;
            }
            case RandJSON: {
                break;
            }
            case RandText: {
                break;
            }
        }
    }

    public void open(Map arg0, TopologyContext arg1, SpoutOutputCollector arg2) {
        this.collector = arg2;
        this.initData();
    }

    public String setMsgId() {
        return "##";
    }

    public void nextTuple() {
        String msgId = this.setMsgId();
        long curTime = System.currentTimeMillis();
        switch (this.getArrivalMode()) {
            case ParseIat: {
                Utils.sleep((long)((long)((double)this.iatList.get(this.arvCursor++).intValue() / this.rateScaler)));
                if (this.arvCursor != this.iatList.size()) break;
                this.arvCursor = 0;
                break;
            }
            case RandIat: {
                Random r = new Random();
                Utils.sleep((long)((long)(r.nextDouble() * 1000.0 / this.rateScaler)));
                break;
            }
            case RandIatExp: {
                Random r = new Random();
                long t = (long)(0.0 * Math.log(r.nextDouble()));
                if (t > 1000L) {
                    t = 1000L;
                }
                Utils.sleep((long)((long)((double)t / this.rateScaler)));
                break;
            }
            case ParseRate: {
                Utils.sleep((long)((long)((double)this.iatList.get(this.arvCursor++).intValue() / this.rateScaler)));
                if (this.arvCursor == this.iatList.size()) {
                    this.arvCursor = 0;
                }
                String sentence = RandomStringUtils.randomAlphanumeric(this.volList.get(this.dataCursor++));
                if (this.dataCursor == this.volList.size()) {
                    this.dataCursor = 0;
                }
                this.emitOne(msgId, sentence);
                return;
            }
            case ParseCount: {
                Utils.sleep((long)((long)((double)this.iatList.get(this.arvCursor++).intValue() / this.rateScaler)));
                if (this.arvCursor == this.iatList.size()) {
                    this.arvCursor = 0;
                }
                int count2 = this.volList.get(this.cntCursor++);
                if (this.cntCursor == this.volList.size()) {
                    this.cntCursor = 0;
                }
                for (int i = 0; i < count2; ++i) {
                    this.emitOne(msgId, null);
                }
                return;
            }
        }
        this.emitOne(msgId);
    }

    public void emitOne(Object msgId) {
        this.emitOne(msgId, null);
    }

    public void emitOne(Object msgId, String sentence) {
        switch (this.getDataMode()) {
            case RandText: {
                if (sentence == null) {
                    sentence = RandomStringUtils.randomAlphanumeric(this.dataVol);
                }
                LOG.info("random sentence " + sentence);
                this.collector.emit((List)new Values(new Object[]{sentence}), msgId);
                break;
            }
            case RandAscii: {
                if (sentence == null) {
                    sentence = RandomStringUtils.randomAscii(this.dataVol);
                }
                LOG.info("random sentence " + sentence);
                this.collector.emit((List)new Values(new Object[]{sentence}), msgId);
                break;
            }
            case RandBytes: {
                Random r = new Random();
                byte[] bytes = new byte[this.dataVol];
                r.nextBytes(bytes);
                LOG.info("" + this.dataVol + " random bytes: " + bytes);
                this.collector.emit(Utils.tuple((Object[])new Object[]{bytes.toString()}), msgId);
                break;
            }
            case RandBSON: {
                if (sentence == null) {
                    sentence = RandomStringUtils.randomAlphanumeric(this.dataVol);
                }
                Document bDoc = new Document("key", sentence);
                LOG.info("random BSON sentence " + bDoc.getString("key"));
                this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc.toString()}), msgId);
                break;
            }
            case RandJSON: {
                if (sentence == null) {
                    sentence = RandomStringUtils.randomAlphanumeric(this.dataVol);
                }
                String string_json = "{ 'msg': '" + sentence + "'}";
                Document bDoc = new Document();
                bDoc = Document.parse(string_json);
                LOG.info("BSON document parsed from JSON: " + bDoc.toString());
                this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc.toString()}), msgId);
                break;
            }
            case ParseJSON: {
                String string_json = this.payloadList.get(this.dataCursor++);
                if (this.dataCursor == this.payloadList.size()) {
                    this.dataCursor = 0;
                }
                Document bDoc = new Document();
                bDoc = Document.parse(string_json);
                LOG.info("BSON document parsed from JSON: " + bDoc.toString());
                if (this.binaryBDoc) {
                    this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc}), msgId);
                    break;
                }
                this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc.toString()}), msgId);
                break;
            }
            case ParseTimedJSON: {
                long targetIat;
                String string_json = this.payloadList.get(this.dataCursor++);
                if (this.dataCursor == this.payloadList.size()) {
                    this.dataCursor = 0;
                }
                Document bDoc = new Document();
                bDoc = Document.parse(string_json);
                LOG.info("BSON document parsed from JSON: " + bDoc.toString());
                if (this.lastTimestamp > 0L) {
                    targetIat = bDoc.getLong(this.getTimeField()) - this.lastTimestamp;
                    if (targetIat < 0L) {
                        targetIat = 0L;
                    }
                } else {
                    targetIat = 0L;
                }
                LOG.debug("new timestamp: " + bDoc.getLong(this.getTimeField()) + " last timestamp: " + this.lastTimestamp + " target iat: " + targetIat);
                Utils.sleep((long)((long)((double)targetIat / this.rateScaler)));
                this.lastTimestamp = bDoc.getLong(this.getTimeField());
                if (this.binaryBDoc) {
                    this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc}), msgId);
                    break;
                }
                this.collector.emit(Utils.tuple((Object[])new Object[]{bDoc.toString()}), msgId);
            }
        }
        this.lastEmit = System.currentTimeMillis();
        LOG.debug("emitted at time " + this.lastEmit);
    }

    public void declareOutputFields(OutputFieldsDeclarer arg0) {
        arg0.declare(new Fields(new String[]{"str"}));
    }

    public void ack(Object msgId) {
    }

    public static enum ArrivalMode {
        ParseIat,
        RandIat,
        RandIatExp,
        ParseRate,
        ParseCount,
        Null;

    }

    public static enum DataMode {
        RandText,
        RandAscii,
        RandBytes,
        RandBSON,
        RandJSON,
        ParseJSON,
        ParseTimedJSON,
        Null;

    }
}

