/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.producer;

import com.ameliant.tools.kafka.perftool.config.ProducerDefinition;
import com.ameliant.tools.kafka.perftool.config.TestProfileDefinition;
import com.ameliant.tools.kafka.perftool.drivers.ProducerDriver;
import com.ameliant.tools.kafka.testdsl.config.ProducerConfigsBuilder;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class RateProducer {
    private static final long serialVersionUID = 1L;
    TestProfileDefinition testProfileDefinition;
    int numWorkers = 1;
    int messageCount = 1;
    int messageSize = 1024;
    ProducerDefinition prodDef = new ProducerDefinition();

    public void setMaxDuration(int maxDuration) {
    }

    public void setWorkers(int workers) {
        this.numWorkers = workers;
    }

    public void setMessageCount(int msgCount) {
        this.messageCount = msgCount;
    }

    public void setMessageSize(int msgSize) {
        this.messageSize = msgSize;
    }

    public void setAutogenerateTopic(boolean autogenerateTopic) {
        this.testProfileDefinition.setAutogenerateTopic(autogenerateTopic);
    }

    public void run(String url, String topic) {
        this.run(url, topic, null);
    }

    public void run(String url, String topic, String messageLocation) {
        CountDownLatch latch = this.numWorkers > 1 ? new CountDownLatch(this.numWorkers) : new CountDownLatch(2);
        Map producerConfigs = new ProducerConfigsBuilder().bootstrapServers(url).keySerializer(ByteArraySerializer.class).valueSerializer(ByteArraySerializer.class).batchSize(0).build();
        ProducerDefinition producerDefinition = new ProducerDefinition();
        producerDefinition.setConfig(producerConfigs);
        producerDefinition.setTopic(topic);
        producerDefinition.setMessageSize(this.messageSize);
        producerDefinition.setMessagesToSend((long)this.messageCount);
        producerDefinition.setSendBlocking(true);
        producerDefinition.setMessageLocation(messageLocation);
        ProducerDriver producerDriver = new ProducerDriver(producerDefinition, latch);
        try {
            if (this.numWorkers > 1) {
                ExecutorService executorService = Executors.newFixedThreadPool(this.numWorkers);
                executorService.submit((Runnable)producerDriver);
            } else {
                producerDriver.run();
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("QT-LIB Error: Input JSON file exhausted. Try decreasing the message count.");
        }
    }
}

