/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.loadgen.impl;

import com.github.diceproject.qt.loadgen.impl.GenerateLoad;
import com.github.diceproject.qt.util.UniformDistribution;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class GenerateLoadFromCSVByRate {
    public static FileWriter fw;
    public static BufferedWriter bw;
    public static BufferedReader br;
    public static ArrayList<String> timeAndRateList;
    public static GenerateLoad generateLoad;
    public static Map<String, String> conf;
    public static UniformDistribution uniformDistribution;
    public static int num;

    public static ArrayList<String> getRateList(String csvFilePath, String fileNamePath, boolean uniformSlots, boolean exponentialSlots, int parallelism, ArrayList<Integer> exponentialList, int uniformCut) throws Exception {
        timeAndRateList = new ArrayList();
        generateLoad = new GenerateLoad();
        uniformDistribution = new UniformDistribution();
        conf = new HashMap<String, String>();
        try {
            br = new BufferedReader(new FileReader(csvFilePath));
            String str = "";
            boolean i = false;
            int time = 0;
            int dataSize = 0;
            while ((str = br.readLine()) != null) {
                String[] row = str.split(",");
                if (!i) {
                    i = true;
                    continue;
                }
                time = Integer.parseInt(Pattern.compile("[^0-9]").matcher(row[0]).replaceAll(""));
                dataSize = Integer.parseInt(Pattern.compile("[^0-9]").matcher(row[1]).replaceAll(""));
                if (uniformSlots) {
                    num = UniformDistribution.divisionPerSecond(dataSize, uniformCut);
                    conf.put("dataSize", String.valueOf(dataSize /= num));
                    conf.put("pathString", fileNamePath);
                    generateLoad.generateLoadForWords(conf);
                    timeAndRateList.add(time + ";" + dataSize + ";" + num);
                    continue;
                }
                if (exponentialSlots) {
                    num = exponentialList.size();
                    conf.put("dataSize", String.valueOf(dataSize /= num));
                    conf.put("pathString", fileNamePath);
                    generateLoad.generateLoadForWords(conf);
                    timeAndRateList.add(time + ";" + dataSize + ";" + num);
                    continue;
                }
                conf.put("dataSize", String.valueOf(dataSize /= parallelism));
                conf.put("pathString", fileNamePath);
                generateLoad.generateLoadForWords(conf);
                timeAndRateList.add(time + ";" + dataSize);
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return timeAndRateList;
    }

    static {
        num = 1;
    }
}

