/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.examples;

import com.github.diceproject.qt.QTLoadInjector;
import com.github.diceproject.qt.examples.ExclamationBolt;
import com.github.diceproject.qt.spout.RateSpout;
import com.github.diceproject.qt.util.StormUICapacityMonitor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.KillOptions;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.SpoutDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;

public class ExclamationTopology {
    public static void main(String[] args) throws Exception {
        String timeStampDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
        String timeStampTime = new SimpleDateFormat("HH:mm:ss.000").format(new Date());
        String tStart = timeStampDate + "T" + timeStampTime + "Z";
        double maxBoltCapacity = 1.0;
        double curMaxBoltCapacity = 0.0;
        int numExperiments = 20;
        for (int topologyId = 1; topologyId <= numExperiments; ++topologyId) {
            TopologyBuilder builder = new TopologyBuilder();
            Integer qtSpoutParallelism = 2;
            Integer qtSpoutNumTasks = 2;
            String qtSpoutName = "word-spout";
            HashMap<String, String> confSpout = new HashMap<String, String>();
            confSpout.put("spout", "spout");
            QTLoadInjector qt = new QTLoadInjector();
            RateSpout qtSpout = qt.getRateSpout();
            RateSpout.ArrivalMode am = RateSpout.ArrivalMode.ParseCount;
            qtSpout.setArrivalMode(am);
            qtSpout.setRateScaler((double)topologyId * 200.0);
            switch (am) {
                case ParseIat: {
                    qtSpout.setArrivalFile("iats.txt");
                    break;
                }
                case ParseRate: {
                    qtSpout.setArrivalFile("rates.txt");
                    break;
                }
                case ParseCount: {
                    qtSpout.setArrivalFile("counts.txt");
                    break;
                }
            }
            RateSpout.DataMode dm = RateSpout.DataMode.ParseJSON;
            qtSpout.setDataMode(dm);
            qtSpout.setBinaryBDoc(false);
            switch (dm) {
                case ParseJSON: {
                    qtSpout.setDataFile("test.json");
                    break;
                }
                case ParseTimedJSON: {
                    qtSpout.setDataFile("test.json");
                    qtSpout.setTimeField("publicationTime");
                    break;
                }
                default: {
                    qtSpout.setDataVolume(1024);
                }
            }
            String topologyName = "topology-qt" + topologyId;
            ((SpoutDeclarer)builder.setSpout(qtSpoutName, (IRichSpout)qtSpout, (Number)qtSpoutParallelism).addConfigurations(confSpout)).setNumTasks((Number)qtSpoutNumTasks);
            ((BoltDeclarer)builder.setBolt("exclaim1", (IRichBolt)new ExclamationBolt(), (Number)1).shuffleGrouping(qtSpoutName)).setNumTasks((Number)1);
            ((BoltDeclarer)builder.setBolt("exclaim2", (IRichBolt)new ExclamationBolt(), (Number)2).shuffleGrouping("exclaim1")).setNumTasks((Number)2);
            Config conf = new Config();
            conf.setDebug(true);
            conf.setNumWorkers(1);
            StormTopology myTopology = builder.createTopology();
            StormSubmitter.submitTopology((String)topologyName, (Map)conf, (StormTopology)myTopology);
            int topologyDuration = 60;
            try {
                Thread.sleep(topologyDuration * 1000);
            }
            catch (InterruptedException e) {
                System.out.println("got interrupted!");
            }
            String StormUIurl = "http://192.168.0.4:8080";
            String encodedId = StormUICapacityMonitor.getId(StormUIurl, topologyName);
            curMaxBoltCapacity = StormUICapacityMonitor.getMaxCapacity(StormUIurl, encodedId);
            System.out.println("Max Bolt Capacity (StormUI, Topology: " + encodedId + "): " + curMaxBoltCapacity);
            Map stormConf = Utils.readStormConfig();
            Nimbus.Client client = NimbusClient.getConfiguredClient((Map)stormConf).getClient();
            KillOptions killOpts = new KillOptions();
            client.killTopologyWithOpts(topologyName, killOpts);
            int topologySleep = 30;
            try {
                Thread.sleep(topologySleep * 1000);
            }
            catch (InterruptedException e) {
                System.out.println("got interrupted!");
            }
            timeStampDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date());
            timeStampTime = new SimpleDateFormat("HH:mm:ss.000").format(new Date());
            String tEnd = timeStampDate + "T" + timeStampTime + "Z";
            int maxDMONRecords = 100;
            String string2 = "http://0.0.0.0:5001";
        }
    }
}

