/*
 * Decompiled with CFR 0.152.
 */
package com.github.diceproject.qt.examples;

import com.github.diceproject.qt.QTLoadInjector;
import com.github.diceproject.qt.examples.ExclamationBolt;
import com.github.diceproject.qt.spout.RateSpout;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.Config;
import org.apache.storm.StormSubmitter;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.metric.LoggingMetricsConsumer;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.SpoutDeclarer;
import org.apache.storm.topology.TopologyBuilder;

public class BasicExclamationTopology {
    public static void main(String[] args) throws Exception {
        TopologyBuilder builder = new TopologyBuilder();
        Integer qtSpoutParallelism = 1;
        Integer qtSpoutNumTasks = 1;
        String qtSpoutName = "word-spout";
        HashMap<String, String> confSpout = new HashMap<String, String>();
        confSpout.put("spout", "spout");
        QTLoadInjector qt = new QTLoadInjector();
        RateSpout qtSpout = qt.getRateSpout();
        RateSpout.ArrivalMode am = RateSpout.ArrivalMode.ParseCount;
        qtSpout.setArrivalMode(am);
        switch (am) {
            case ParseIat: {
                qtSpout.setArrivalFile("iats.txt");
                break;
            }
            case ParseRate: {
                qtSpout.setArrivalFile("rates.txt");
                break;
            }
            case ParseCount: {
                qtSpout.setArrivalFile("counts.txt");
                break;
            }
        }
        RateSpout.DataMode dm = RateSpout.DataMode.ParseJSON;
        qtSpout.setDataMode(dm);
        switch (dm) {
            case ParseJSON: {
                qtSpout.setDataFile("test.json");
                break;
            }
            case ParseTimedJSON: {
                qtSpout.setDataFile("test.json");
                qtSpout.setTimeField("publicationTime");
                break;
            }
            default: {
                qtSpout.setDataVolume(1024);
            }
        }
        ((SpoutDeclarer)builder.setSpout(qtSpoutName, (IRichSpout)qtSpout, (Number)qtSpoutParallelism).addConfigurations(confSpout)).setNumTasks((Number)qtSpoutNumTasks);
        ((BoltDeclarer)builder.setBolt("exclaim1", (IRichBolt)new ExclamationBolt(), (Number)1).shuffleGrouping(qtSpoutName)).setNumTasks((Number)1);
        ((BoltDeclarer)builder.setBolt("exclaim2", (IRichBolt)new ExclamationBolt(), (Number)2).shuffleGrouping("exclaim1")).setNumTasks((Number)2);
        Config conf = new Config();
        conf.setDebug(true);
        conf.setNumWorkers(1);
        conf.registerMetricsConsumer(LoggingMetricsConsumer.class, 1L);
        StormSubmitter.submitTopology((String)"topology-qt", (Map)conf, (StormTopology)builder.createTopology());
    }
}

