/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.test;

/**
 * Notify the application that testing is failed.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 98dbe69b48d221b5a7f7fd4cd7355f3f8236dc27 $
 * @since 1.0
 */
public class TestingFailedException extends Exception {

    /**
     * Ctor.
     */
    public TestingFailedException() {
        this("Testing failed.");
    }

    /**
     * Ctor.
     * @param msg Error message.
     */
    public TestingFailedException(final String msg) {
        super(msg);
    }

    /**
     * Ctor.
     * @param exp Error message.
     */
    public TestingFailedException(final Exception exp) {
        super(exp);
    }

}
