/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.termination;

/**
 * Represent current application process.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 58ae46f74b5dfa0a0dbfe58c9001314ed1e65769 $
 * @since 1.0
 */
public interface Runtime {

    /**
     * Shutdown current console application with particular exit code
     * in order to notify the parent system process (for example bash script).
     * @param code Exit code.
     */
    void shutdownWith(final int code);

    /**
     * Fake implementation for unit testing purposes.
     * @checkstyle JavadocMethodCheck (20 lines)
     * @checkstyle JavadocVariableCheck (20 lines)
     * @checkstyle HiddenFieldCheck (10 lines)
     */
    class Fake implements Runtime {

        private int code;

        @Override
        public void shutdownWith(final int code) {
            this.code = code;
        }

        public int exitCode() {
            return this.code;
        }
    }
}
