/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.scalar;

/**
 * Throwing when condition in {@link StrictIf} is false.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 133fd38bd3b2b72da3666cc865b40e8f6abb2f95 $
 * @since 1.0
 */
public final class ConditionNotSatisfiedException extends Exception {

    /**
     * Ctor.
     */
    public ConditionNotSatisfiedException() {
        super();
    }

    /**
     * Ctor.
     * @param msg Origin.
     */
    public ConditionNotSatisfiedException(final String msg) {
        super(msg);
    }

    /**
     * Ctor.
     * @param cause Origin.
     */
    public ConditionNotSatisfiedException(final Exception cause) {
        super(cause);
    }

}
