/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.docker.process;

import com.github.dgroup.dockertest.docker.DockerProcessExecutionException;
import com.github.dgroup.dockertest.docker.Process;
import com.github.dgroup.dockertest.docker.ProcessOf;
import com.github.dgroup.dockertest.docker.output.CmdOutputOf;
import java.io.IOException;
import java.util.List;
import org.cactoos.Scalar;
import org.cactoos.list.ListOf;
import org.cactoos.scalar.UncheckedScalar;

/**
 * Represents an instance of docker process on Unix-related systems.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: de47fab7efd390ffcacf90184b7a71d384a0671c $
 * @since 1.0
 */
public final class SystemUnixDockerProcess extends DockerProcessEnvelope {

    /**
     * Ctor.
     * @param cmd Docker container command.
     */
    public SystemUnixDockerProcess(final String... cmd) {
        this(new ListOf<>(cmd));
    }

    /**
     * Ctor.
     * @param cmd Docker container command.
     */
    public SystemUnixDockerProcess(final List<String> cmd) {
        this(() -> new ProcessOf(cmd));
    }

    /**
     * Ctor.
     * @param process System process associated with docker container.
     */
    public SystemUnixDockerProcess(final Scalar<Process> process) {
        super(() -> {
            try {
                return new CmdOutputOf(
                    new UncheckedScalar<>(process).value().execute()
                );
            } catch (final IOException ex) {
                throw new DockerProcessExecutionException(ex);
            }
        });
    }

}
