/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.docker.process;

import com.github.dgroup.dockertest.docker.DockerProcessExecutionException;
import com.github.dgroup.dockertest.docker.output.CmdOutput;
import java.io.UncheckedIOException;
import org.cactoos.Scalar;
import org.cactoos.scalar.UncheckedScalar;

/**
 * Envelope for {@link DockerProcess}.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 7d38ec8b8cab05fdc463fa65efc2dd8f79ab6eab $
 * @since 1.0
 */
class DockerProcessEnvelope implements DockerProcess {

    /**
     * Origin.
     */
    private final Scalar<DockerProcess> origin;

    /**
     * Ctor.
     * @param origin Origin.
     */
    DockerProcessEnvelope(final DockerProcess origin) {
        this(() -> origin);
    }

    /**
     * Ctor.
     * @param origin Origin.
     */
    DockerProcessEnvelope(final Scalar<DockerProcess> origin) {
        this.origin = origin;
    }

    @Override
    public CmdOutput execute() throws DockerProcessExecutionException {
        try {
            return new UncheckedScalar<>(this.origin).value().execute();
        } catch (final UncheckedIOException exp) {
            throw new DockerProcessExecutionException(exp);
        }
    }
}
