/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.concurrent.scalar;

import com.github.dgroup.dockertest.text.Text;
import org.cactoos.Scalar;

/**
 * Rename the {@link Thread} within the particular pattern.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 8da0ab709bb1067cab35b53d9f51231aee528c5b $
 * @since 1.0
 */
public final class Named implements Scalar<Thread> {

    /**
     * Renaming pattern.
     */
    private final Scalar<Text> pattern;
    /**
     * Origin.
     */
    private final Scalar<Thread> thread;

    /**
     * Ctor.
     * @param pattern For renaming.
     * @param thread Origin.
     */
    public Named(final Text pattern, final Scalar<Thread> thread) {
        this(() -> pattern, thread);
    }

    /**
     * Ctor.
     * @param pattern For renaming.
     * @param thread Origin.
     */
    public Named(final Scalar<Text> pattern, final Scalar<Thread> thread) {
        this.pattern = pattern;
        this.thread = thread;
    }

    @Override
    public Thread value() throws Exception {
        final Thread trd = this.thread.value();
        trd.setName(this.pattern.value().text());
        return trd;
    }
}
