/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.concurrent.func;

import com.github.dgroup.dockertest.concurrent.Timeout;
import java.util.concurrent.Future;
import org.cactoos.Func;
import org.cactoos.Scalar;
import org.cactoos.scalar.UncheckedScalar;

/**
 * Fetch result from {@link Future} within particular timeout.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: b3dcf8b13d249d97dde3456340a8edb1d2ae565b $
 * @param <X> Type of item.
 * @since 1.0
 */
public final class TimingOut<X> implements Func<Future<X>, X> {

    /**
     * Origin timeout.
     */
    private final Scalar<Timeout> timeout;

    /**
     * Ctor.
     * @param timeout For fetching of the result.
     */
    public TimingOut(final Scalar<Timeout> timeout) {
        this.timeout = timeout;
    }

    @Override
    public X apply(final Future<X> future) throws Exception {
        final Timeout tmt = new UncheckedScalar<>(this.timeout).value();
        return future.get(tmt.timeout(), tmt.measure());
    }

}
