/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;

/**
 * Fake instance of {@link java.util.concurrent.ExecutorService} for unit
 *  testing purposes.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: ea843ecf268661ef59e098c7defa45b976b3e131 $
 * @param <X> Type of item.
 * @since 1.0
 */
public final class ExcsrvFake<X> extends ExcsrvEnvelope<X> {

    /**
     * Ctor.
     */
    public ExcsrvFake() {
        this(new SimplifiedFuture.Fake<>());
    }

    /**
     * Ctor.
     * @param fnc The function to map the {@link Callable} to the {@link Future}
     */
    public ExcsrvFake(final SimplifiedFuture<X> fnc) {
        super(fnc);
    }

}
