/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.cmd;

import com.github.dgroup.dockertest.text.Text;

/**
 * Thrown in case if command-line argument is required,
 * but not found in the arguments specified by user.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: 3c4b0cb9d947243c00a707672f02f1df552229e8 $
 * @since 1.0
 */
public class CmdArgNotFoundException extends Exception {

    /**
     * Ctor.
     * @param cause Origin.
     */
    public CmdArgNotFoundException(final Exception cause) {
        super(cause);
    }

    /**
     * Ctor.
     * @param msg Detailed description with missing argument.
     */
    public CmdArgNotFoundException(final Text msg) {
        super(msg.text());
    }

}
