/**
 * MIT License
 *
 * Copyright (c) 2017 Yurii Dubinka
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom
 * the Software is  furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE
 * OR OTHER DEALINGS IN THE SOFTWARE.
 */
package com.github.dgroup.dockertest.cmd;

import java.util.List;

/**
 * Default implementation for single command-line argument.
 *
 * @author Yurii Dubinka (yurii.dubinka@gmail.com)
 * @version $Id: d0105e6d3866c57637da50f90e148692df6b24ff $
 * @since 1.0
 */
public final class ArgOf extends ArgEnvelope<String> {

    /**
     * Ctor.
     * @param name Cmd argument name.
     * @param args All cmd arguments.
     */
    public ArgOf(final String name, final List<String> args) {
        super(name, args, arg -> arg);
    }

    /**
     * Ctor.
     * @param name Cmd argument name.
     * @param args All cmd arguments.
     * @param msg Error message in case if arguments wasn't specified by user.
     */
    public ArgOf(final String name, final List<String> args, final String msg) {
        super(name, args, arg -> arg, () -> () -> msg);
    }

}
